/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs.builders.machine;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.client.instance.SplitShaftInstance;
import com.gregtechceu.gtceu.client.renderer.machine.KineticWorkableTieredHullMachineRenderer;
import com.gregtechceu.gtceu.common.block.KineticMachineBlock;
import com.gregtechceu.gtceu.common.blockentity.KineticMachineBlockEntity;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.machine.KineticMachineDefinition;
import com.gregtechceu.gtceu.common.machine.kinetic.SimpleKineticElectricWorkableMachine;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.MachineFunctionPresets;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.ints.Int2LongFunction;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;

public class KineticMachineBuilder
extends MachineBuilder<KineticMachineDefinition> {
    public transient Int2LongFunction tankScalingFunction = GTMachines.defaultTankSizeFunction;
    private final Object[] passedArguments;

    public KineticMachineBuilder(String name, boolean isSource, int tier, Object ... args) {
        super(GTRegistries.REGISTRATE, name, (ResourceLocation id) -> new KineticMachineDefinition((ResourceLocation)id, isSource, GTValues.V[tier]), (IMachineBlockEntity holder) -> new SimpleKineticElectricWorkableMachine((IMachineBlockEntity)holder, tier, GTMachines.defaultTankSizeFunction, args), KineticMachineBlock::new, MetaMachineItem::new, KineticMachineBlockEntity::create);
        this.passedArguments = args;
    }

    public KineticMachineBuilder isSource(boolean isSource) {
        this.definitionFactory(id -> new KineticMachineDefinition((ResourceLocation)id, isSource, GTValues.V[this.tier()]));
        return this;
    }

    public KineticMachineBuilder tankScalingFunction(Function<Object, Double> tankScalingFunction) {
        this.tankScalingFunction = tier -> ((Double)tankScalingFunction.apply(tier)).longValue();
        this.metaMachine(holder -> new SimpleKineticElectricWorkableMachine((IMachineBlockEntity)holder, this.tier(), this.tankScalingFunction, this.passedArguments));
        return this;
    }

    public KineticMachineBuilder tier(int tier) {
        return (KineticMachineBuilder)super.tier(tier);
    }

    public KineticMachineBuilder hasTESR(boolean hasTESR) {
        return (KineticMachineBuilder)super.hasTESR(hasTESR);
    }

    public KineticMachineBuilder onBlockEntityRegister(NonNullConsumer<BlockEntityType<BlockEntity>> onBlockEntityRegister) {
        return (KineticMachineBuilder)super.onBlockEntityRegister(onBlockEntityRegister);
    }

    private static KineticMachineBuilder[] tieredMachines(String name, BiConsumer<MachineBuilder<KineticMachineDefinition>, Integer> builderConsumer, Integer ... tiers) {
        KineticMachineBuilder[] builders = new KineticMachineBuilder[15];
        Integer[] integerArray = tiers;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int tier = integerArray[i];
            MachineBuilder register = new KineticMachineBuilder(GTValues.VN[tier].toLowerCase(Locale.ROOT) + "_" + name, false, tier, new Object[0]).tier(tier).hasTESR(true).onBlockEntityRegister(type -> KineticMachineBlockEntity.onBlockEntityRegister(type, (NonNullSupplier<BiFunction<MaterialManager, KineticMachineBlockEntity, BlockEntityInstance<? super KineticMachineBlockEntity>>>)((NonNullSupplier)() -> SplitShaftInstance::new), false));
            builderConsumer.accept(register, tier);
            builders[tier] = register;
        }
        return builders;
    }

    private static void simple(MachineBuilder<KineticMachineDefinition> builder, int tier) {
        builder.langValue("%s %s %s".formatted(GTValues.VLVH[tier], FormattingUtil.toEnglishName(builder.id.m_135815_()), GTValues.VLVT[tier])).rotationState(RotationState.NON_Y_AXIS).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60988_)).blockProp((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60955_)).recipeModifier(GTRecipeModifiers.ELECTRIC_OVERCLOCK.apply(OverclockingLogic.NON_PERFECT_OVERCLOCK)).renderer(() -> new KineticWorkableTieredHullMachineRenderer(tier, GTCEu.id("block/machine/kinetic_electric_machine"), GTCEu.id("block/machines/" + builder.id.m_135815_()))).tooltips(GTMachines.explosion());
    }

    public static MachineBuilder<KineticMachineDefinition> createAll(String name, Object ... args) {
        MachineBuilder[] builders = KineticMachineBuilder.tieredMachines(name, KineticMachineBuilder::simple, MachineFunctionPresets.mapTierArray(args));
        return MachineFunctionPresets.builder((String)name, (MachineBuilder[])builders, KineticMachineBuilder.class, id -> new KineticMachineDefinition((ResourceLocation)id, false, 0.0f), KineticMachineBlock::new, KineticMachineBlockEntity::create);
    }
}

