/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.kjs;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.Element;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialFlags;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconSet;
import com.gregtechceu.gtceu.api.data.chemical.material.info.MaterialIconType;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.BiomeWeightModifier;
import com.gregtechceu.gtceu.api.data.worldgen.GTLayerPattern;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.IWorldGenLayer;
import com.gregtechceu.gtceu.api.data.worldgen.WorldGenLayers;
import com.gregtechceu.gtceu.api.data.worldgen.generator.IndicatorGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.VeinGenerator;
import com.gregtechceu.gtceu.api.data.worldgen.generator.veins.DikeVeinGenerator;
import com.gregtechceu.gtceu.api.fluids.FluidBuilder;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.attribute.FluidAttributes;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorageKeys;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.pattern.FactoryBlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.pattern.Predicates;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.OverclockingLogic;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.CommonProxy;
import com.gregtechceu.gtceu.common.data.GCyMBlocks;
import com.gregtechceu.gtceu.common.data.GCyMMachines;
import com.gregtechceu.gtceu.common.data.GTBlocks;
import com.gregtechceu.gtceu.common.data.GTElements;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.common.data.GTOres;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.integration.kjs.GTCEuServerEvents;
import com.gregtechceu.gtceu.integration.kjs.GTCEuStartupEvents;
import com.gregtechceu.gtceu.integration.kjs.GTRegistryObjectBuilderTypes;
import com.gregtechceu.gtceu.integration.kjs.builders.ElementBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.GTRecipeTypeBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.MaterialIconSetBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.MaterialIconTypeBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.WorldGenLayerBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.block.CoilBlockBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.block.RendererBlockBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.block.RendererGlassBlockBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.CustomMultiblockBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.CustomTieredMachineBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.GeneratorBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.KineticMachineBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.SimpleMachineBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.machine.SteamMachineBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.prefix.BasicTagPrefixBuilder;
import com.gregtechceu.gtceu.integration.kjs.builders.prefix.OreTagPrefixBuilder;
import com.gregtechceu.gtceu.integration.kjs.helpers.MaterialStackWrapper;
import com.gregtechceu.gtceu.integration.kjs.recipe.GTRecipeSchema;
import com.gregtechceu.gtceu.integration.kjs.recipe.components.GTRecipeComponents;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import dev.latvian.mods.kubejs.KubeJSPlugin;
import dev.latvian.mods.kubejs.block.state.BlockStatePredicate;
import dev.latvian.mods.kubejs.recipe.schema.RegisterRecipeSchemasEvent;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.script.BindingsEvent;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.ClassFilter;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.mod.util.NBTUtils;
import dev.latvian.mods.rhino.util.wrap.TypeWrappers;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;

public class GregTechKubeJSPlugin
extends KubeJSPlugin {
    public void initStartup() {
        super.initStartup();
        CommonProxy.onKubeJSSetup();
    }

    public void init() {
        super.init();
        GTRegistryObjectBuilderTypes.ELEMENT.addType("basic", ElementBuilder.class, ElementBuilder::new, true);
        GTRegistryObjectBuilderTypes.MATERIAL_ICON_SET.addType("basic", MaterialIconSetBuilder.class, MaterialIconSetBuilder::new, true);
        GTRegistryObjectBuilderTypes.MATERIAL_ICON_TYPE.addType("basic", MaterialIconTypeBuilder.class, MaterialIconTypeBuilder::new, true);
        GTRegistryObjectBuilderTypes.MATERIAL.addType("basic", Material.Builder.class, Material.Builder::new, true);
        GTRegistryObjectBuilderTypes.RECIPE_TYPE.addType("basic", GTRecipeTypeBuilder.class, GTRecipeTypeBuilder::new, true);
        GTRegistryObjectBuilderTypes.MACHINE.addType("simple", SimpleMachineBuilder.class, (id, args) -> SimpleMachineBuilder.createAll(id.m_135815_(), args), true);
        GTRegistryObjectBuilderTypes.MACHINE.addType("custom", CustomTieredMachineBuilder.class, (id, args) -> CustomTieredMachineBuilder.createAll(id.m_135815_(), args), false);
        GTRegistryObjectBuilderTypes.MACHINE.addType("steam", SteamMachineBuilder.class, (id, args) -> SteamMachineBuilder.createBoth(id.m_135815_(), args), false);
        GTRegistryObjectBuilderTypes.MACHINE.addType("generator", GeneratorBuilder.class, (id, args) -> GeneratorBuilder.createAll(id.m_135815_(), args), false);
        GTRegistryObjectBuilderTypes.MACHINE.addType("multiblock", CustomMultiblockBuilder.class, (id, args) -> CustomMultiblockBuilder.createMultiblock(id.m_135815_(), args), false);
        GTRegistryObjectBuilderTypes.MACHINE.addType("primitive", CustomMultiblockBuilder.class, (id, args) -> CustomMultiblockBuilder.createPrimitiveMultiblock(id.m_135815_(), args), false);
        GTRegistryObjectBuilderTypes.MACHINE.addType("kinetic", KineticMachineBuilder.class, (id, args) -> KineticMachineBuilder.createAll(id.m_135815_(), args), false);
        GTRegistryObjectBuilderTypes.WORLD_GEN_LAYER.addType("basic", WorldGenLayerBuilder.class, WorldGenLayerBuilder::new, true);
        GTRegistryObjectBuilderTypes.TAG_PREFIX.addType("basic", BasicTagPrefixBuilder.class, BasicTagPrefixBuilder::new, true);
        GTRegistryObjectBuilderTypes.TAG_PREFIX.addType("ore", OreTagPrefixBuilder.class, OreTagPrefixBuilder::new, false);
        RegistryInfo.BLOCK.addType("gtceu:coil", CoilBlockBuilder.class, CoilBlockBuilder::new);
        RegistryInfo.BLOCK.addType("gtceu:renderer", RendererBlockBuilder.class, RendererBlockBuilder::new);
        RegistryInfo.BLOCK.addType("gtceu:renderer_glass", RendererGlassBlockBuilder.class, RendererGlassBlockBuilder::new);
    }

    public void registerEvents() {
        super.registerEvents();
        GTCEuStartupEvents.GROUP.register();
        GTCEuServerEvents.GROUP.register();
    }

    public void registerClasses(ScriptType type, ClassFilter filter) {
        super.registerClasses(type, filter);
        filter.allow("com.gregtechceu.gtceu");
    }

    public void registerRecipeSchemas(RegisterRecipeSchemasEvent event) {
        super.registerRecipeSchemas(event);
        for (Map.Entry entry : GTRegistries.RECIPE_TYPES.entries()) {
            event.register((ResourceLocation)entry.getKey(), GTRecipeSchema.SCHEMA);
        }
    }

    public void registerBindings(BindingsEvent event) {
        super.registerBindings(event);
        event.add("GTRegistries", GTRegistries.class);
        event.add("GTMaterials", GTMaterials.class);
        event.add("GTElements", GTElements.class);
        event.add("GTSoundEntries", GTSoundEntries.class);
        event.add("GTBlocks", GTBlocks.class);
        event.add("GCyMBlocks", GCyMBlocks.class);
        event.add("GTMachines", GTMachines.class);
        event.add("GCyMMachines", GCyMMachines.class);
        event.add("GTItems", GTItems.class);
        event.add("GTRecipeTypes", GTRecipeTypes.class);
        event.add("TagPrefix", TagPrefix.class);
        event.add("ItemGenerationCondition", TagPrefix.Conditions.class);
        event.add("UnificationEntry", UnificationEntry.class);
        event.add("RecipeCapability", RecipeCapability.class);
        event.add("GTFluidAttributes", FluidAttributes.class);
        event.add("GTFluidBuilder", FluidBuilder.class);
        event.add("GTFluidStorageKeys", FluidStorageKeys.class);
        event.add("GTFluidState", FluidState.class);
        event.add("PropertyKey", PropertyKey.class);
        event.add("CleanroomType", CleanroomType.class);
        event.add("ChemicalHelper", ChemicalHelper.class);
        event.add("GTValues", GTValues.class);
        event.add("GTMaterialIconSet", MaterialIconSet.class);
        event.add("GTMaterialIconType", MaterialIconType.class);
        event.add("GTMaterialFlags", MaterialFlags.class);
        event.add("GTToolType", GTToolType.class);
        event.add("RotationState", RotationState.class);
        event.add("FactoryBlockPattern", FactoryBlockPattern.class);
        event.add("MultiblockShapeInfo", MultiblockShapeInfo.class);
        event.add("Predicates", Predicates.class);
        event.add("PartAbility", PartAbility.class);
        event.add("GuiTextures", GuiTextures.class);
        event.add("GTCEu", GTCEu.class);
        event.add("SoundType", SoundType.class);
        event.add("GTOreVein", GTOreDefinition.class);
        event.add("GTLayerPattern", GTLayerPattern.class);
        event.add("GTDikeBlockDefinition", DikeVeinGenerator.DikeBlockDefinition.class);
        event.add("GTOres", GTOres.class);
        event.add("GTRecipeModifiers", GTRecipeModifiers.class);
        event.add("OverclockingLogic", OverclockingLogic.class);
        event.add("GTWorldGenLayers", WorldGenLayers.class);
    }

    public void registerTypeWrappers(ScriptType type, TypeWrappers typeWrappers) {
        super.registerTypeWrappers(type, typeWrappers);
        typeWrappers.register(GTRecipeType.class, (ctx, o) -> {
            if (o instanceof Wrapper) {
                Wrapper w = (Wrapper)o;
                o = w.unwrap();
            }
            if (o instanceof GTRecipeType) {
                GTRecipeType recipeType = (GTRecipeType)o;
                return recipeType;
            }
            if (o instanceof CharSequence) {
                CharSequence chars = (CharSequence)o;
                return GTRecipeTypes.get(chars.toString());
            }
            return null;
        });
        typeWrappers.register(Element.class, (ctx, o) -> {
            if (o instanceof Element) {
                Element element = (Element)o;
                return element;
            }
            if (o instanceof CharSequence) {
                CharSequence chars = (CharSequence)o;
                return GTElements.get(chars.toString());
            }
            return null;
        });
        typeWrappers.register(Material.class, (ctx, o) -> {
            if (o instanceof Material) {
                Material material = (Material)o;
                return material;
            }
            if (o instanceof CharSequence) {
                CharSequence chars = (CharSequence)o;
                return GTMaterials.get(chars.toString());
            }
            return null;
        });
        typeWrappers.register(MachineDefinition.class, (ctx, o) -> {
            if (o instanceof MachineDefinition) {
                MachineDefinition definition = (MachineDefinition)o;
                return definition;
            }
            if (o instanceof CharSequence) {
                CharSequence chars = (CharSequence)o;
                return GTMachines.get(chars.toString());
            }
            return null;
        });
        typeWrappers.register(TagPrefix.class, (ctx, o) -> {
            if (o instanceof TagPrefix) {
                TagPrefix tagPrefix = (TagPrefix)o;
                return tagPrefix;
            }
            if (o instanceof CharSequence) {
                CharSequence chars = (CharSequence)o;
                return TagPrefix.get(chars.toString());
            }
            return null;
        });
        typeWrappers.register(UnificationEntry.class, (ctx, o) -> {
            if (o instanceof UnificationEntry) {
                UnificationEntry entry = (UnificationEntry)o;
                return entry;
            }
            if (o instanceof CharSequence) {
                CharSequence chars = (CharSequence)o;
                String[] values = chars.toString().split(":");
                if (values.length == 1) {
                    return new UnificationEntry(TagPrefix.get(values[0]));
                }
                if (values.length >= 2) {
                    return new UnificationEntry(TagPrefix.get(values[0]), GTMaterials.get(values[1]));
                }
            }
            return null;
        });
        typeWrappers.register(RecipeCapability.class, (ctx, o) -> {
            if (o instanceof RecipeCapability) {
                RecipeCapability capability = (RecipeCapability)o;
                return capability;
            }
            if (o instanceof CharSequence) {
                CharSequence chars = (CharSequence)o;
                return (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(chars.toString());
            }
            return null;
        });
        typeWrappers.register(MaterialIconSet.class, (ctx, o) -> {
            if (o instanceof MaterialIconSet) {
                MaterialIconSet iconSet = (MaterialIconSet)o;
                return iconSet;
            }
            if (o instanceof CharSequence) {
                CharSequence chars = (CharSequence)o;
                return MaterialIconSet.getByName(chars.toString());
            }
            return null;
        });
        typeWrappers.register(MaterialStack.class, (ctx, o) -> {
            if (o instanceof MaterialStack) {
                MaterialStack stack = (MaterialStack)o;
                return stack;
            }
            if (o instanceof Material) {
                Material material = (Material)o;
                return new MaterialStack(material, 1L);
            }
            if (o instanceof CharSequence) {
                CharSequence chars = (CharSequence)o;
                return MaterialStack.fromString(chars);
            }
            return null;
        });
        typeWrappers.register(MaterialStackWrapper.class, (ctx, o) -> {
            if (o instanceof MaterialStackWrapper) {
                MaterialStackWrapper wrapper = (MaterialStackWrapper)o;
                return wrapper;
            }
            if (o instanceof MaterialStack) {
                MaterialStack stack = (MaterialStack)o;
                return new MaterialStackWrapper(stack::material, stack.amount());
            }
            if (o instanceof Material) {
                Material material = (Material)o;
                return new MaterialStackWrapper(() -> material, 1L);
            }
            if (o instanceof CharSequence) {
                CharSequence chars = (CharSequence)o;
                return MaterialStackWrapper.fromString(chars);
            }
            return null;
        });
        typeWrappers.register(IWorldGenLayer.class, (ctx, o) -> {
            if (o instanceof IWorldGenLayer) {
                IWorldGenLayer layer = (IWorldGenLayer)o;
                return layer;
            }
            if (o instanceof CharSequence) {
                CharSequence chars = (CharSequence)o;
                return WorldGenLayers.getByName(chars.toString());
            }
            return null;
        });
        typeWrappers.register(HeightRangePlacement.class, (ctx, o) -> {
            if (o instanceof HeightRangePlacement) {
                HeightRangePlacement placement = (HeightRangePlacement)o;
                return placement;
            }
            return Optional.ofNullable(NBTUtils.toTagCompound((Object)o)).map(tag -> HeightRangePlacement.f_191673_.parse((DynamicOps)NbtOps.f_128958_, tag)).flatMap(DataResult::result).orElse(null);
        });
        typeWrappers.register(BiomeWeightModifier.class, (ctx, o) -> {
            if (o instanceof BiomeWeightModifier) {
                BiomeWeightModifier modifier = (BiomeWeightModifier)o;
                return modifier;
            }
            return Optional.ofNullable(NBTUtils.toTagCompound((Object)o)).map(tag -> BiomeWeightModifier.CODEC.parse((DynamicOps)NbtOps.f_128958_, tag)).flatMap(DataResult::result).orElse(null);
        });
        typeWrappers.register(VeinGenerator.class, (ctx, o) -> {
            if (o instanceof VeinGenerator) {
                VeinGenerator generator = (VeinGenerator)o;
                return generator;
            }
            return Optional.ofNullable(NBTUtils.toTagCompound((Object)o)).map(tag -> VeinGenerator.DIRECT_CODEC.parse((DynamicOps)NbtOps.f_128958_, tag)).flatMap(DataResult::result).orElse(null);
        });
        typeWrappers.register(IndicatorGenerator.class, (ctx, o) -> {
            if (o instanceof IndicatorGenerator) {
                IndicatorGenerator generator = (IndicatorGenerator)o;
                return generator;
            }
            return Optional.ofNullable(NBTUtils.toTagCompound((Object)o)).map(tag -> IndicatorGenerator.DIRECT_CODEC.parse((DynamicOps)NbtOps.f_128958_, tag)).flatMap(DataResult::result).orElse(null);
        });
        typeWrappers.register(IWorldGenLayer.RuleTestSupplier.class, (ctx, o) -> {
            if (o instanceof IWorldGenLayer.RuleTestSupplier) {
                IWorldGenLayer.RuleTestSupplier supplier = (IWorldGenLayer.RuleTestSupplier)o;
                return supplier;
            }
            return () -> BlockStatePredicate.ruleTestOf((Object)o);
        });
        typeWrappers.registerSimple(GTRecipeComponents.FluidIngredientJS.class, GTRecipeComponents.FluidIngredientJS::of);
    }
}

