/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.jei;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.integration.jei.multipage.MultiblockInfoCategory;
import com.gregtechceu.gtceu.integration.jei.oreprocessing.GTOreProcessingInfoCategory;
import com.gregtechceu.gtceu.integration.jei.orevein.GTBedrockFluidInfoCategory;
import com.gregtechceu.gtceu.integration.jei.orevein.GTOreVeinInfoCategory;
import com.gregtechceu.gtceu.integration.jei.recipe.GTRecipeTypeCategory;
import com.lowdragmc.lowdraglib.LDLib;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
@JeiPlugin
public class GTJEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return GTCEu.id("jei_plugin");
    }

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registry) {
        if (LDLib.isReiLoaded() || LDLib.isEmiLoaded()) {
            return;
        }
        GTCEu.LOGGER.info("JEI register categories");
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        registry.addRecipeCategories(new IRecipeCategory[]{new MultiblockInfoCategory(jeiHelpers)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GTOreProcessingInfoCategory(jeiHelpers)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GTOreVeinInfoCategory(jeiHelpers)});
        registry.addRecipeCategories(new IRecipeCategory[]{new GTBedrockFluidInfoCategory(jeiHelpers)});
        for (net.minecraft.world.item.crafting.RecipeType recipeType : BuiltInRegistries.f_256990_) {
            if (!(recipeType instanceof GTRecipeType)) continue;
            GTRecipeType gtRecipeType = (GTRecipeType)recipeType;
            registry.addRecipeCategories(new IRecipeCategory[]{new GTRecipeTypeCategory(jeiHelpers, gtRecipeType)});
        }
    }

    public void registerRecipeCatalysts(@Nonnull IRecipeCatalystRegistration registration) {
        if (LDLib.isReiLoaded() || LDLib.isEmiLoaded()) {
            return;
        }
        MultiblockInfoCategory.registerRecipeCatalysts(registration);
        GTRecipeTypeCategory.registerRecipeCatalysts(registration);
        GTOreProcessingInfoCategory.registerRecipeCatalysts(registration);
        GTOreVeinInfoCategory.registerRecipeCatalysts(registration);
        GTBedrockFluidInfoCategory.registerRecipeCatalysts(registration);
        for (MachineDefinition definition : GTMachines.ELECTRIC_FURNACE) {
            if (definition == null) continue;
            registration.addRecipeCatalyst(definition.asStack(), new RecipeType[]{RecipeTypes.SMELTING});
        }
        registration.addRecipeCatalyst(((MachineDefinition)GTMachines.STEAM_FURNACE.left()).asStack(), new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(((MachineDefinition)GTMachines.STEAM_FURNACE.right()).asStack(), new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(GTMachines.STEAM_OVEN.asStack(), new RecipeType[]{RecipeTypes.SMELTING});
        registration.addRecipeCatalyst(GTMachines.MULTI_SMELTER.asStack(), new RecipeType[]{RecipeTypes.SMELTING});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        if (LDLib.isReiLoaded() || LDLib.isEmiLoaded()) {
            return;
        }
        GTCEu.LOGGER.info("JEI register");
        MultiblockInfoCategory.registerRecipes(registration);
        GTRecipeTypeCategory.registerRecipes(registration);
        GTOreProcessingInfoCategory.registerRecipes(registration);
        GTOreVeinInfoCategory.registerRecipes(registration);
        GTBedrockFluidInfoCategory.registerRecipes(registration);
    }

    public void registerIngredients(@Nonnull IModIngredientRegistration registry) {
        if (LDLib.isReiLoaded() || LDLib.isEmiLoaded()) {
            return;
        }
        GTCEu.LOGGER.info("JEI register ingredients");
    }
}

