/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.emi.oreprocessing;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.integration.GTOreProcessingWidget;
import com.gregtechceu.gtceu.integration.emi.oreprocessing.GTOreProcessingEmiCategory;
import com.lowdragmc.lowdraglib.emi.ModularEmiRecipe;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GTEmiOreProcessing
extends ModularEmiRecipe<WidgetGroup> {
    final Material material;

    public GTEmiOreProcessing(Material material) {
        super(() -> new GTOreProcessingWidget(material));
        this.material = material;
    }

    public EmiRecipeCategory getCategory() {
        return GTOreProcessingEmiCategory.CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return GTCEu.id(this.material.getName());
    }

    public List<EmiIngredient> getInputs() {
        ArrayList<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
        inputs.add(EmiIngredient.of(ChemicalHelper.getTag(TagPrefix.ore, this.material)));
        inputs.add(EmiIngredient.of(ChemicalHelper.getTag(TagPrefix.rawOre, this.material)));
        return inputs;
    }

    public List<EmiStack> getOutputs() {
        ArrayList<EmiStack> outputs = new ArrayList<EmiStack>();
        outputs.add(EmiStack.of((ItemStack)ChemicalHelper.get(TagPrefix.crushed, this.material)));
        outputs.add(EmiStack.of((ItemStack)ChemicalHelper.get(TagPrefix.crushedPurified, this.material)));
        outputs.add(EmiStack.of((ItemStack)ChemicalHelper.get(TagPrefix.crushedRefined, this.material)));
        outputs.add(EmiStack.of((ItemStack)ChemicalHelper.get(TagPrefix.dust, this.material)));
        outputs.add(EmiStack.of((ItemStack)ChemicalHelper.get(TagPrefix.dustImpure, this.material)));
        outputs.add(EmiStack.of((ItemStack)ChemicalHelper.get(TagPrefix.dustPure, this.material)));
        return outputs;
    }
}

