/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.config.Actionable;
import appeng.api.networking.GridHelper;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.helpers.externalstorage.GenericStackInv;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.AEItemGridWidget;
import com.gregtechceu.gtceu.integration.ae2.machine.MEBusPartMachine;
import com.gregtechceu.gtceu.integration.ae2.util.SerializableGenericStackInv;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MEOutputBusPartMachine
extends MEBusPartMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEOutputBusPartMachine.class, MEBusPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private SerializableGenericStackInv internalBuffer;

    public MEOutputBusPartMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, IO.OUT, args);
    }

    @Override
    protected NotifiableItemStackHandler createInventory(Object ... args) {
        this.internalBuffer = new SerializableGenericStackInv(this::onChanged, 16);
        return new InaccessibleInfiniteSlot(this, this.internalBuffer);
    }

    @Override
    public void autoIO() {
        if (this.getLevel().f_46443_) {
            return;
        }
        if (!this.isWorkingEnabled()) {
            return;
        }
        if (!this.shouldSyncME()) {
            return;
        }
        if (this.updateMEStatus()) {
            if (!this.internalBuffer.isEmpty()) {
                MEStorage aeNetwork = this.getMainNode().getGrid().getStorageService().getInventory();
                for (int slot = 0; slot < this.internalBuffer.size(); ++slot) {
                    GenericStack item = this.internalBuffer.getStack(slot);
                    if (item == null) continue;
                    long inserted = aeNetwork.insert(item.what(), item.amount(), Actionable.MODULATE, this.actionSource);
                    if (inserted > 0L) {
                        item = new GenericStack(item.what(), item.amount() - inserted);
                    }
                    this.internalBuffer.setStack(slot, item.amount() == 0L ? null : item);
                }
            }
            this.updateInventorySubscription();
        }
    }

    @Override
    public void onUnload() {
        if (this.getMainNode().getGrid() == null) {
            return;
        }
        MEStorage aeNetwork = this.getMainNode().getGrid().getStorageService().getInventory();
        for (int slot = 0; slot < this.internalBuffer.size(); ++slot) {
            GenericStack stack = this.internalBuffer.getStack(slot);
            if (stack == null) continue;
            aeNetwork.insert(stack.what(), stack.amount(), Actionable.MODULATE, this.actionSource);
        }
        super.onUnload();
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(new Position(0, 0));
        group.addWidget((Widget)new LabelWidget(10, 15, () -> this.isOnline ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        group.addWidget((Widget)new LabelWidget(10, 25, "gtceu.gui.waiting_list"));
        group.addWidget((Widget)new AEItemGridWidget(10, 35, 3, (GenericInternalInventory)this.internalBuffer));
        return group;
    }

    @Override
    protected void updateInventorySubscription() {
        if (this.isWorkingEnabled() && !this.internalBuffer.isEmpty() && this.getLevel() != null && GridHelper.getNodeHost((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(this.getFrontFacing())) != null) {
            this.autoIOSubs = this.subscribeServerTick(this.autoIOSubs, this::autoIO);
        } else if (this.autoIOSubs != null) {
            this.autoIOSubs.unsubscribe();
            this.autoIOSubs = null;
        }
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    private static class InaccessibleInfiniteSlot
    extends NotifiableItemStackHandler
    implements IItemTransfer {
        protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(InaccessibleInfiniteSlot.class);
        private final GenericStackInv internalBuffer;

        public InaccessibleInfiniteSlot(MetaMachine holder, GenericStackInv internalBuffer) {
            super(holder, internalBuffer.size(), IO.OUT);
            this.internalBuffer = internalBuffer;
        }

        @Override
        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            GenericStack stack1 = GenericStack.fromItemStack((ItemStack)stack);
            this.internalBuffer.insert(slot, stack1.what(), stack1.amount(), Actionable.MODULATE);
            this.machine.onChanged();
        }

        @Override
        public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, @Nullable String slotName, boolean simulate) {
            return InaccessibleInfiniteSlot.handleIngredient(io, left, simulate, this.handlerIO, new ItemStackTransfer(16){

                @NotNull
                public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate, boolean notifyChanges) {
                    return this.insertItem(slot, stack, simulate, notifyChanges);
                }
            });
        }

        @Override
        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate, boolean notifyChanges) {
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (!simulate) {
                IActionSource iActionSource;
                GenericStack stack1 = GenericStack.fromItemStack((ItemStack)stack);
                AEKey aEKey = stack1.what();
                long l = stack1.amount();
                MetaMachine metaMachine = this.machine;
                if (metaMachine instanceof MEBusPartMachine) {
                    MEBusPartMachine host = (MEBusPartMachine)metaMachine;
                    iActionSource = host.actionSource;
                } else {
                    iActionSource = IActionSource.empty();
                }
                this.internalBuffer.insert(aEKey, l, Actionable.MODULATE, iActionSource);
                this.machine.onChanged();
            }
            return ItemStack.f_41583_;
        }

        @Override
        public int getSlots() {
            return 1;
        }

        @Override
        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.f_41583_;
        }

        @Override
        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
            return ItemStack.f_41583_;
        }

        @Override
        public int getSlotLimit(int slot) {
            return 0x7FFFFFFE;
        }

        @Override
        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }

        @Override
        @NotNull
        public Object createSnapshot() {
            GenericStack[] stacks = new GenericStack[this.internalBuffer.size()];
            for (int i = 0; i < this.internalBuffer.size(); ++i) {
                stacks[i] = this.internalBuffer.getStack(i);
            }
            return stacks;
        }

        @Override
        public void restoreFromSnapshot(Object snapshot) {
            if (snapshot instanceof GenericStack[]) {
                GenericStack[] stacks = (GenericStack[])snapshot;
                this.internalBuffer.beginBatch();
                for (int i = 0; i < stacks.length; ++i) {
                    GenericStack stack = stacks[i];
                    if (stack == null) continue;
                    this.internalBuffer.insert(i, stack.what(), stack.amount(), Actionable.MODULATE);
                }
                this.internalBuffer.endBatch();
            }
        }

        @Override
        public ManagedFieldHolder getFieldHolder() {
            return MANAGED_FIELD_HOLDER;
        }
    }
}

