/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration.ae2.machine;

import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.integration.ae2.gui.widget.AEItemConfigWidget;
import com.gregtechceu.gtceu.integration.ae2.machine.MEBusPartMachine;
import com.gregtechceu.gtceu.integration.ae2.util.ExportOnlyAESlot;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.lowdraglib.utils.Position;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MEInputBusPartMachine
extends MEBusPartMachine
implements IInWorldGridNodeHost,
IGridConnectedBlockEntity {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEInputBusPartMachine.class, MEBusPartMachine.MANAGED_FIELD_HOLDER);
    private static final int CONFIG_SIZE = 16;
    private ExportOnlyAEItemList aeItemHandler;
    private IGrid aeProxy;

    public MEInputBusPartMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, IO.IN, args);
    }

    @Override
    protected NotifiableItemStackHandler createInventory(Object ... args) {
        this.aeItemHandler = new ExportOnlyAEItemList(this, 16);
        return this.aeItemHandler;
    }

    @Override
    public void autoIO() {
        if (this.getLevel().f_46443_) {
            return;
        }
        if (!this.isWorkingEnabled()) {
            return;
        }
        if (!this.shouldSyncME()) {
            return;
        }
        if (this.updateMEStatus()) {
            MEStorage aeNetwork = this.getMainNode().getGrid().getStorageService().getInventory();
            for (ExportOnlyAEItem aeSlot : this.aeItemHandler.inventory) {
                long extracted;
                GenericStack reqItem;
                GenericStack exceedItem = aeSlot.exceedStack();
                if (exceedItem != null) {
                    long total = exceedItem.amount();
                    long inserted = aeNetwork.insert(exceedItem.what(), exceedItem.amount(), Actionable.MODULATE, this.actionSource);
                    if (inserted > 0L) {
                        aeSlot.extractItem(0, (int)inserted, false);
                        continue;
                    }
                    aeSlot.extractItem(0, (int)total, false);
                }
                if ((reqItem = aeSlot.requestStack()) == null || (extracted = aeNetwork.extract(reqItem.what(), reqItem.amount(), Actionable.MODULATE, this.actionSource)) == 0L) continue;
                aeSlot.addStack(new GenericStack(reqItem.what(), extracted));
            }
            this.updateInventorySubscription();
        }
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(new Position(0, 0));
        group.addWidget((Widget)new LabelWidget(3, 0, () -> this.isOnline ? "gtceu.gui.me_network.online" : "gtceu.gui.me_network.offline"));
        group.addWidget((Widget)new AEItemConfigWidget(3, 10, this.aeItemHandler.inventory));
        return group;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    private static class ExportOnlyAEItemList
    extends NotifiableItemStackHandler {
        public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ExportOnlyAEItemList.class, NotifiableItemStackHandler.MANAGED_FIELD_HOLDER);
        @Persisted
        ExportOnlyAEItem[] inventory = new ExportOnlyAEItem[16];

        public ExportOnlyAEItemList(MetaMachine holder, int slots) {
            super(holder, slots, IO.IN);
            for (int i = 0; i < 16; ++i) {
                this.inventory[i] = new ExportOnlyAEItem(null, null);
            }
            for (ExportOnlyAEItem slot : this.inventory) {
                slot.setOnContentsChanged(this::onContentsChanged);
            }
        }

        @Override
        public void onContentsChanged() {
            super.onContentsChanged();
            this.machine.onChanged();
        }

        @Override
        public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, @Nullable String slotName, boolean simulate) {
            return ExportOnlyAEItemList.handleIngredient(io, left, simulate, this.handlerIO, new ItemStackTransfer(NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])((ItemStack[])Arrays.stream(this.inventory).map(item -> item.getStackInSlot(0)).toArray(ItemStack[]::new)))){

                @NotNull
                public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
                    ItemStack extracted = super.extractItem(slot, amount, simulate, notifyChanges);
                    if (!extracted.m_41619_()) {
                        inventory[slot].extractItem(0, amount, simulate, notifyChanges);
                    }
                    return extracted;
                }
            });
        }

        @Override
        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        }

        @Override
        public int getSlots() {
            return 16;
        }

        @Override
        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (slot >= 0 && slot < 16) {
                return this.inventory[slot].getStackInSlot(0);
            }
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= 0 && slot < 16) {
                return this.inventory[slot].extractItem(0, amount, simulate);
            }
            return ItemStack.f_41583_;
        }

        @Override
        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        @Override
        public ManagedFieldHolder getFieldHolder() {
            return MANAGED_FIELD_HOLDER;
        }

        @Override
        @NotNull
        public Object createSnapshot() {
            return Arrays.stream(this.inventory).map(IItemTransfer::createSnapshot).toArray(Object[]::new);
        }

        @Override
        public void restoreFromSnapshot(Object snapshot) {
            Object[] array;
            if (snapshot instanceof Object[] && (array = (Object[])snapshot).length == this.inventory.length) {
                for (int i = 0; i < array.length; ++i) {
                    this.inventory[i].restoreFromSnapshot(array[i]);
                }
            }
        }
    }

    public static class ExportOnlyAEItem
    extends ExportOnlyAESlot
    implements IItemTransfer {
        public ExportOnlyAEItem(GenericStack config, GenericStack stock) {
            super(config, stock);
        }

        public ExportOnlyAEItem() {
        }

        @Override
        public ExportOnlyAEItem copy() {
            return new ExportOnlyAEItem(this.config == null ? null : ExportOnlyAEItem.copy(this.config), this.stock == null ? null : ExportOnlyAEItem.copy(this.stock));
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate, boolean notifyChanges) {
            return stack;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (slot == 0 && this.stock != null) {
                ItemStack itemStack;
                AEKey aEKey = this.stock.what();
                if (aEKey instanceof AEItemKey) {
                    AEItemKey itemKey = (AEItemKey)aEKey;
                    itemStack = itemKey.toStack((int)this.stock.amount());
                } else {
                    itemStack = ItemStack.f_41583_;
                }
                return itemStack;
            }
            return ItemStack.f_41583_;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
            if (slot == 0 && this.stock != null) {
                ItemStack itemStack;
                int extracted = (int)Math.min(this.stock.amount(), (long)amount);
                AEKey aEKey = this.stock.what();
                if (aEKey instanceof AEItemKey) {
                    AEItemKey itemKey = (AEItemKey)aEKey;
                    itemStack = itemKey.toStack((int)this.stock.amount());
                } else {
                    itemStack = ItemStack.f_41583_.m_41777_();
                }
                ItemStack result = itemStack;
                result.m_41764_(extracted);
                if (!simulate) {
                    this.stock = ExportOnlyAESlot.copy(this.stock, this.stock.amount() - (long)extracted);
                    if (this.stock.amount() == 0L) {
                        this.stock = null;
                    }
                }
                if (notifyChanges && this.onContentsChanged != null) {
                    this.onContentsChanged.run();
                }
                return result;
            }
            return ItemStack.f_41583_;
        }

        @Override
        public void addStack(GenericStack stack) {
            this.stock = this.stock == null ? stack : GenericStack.sum((GenericStack)this.stock, (GenericStack)stack);
            this.onContentsChanged.run();
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return false;
        }

        @NotNull
        public Object createSnapshot() {
            return Pair.of((Object)this.config, (Object)this.stock);
        }

        public void restoreFromSnapshot(Object snapshot) {
            if (snapshot instanceof Pair) {
                Pair pair = (Pair)snapshot;
                this.config = (GenericStack)pair.getFirst();
                this.stock = (GenericStack)pair.getSecond();
            }
        }
    }
}

