/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.integration;

import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.OreProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.common.data.GTMachines;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.PhantomSlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.utils.CycleItemStackHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.apache.commons.lang3.tuple.Pair;

public class GTOreProcessingWidget
extends WidgetGroup {
    public GTOreProcessingWidget(Material material) {
        super(0, 0, 186, 174);
        this.setClientSideWidget();
        ArrayList<List<ItemStack>> mainproducts = new ArrayList<List<ItemStack>>();
        ArrayList<List<ItemStack>> byproducts = new ArrayList<List<ItemStack>>();
        ArrayList<List<ItemStack>> machines = new ArrayList<List<ItemStack>>();
        ArrayList<Content> chanceContent = new ArrayList<Content>();
        OreProperty prop = material.getProperty(PropertyKey.ORE);
        this.addItemSlots(mainproducts, byproducts, material, prop, chanceContent);
        this.addMachineSlots(machines);
        this.setupGui(mainproducts, byproducts, machines, material, prop, chanceContent);
    }

    private void setupGui(List<List<ItemStack>> mainproducts, List<List<ItemStack>> byproducts, List<List<ItemStack>> machines, Material material, OreProperty prop, List<Content> chanceContent) {
        this.setupBaseGui(mainproducts, byproducts, machines, chanceContent);
        if (!material.hasProperty(PropertyKey.BLAST)) {
            this.setupSmeltGui(mainproducts, machines);
        }
        if (prop.getWashedIn().getLeft() != null) {
            this.setupChemGui(mainproducts, byproducts, machines, prop, chanceContent);
        }
        if (prop.getSeparatedInto() != null && !prop.getSeparatedInto().isEmpty()) {
            this.setupSepGui(mainproducts, byproducts, machines, chanceContent);
        }
        if (material.hasProperty(PropertyKey.GEM)) {
            this.setupSiftGui(mainproducts, byproducts, machines, chanceContent);
        }
    }

    private void setupBaseGui(List<List<ItemStack>> mainproducts, List<List<ItemStack>> byproducts, List<List<ItemStack>> machines, List<Content> chanceContent) {
        this.addWidget((Widget)new ImageWidget(0, 0, 186, 174, (IGuiTexture)GuiTextures.OREBY_BASE));
        this.setupBaseGuiItems(mainproducts, byproducts, chanceContent);
        this.setupBaseGuiMachines(machines);
    }

    private void setupBaseGuiMachines(List<List<ItemStack>> machines) {
        PhantomSlotWidget maceratorSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 1, 3, 25);
        maceratorSlot.setBackgroundTexture(null);
        maceratorSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)maceratorSlot);
        PhantomSlotWidget maceratorSlot2 = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 1, 23, 70);
        maceratorSlot2.setBackgroundTexture(null);
        maceratorSlot2.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)maceratorSlot2);
        PhantomSlotWidget maceratorSlot3 = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 1, 114, 47);
        maceratorSlot3.setBackgroundTexture(null);
        maceratorSlot3.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)maceratorSlot3);
        PhantomSlotWidget maceratorSlot4 = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 1, 70, 80);
        maceratorSlot4.setBackgroundTexture(null);
        maceratorSlot4.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)maceratorSlot4);
        PhantomSlotWidget washerSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 2, 25, 25);
        washerSlot.setBackgroundTexture(null);
        washerSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)washerSlot);
        TankWidget waterSlot = new TankWidget((IFluidStorage)new FluidStorage(GTMaterials.Water.getFluid(1000L)), 42, 25, false, false);
        waterSlot.initTemplate();
        waterSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)waterSlot);
        PhantomSlotWidget centrifugeSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 4, 51, 80);
        centrifugeSlot.setBackgroundTexture(null);
        centrifugeSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)centrifugeSlot);
        PhantomSlotWidget centrifugeSlot2 = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 4, 133, 70);
        centrifugeSlot2.setBackgroundTexture(null);
        centrifugeSlot2.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)centrifugeSlot2);
        PhantomSlotWidget thermalCentrifugeSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 5, 97, 70);
        thermalCentrifugeSlot.setBackgroundTexture(null);
        thermalCentrifugeSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)thermalCentrifugeSlot);
        PhantomSlotWidget cauldronWasherSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 8, 4, 124);
        cauldronWasherSlot.setBackgroundTexture(null);
        cauldronWasherSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)cauldronWasherSlot);
        PhantomSlotWidget cauldronWasherSlot2 = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 8, 42, 144);
        cauldronWasherSlot2.setBackgroundTexture(null);
        cauldronWasherSlot2.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)cauldronWasherSlot2);
        PhantomSlotWidget cauldronWasherSlot3 = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 8, 103, 144);
        cauldronWasherSlot3.setBackgroundTexture(null);
        cauldronWasherSlot3.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)cauldronWasherSlot3);
    }

    private void setupBaseGuiItems(List<List<ItemStack>> mainproducts, List<List<ItemStack>> byproducts, List<Content> chanceContent) {
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 0, 3, 3).setIngredientIO(IngredientIO.INPUT));
        PhantomSlotWidget crushedSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 2, 3, 47);
        crushedSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)crushedSlot);
        PhantomSlotWidget crushedOreBPSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 0, 3, 65);
        crushedOreBPSlot.setOverlay(chanceContent.get(1).createOverlay(false));
        crushedOreBPSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(14.0f)) + "%"}));
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", 8.5) + "%"}));
        });
        crushedSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)crushedOreBPSlot);
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 3, 64, 25).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 1, 82, 25).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 5, 23, 92).setIngredientIO(IngredientIO.INPUT));
        PhantomSlotWidget crushingCrushedOreBPSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 0, 23, 110);
        crushingCrushedOreBPSlot.setOverlay(chanceContent.get(2).createOverlay(false));
        crushingCrushedOreBPSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(14.0f)) + "%"}));
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", 8.5) + "%"}));
        });
        crushingCrushedOreBPSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)crushingCrushedOreBPSlot);
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 7, 51, 101).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 5, 51, 119).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 6, 137, 47).setIngredientIO(IngredientIO.INPUT));
        PhantomSlotWidget crushingWashedOreBPSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 3, 155, 47);
        crushingWashedOreBPSlot.setOverlay(chanceContent.get(3).createOverlay(false));
        crushingWashedOreBPSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(14.0f)) + "%"}));
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", 8.5) + "%"}));
        });
        crushingWashedOreBPSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)crushingWashedOreBPSlot);
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 7, 133, 92).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 6, 133, 110).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 7, 51, 101).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 5, 51, 119).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 4, 97, 92).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 7, 97, 110).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 7, 70, 101).setIngredientIO(IngredientIO.INPUT));
        PhantomSlotWidget crushingTCedOreBPSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 4, 70, 119);
        crushingTCedOreBPSlot.setOverlay(chanceContent.get(4).createOverlay(false));
        crushingTCedOreBPSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(14.0f)) + "%"}));
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", 8.5) + "%"}));
        });
        crushingTCedOreBPSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)crushingTCedOreBPSlot);
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 9, 3, 105).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 3, 3, 145).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 5, 23, 145).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 7, 63, 145).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 6, 84, 145).setIngredientIO(IngredientIO.INPUT));
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 7, 124, 145).setIngredientIO(IngredientIO.INPUT));
    }

    private void setupSmeltGui(List<List<ItemStack>> mainproducts, List<List<ItemStack>> machines) {
        this.addWidget((Widget)new ImageWidget(0, 0, 186, 174, (IGuiTexture)GuiTextures.OREBY_SMELT));
        this.setupSmeltGuiItems(mainproducts);
        this.setupSmeltGuiMachines(machines);
    }

    private void setupSmeltGuiMachines(List<List<ItemStack>> machines) {
        PhantomSlotWidget furnaceSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 0, 23, 3);
        furnaceSlot.setBackgroundTexture(null).setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)furnaceSlot);
    }

    private void setupSmeltGuiItems(List<List<ItemStack>> mainproducts) {
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 1, 46, 3).setIngredientIO(IngredientIO.OUTPUT));
    }

    private void setupChemGui(List<List<ItemStack>> mainproducts, List<List<ItemStack>> byproducts, List<List<ItemStack>> machines, OreProperty prop, List<Content> chanceContent) {
        this.addWidget((Widget)new ImageWidget(0, 0, 186, 174, (IGuiTexture)GuiTextures.OREBY_CHEM));
        this.setupChemGuiItems(mainproducts, byproducts, chanceContent);
        this.setupChemGuiMachines(machines, prop);
    }

    private void setupChemGuiMachines(List<List<ItemStack>> machines, OreProperty prop) {
        Pair<Material, Integer> reagent = prop.getWashedIn();
        PhantomSlotWidget chembathSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 3, 25, 48);
        chembathSlot.setBackgroundTexture(null);
        this.addWidget((Widget)chembathSlot);
        TankWidget washingReagentSlot = new TankWidget((IFluidStorage)new FluidStorage(((Material)reagent.getLeft()).getFluid(((Integer)reagent.getRight()).intValue())), 42, 48, false, false);
        washingReagentSlot.initTemplate();
        washingReagentSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)washingReagentSlot);
    }

    private void setupChemGuiItems(List<List<ItemStack>> mainproducts, List<List<ItemStack>> byproducts, List<Content> chanceContent) {
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 3, 64, 48).setIngredientIO(IngredientIO.OUTPUT));
        PhantomSlotWidget bathingCrushedOreBPSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 8, 82, 48);
        bathingCrushedOreBPSlot.setOverlay(chanceContent.get(5).createOverlay(false));
        bathingCrushedOreBPSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(70.0f)) + "%"}));
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", 5.8) + "%"}));
        });
        bathingCrushedOreBPSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)bathingCrushedOreBPSlot);
    }

    private void setupSepGui(List<List<ItemStack>> mainproducts, List<List<ItemStack>> byproducts, List<List<ItemStack>> machines, List<Content> chanceContent) {
        this.addWidget((Widget)new ImageWidget(0, 0, 186, 174, (IGuiTexture)GuiTextures.OREBY_SEP));
        this.setupSepGuiItems(mainproducts, byproducts, chanceContent);
        this.setupSepGuiMachines(machines);
    }

    private void setupSepGuiMachines(List<List<ItemStack>> machines) {
        PhantomSlotWidget separatorSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 7, 155, 69);
        separatorSlot.setBackgroundTexture(null);
        separatorSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)separatorSlot);
    }

    private void setupSepGuiItems(List<List<ItemStack>> mainproducts, List<List<ItemStack>> byproducts, List<Content> chanceContent) {
        this.addWidget((Widget)new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 7, 155, 92).setIngredientIO(IngredientIO.INPUT));
        PhantomSlotWidget separatorBPSlot1 = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 9, 155, 110);
        separatorBPSlot1.setOverlay(chanceContent.get(6).createOverlay(false));
        separatorBPSlot1.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(40.0f)) + "%"}));
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", 8.5) + "%"}));
        });
        separatorBPSlot1.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)separatorBPSlot1);
        PhantomSlotWidget separatorBPSlot2 = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 10, 155, 128);
        separatorBPSlot2.setOverlay(chanceContent.get(7).createOverlay(false));
        separatorBPSlot2.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(20.0f)) + "%"}));
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(6.0f)) + "%"}));
        });
        separatorBPSlot2.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)separatorBPSlot2);
    }

    private void setupSiftGui(List<List<ItemStack>> mainproducts, List<List<ItemStack>> byproducts, List<List<ItemStack>> machines, List<Content> chanceContent) {
        this.addWidget((Widget)new ImageWidget(0, 0, 186, 174, (IGuiTexture)GuiTextures.OREBY_SIFT));
        this.setupSiftGuiItems(mainproducts, byproducts, chanceContent);
        this.setupSiftGuiMachines(machines);
    }

    private void setupSiftGuiMachines(List<List<ItemStack>> machines) {
        PhantomSlotWidget sifterSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(machines), 6, 101, 24);
        sifterSlot.setBackgroundTexture(null);
        sifterSlot.setIngredientIO(IngredientIO.OUTPUT);
        this.addWidget((Widget)sifterSlot);
    }

    private void setupSiftGuiItems(List<List<ItemStack>> mainproducts, List<List<ItemStack>> byproducts, List<Content> chanceContent) {
        PhantomSlotWidget exquisiteSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 11, 119, 3);
        exquisiteSlot.setOverlay(chanceContent.get(8).createOverlay(false));
        exquisiteSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(3.0f)) + "%"}));
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(1.0f)) + "%"}));
        });
        exquisiteSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)exquisiteSlot);
        PhantomSlotWidget flawlessSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 12, 137, 3);
        flawlessSlot.setOverlay(chanceContent.get(9).createOverlay(false));
        flawlessSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(3.0f)) + "%"}));
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(1.0f)) + "%"}));
        });
        flawlessSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)flawlessSlot);
        PhantomSlotWidget gemSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 13, 155, 3);
        gemSlot.setOverlay(chanceContent.get(10).createOverlay(false));
        gemSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(3.0f)) + "%"}));
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(1.0f)) + "%"}));
        });
        gemSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)gemSlot);
        PhantomSlotWidget dustSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(mainproducts), 6, 119, 21);
        dustSlot.setOverlay(chanceContent.get(0).createOverlay(false));
        dustSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(3.0f)) + "%"}));
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(1.0f)) + "%"}));
        });
        dustSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)dustSlot);
        PhantomSlotWidget flawedSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 14, 137, 21);
        flawlessSlot.setOverlay(chanceContent.get(11).createOverlay(false));
        flawedSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(3.0f)) + "%"}));
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(1.0f)) + "%"}));
        });
        flawedSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)flawedSlot);
        PhantomSlotWidget chippedSlot = new PhantomSlotWidget((IItemTransfer)new CycleItemStackHandler(byproducts), 15, 155, 21);
        chippedSlot.setOverlay(chanceContent.get(12).createOverlay(false));
        chippedSlot.setOnAddedTooltips((w, tooltips) -> {
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.chance_1", (Object[])new Object[]{String.format("%.1f", Float.valueOf(3.0f)) + "%"}));
            tooltips.add(Component.m_237110_((String)"gtceu.gui.content.tier_boost", (Object[])new Object[]{String.format("%.1f", Float.valueOf(1.0f)) + "%"}));
        });
        chippedSlot.setIngredientIO(IngredientIO.INPUT);
        this.addWidget((Widget)chippedSlot);
    }

    private void addMachineSlots(List<List<ItemStack>> machines) {
        List<ItemStack> furnaceSlot = Collections.singletonList(new ItemStack((ItemLike)Blocks.f_50094_.m_5456_()));
        machines.add(furnaceSlot);
        List<ItemStack> maceratorSlot = Collections.singletonList(GTMachines.MACERATOR[1].asStack());
        machines.add(maceratorSlot);
        List<ItemStack> washerSlot = Collections.singletonList(GTMachines.ORE_WASHER[1].asStack());
        machines.add(washerSlot);
        List<ItemStack> bathSlot = Collections.singletonList(GTMachines.CHEMICAL_BATH[1].asStack());
        machines.add(bathSlot);
        List<ItemStack> centrifugeSlot = Collections.singletonList(GTMachines.CENTRIFUGE[1].asStack());
        machines.add(centrifugeSlot);
        List<ItemStack> thermalCentrifugeSlot = Collections.singletonList(GTMachines.THERMAL_CENTRIFUGE[1].asStack());
        machines.add(thermalCentrifugeSlot);
        List<ItemStack> sifterSlot = Collections.singletonList(GTMachines.SIFTER[1].asStack());
        machines.add(sifterSlot);
        List<ItemStack> separatorSlot = Collections.singletonList(GTMachines.ELECTROMAGNETIC_SEPARATOR[1].asStack());
        machines.add(separatorSlot);
        ArrayList<ItemStack> cauldronWasherSlot = new ArrayList<ItemStack>();
        cauldronWasherSlot.add(new ItemStack((ItemLike)Items.f_42544_));
        cauldronWasherSlot.add(GTMachines.ORE_WASHER[1].asStack());
        machines.add(cauldronWasherSlot);
    }

    private void addItemSlots(List<List<ItemStack>> mainproducts, List<List<ItemStack>> byproducts, Material material, OreProperty prop, List<Content> chanceContent) {
        this.setupMainProducts(mainproducts, material, prop, chanceContent);
        this.setupByproducts(byproducts, material, prop, chanceContent);
    }

    private void setupMainProducts(List<List<ItemStack>> mainproducts, Material material, OreProperty prop, List<Content> chanceContent) {
        List<ItemStack> oreSlot = Collections.singletonList(ChemicalHelper.get(TagPrefix.ore, material));
        mainproducts.add(oreSlot);
        Material smeltingResult = prop.getDirectSmeltResult() != null ? prop.getDirectSmeltResult() : material;
        ArrayList<ItemStack> smeltSlot = new ArrayList<ItemStack>();
        if (smeltingResult.hasProperty(PropertyKey.INGOT)) {
            smeltSlot.add(ChemicalHelper.get(TagPrefix.ingot, smeltingResult));
        } else if (smeltingResult.hasProperty(PropertyKey.GEM)) {
            smeltSlot.add(ChemicalHelper.get(TagPrefix.gem, smeltingResult));
        } else if (smeltingResult.hasProperty(PropertyKey.DUST)) {
            smeltSlot.add(ChemicalHelper.get(TagPrefix.dust, smeltingResult));
        } else {
            smeltSlot.add(new ItemStack((ItemLike)Items.f_41852_));
        }
        mainproducts.add(smeltSlot);
        List<ItemStack> crushedSlot = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.crushed, material)).m_203614_().map(Holder::m_203334_).map(item -> new ItemStack((ItemLike)item, 2 * prop.getOreMultiplier())).toList();
        mainproducts.add(crushedSlot);
        List<ItemStack> crushedPurifiedSlot = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.crushedPurified, material)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
        mainproducts.add(crushedPurifiedSlot);
        List<ItemStack> crushedRefinedSlot = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.crushedRefined, material)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
        mainproducts.add(crushedRefinedSlot);
        List<ItemStack> dustImpureSlot = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.dustImpure, material)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
        mainproducts.add(dustImpureSlot);
        List<ItemStack> dustPureSlot = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.dustPure, material)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
        mainproducts.add(dustPureSlot);
        List<ItemStack> dustSlot = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.dust, material)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
        mainproducts.add(dustSlot);
        ArrayList<ItemStack> gemSlot = new ArrayList<ItemStack>();
        if (material.hasProperty(PropertyKey.GEM)) {
            gemSlot.add(ChemicalHelper.get(TagPrefix.gem, material));
        }
        mainproducts.add(gemSlot);
        chanceContent.add(new Content(gemSlot, 0.35f, 0.05f, null, null));
        List<ItemStack> simpleCrushedSlot = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.crushed, material)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
        mainproducts.add(simpleCrushedSlot);
    }

    private void setupByproducts(List<List<ItemStack>> byproducts, Material material, OreProperty prop, List<Content> chanceContent) {
        Material byproductMaterial1 = GTUtil.selectItemInList(0, material, prop.getOreByProducts(), Material.class);
        Material byproductMaterial2 = GTUtil.selectItemInList(1, material, prop.getOreByProducts(), Material.class);
        Material byproductMaterial3 = GTUtil.selectItemInList(3, material, prop.getOreByProducts(), Material.class);
        List<Material> separatedMaterial = prop.getSeparatedInto();
        ItemStack crushingOreByproductStack = ChemicalHelper.get(TagPrefix.gem, byproductMaterial1);
        if (crushingOreByproductStack.m_41619_()) {
            crushingOreByproductStack = ChemicalHelper.get(TagPrefix.dust, byproductMaterial1);
        }
        List<ItemStack> maceratorBPSlot1 = Collections.singletonList(crushingOreByproductStack);
        byproducts.add(maceratorBPSlot1);
        chanceContent.add(new Content(crushingOreByproductStack, 0.14f, 0.07f, null, null));
        List<ItemStack> washerBPSlot = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.dustTiny, byproductMaterial1)).m_203614_().map(Holder::m_203334_).map(item -> new ItemStack((ItemLike)item, 3)).toList();
        byproducts.add(washerBPSlot);
        List<ItemStack> maceratorBPSlot2 = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.dust, byproductMaterial1)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
        byproducts.add(maceratorBPSlot2);
        chanceContent.add(new Content(maceratorBPSlot2, 0.14f, 0.085f, null, null));
        List<ItemStack> maceratorBPSlot3 = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.dust, byproductMaterial2)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
        byproducts.add(maceratorBPSlot3);
        chanceContent.add(new Content(maceratorBPSlot3, 0.14f, 0.085f, null, null));
        List<ItemStack> maceratorBPSlot4 = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.dust, byproductMaterial2)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
        byproducts.add(maceratorBPSlot4);
        chanceContent.add(new Content(maceratorBPSlot4, 0.14f, 0.085f, null, null));
        List<ItemStack> centrifugeBPSlot = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.dustTiny, byproductMaterial1)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
        byproducts.add(centrifugeBPSlot);
        List<ItemStack> centrifugeBPSlot2 = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.dustTiny, byproductMaterial2)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
        byproducts.add(centrifugeBPSlot2);
        List<ItemStack> tcBPSlot = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.dustTiny, byproductMaterial2)).m_203614_().map(Holder::m_203334_).map(item -> new ItemStack((ItemLike)item, 3)).toList();
        byproducts.add(tcBPSlot);
        List<ItemStack> bathBPSlot = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.dust, byproductMaterial3)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
        byproducts.add(bathBPSlot);
        chanceContent.add(new Content(bathBPSlot, 0.7f, 0.58f, null, null));
        ItemStack separatedStack1 = new ItemStack((ItemLike)Items.f_41852_);
        ItemStack separatedStack2 = new ItemStack((ItemLike)Items.f_41852_);
        if (prop.getSeparatedInto() != null && !prop.getSeparatedInto().isEmpty()) {
            separatedStack1 = ChemicalHelper.get(TagPrefix.dustSmall, separatedMaterial.get(0));
            TagPrefix prefix = separatedMaterial.get(separatedMaterial.size() - 1).getBlastTemperature() == 0 && separatedMaterial.get(separatedMaterial.size() - 1).hasProperty(PropertyKey.INGOT) ? TagPrefix.nugget : TagPrefix.dustSmall;
            separatedStack2 = ChemicalHelper.get(prefix, separatedMaterial.get(separatedMaterial.size() - 1), prefix == TagPrefix.nugget ? 2 : 1);
        }
        List<ItemStack> sepBPSlot1 = Collections.singletonList(separatedStack1);
        byproducts.add(sepBPSlot1);
        chanceContent.add(new Content(sepBPSlot1, 0.4f, 0.85f, null, null));
        List<ItemStack> sepBPSlot2 = Collections.singletonList(separatedStack2);
        byproducts.add(sepBPSlot2);
        chanceContent.add(new Content(sepBPSlot2, 0.2f, 0.6f, null, null));
        if (material.hasProperty(PropertyKey.GEM)) {
            List<ItemStack> siftBPSlot1 = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.gemExquisite, material)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
            List<ItemStack> siftBPSlot2 = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.gemFlawless, material)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
            List<ItemStack> siftBPSlot3 = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.gem, material)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
            List<ItemStack> siftBPSlot4 = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.gemFlawed, material)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
            List<ItemStack> siftBPSlot5 = BuiltInRegistries.f_257033_.m_203561_(ChemicalHelper.getTag(TagPrefix.gemChipped, material)).m_203614_().map(Holder::m_203334_).map(ItemStack::new).toList();
            byproducts.add(siftBPSlot1);
            chanceContent.add(new Content(siftBPSlot1, 0.03f, 0.01f, null, null));
            byproducts.add(siftBPSlot2);
            chanceContent.add(new Content(siftBPSlot2, 0.1f, 0.015f, null, null));
            byproducts.add(siftBPSlot3);
            chanceContent.add(new Content(siftBPSlot3, 0.5f, 0.075f, null, null));
            byproducts.add(siftBPSlot4);
            chanceContent.add(new Content(siftBPSlot4, 0.25f, 0.03f, null, null));
            byproducts.add(siftBPSlot5);
            chanceContent.add(new Content(siftBPSlot5, 0.35f, 0.04f, null, null));
        }
    }
}

