/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.recipe.StrictShapedRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.NBTIngredient;
import com.lowdragmc.lowdraglib.utils.Builder;
import com.lowdragmc.lowdraglib.utils.NBTToJsonConverter;
import java.util.Iterator;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ShapedRecipeBuilder
extends Builder<Ingredient, ShapedRecipeBuilder> {
    protected ItemStack output = ItemStack.f_41583_;
    protected ResourceLocation id;
    protected String group;
    protected boolean isStrict;

    public ShapedRecipeBuilder(@Nullable ResourceLocation id) {
        this.id = id;
    }

    public ShapedRecipeBuilder() {
        this(null);
    }

    public ShapedRecipeBuilder pattern(String slice) {
        return (ShapedRecipeBuilder)this.aisle(new String[]{slice});
    }

    public ShapedRecipeBuilder define(char cha, TagKey<Item> itemStack) {
        return (ShapedRecipeBuilder)this.where(cha, Ingredient.m_204132_(itemStack));
    }

    public ShapedRecipeBuilder define(char cha, ItemStack itemStack) {
        if (itemStack.m_41782_() || itemStack.m_41773_() > 0) {
            return (ShapedRecipeBuilder)this.where(cha, NBTIngredient.createNBTIngredient(itemStack));
        }
        return (ShapedRecipeBuilder)this.where(cha, Ingredient.m_43927_((ItemStack[])new ItemStack[]{itemStack}));
    }

    public ShapedRecipeBuilder define(char cha, ItemLike itemLike) {
        return (ShapedRecipeBuilder)this.where(cha, Ingredient.m_43929_((ItemLike[])new ItemLike[]{itemLike}));
    }

    public ShapedRecipeBuilder define(char cha, Ingredient ingredient) {
        return (ShapedRecipeBuilder)this.where(cha, ingredient);
    }

    public ShapedRecipeBuilder output(ItemStack itemStack) {
        this.output = itemStack.m_41777_();
        return this;
    }

    public ShapedRecipeBuilder output(ItemStack itemStack, int count) {
        this.output = itemStack.m_41777_();
        this.output.m_41764_(count);
        return this;
    }

    public ShapedRecipeBuilder output(ItemStack itemStack, int count, CompoundTag nbt) {
        this.output = itemStack.m_41777_();
        this.output.m_41764_(count);
        this.output.m_41751_(nbt);
        return this;
    }

    public ShapedRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public ShapedRecipeBuilder id(String id) {
        this.id = new ResourceLocation(id);
        return this;
    }

    public ShapedRecipeBuilder group(String group) {
        this.group = group;
        return this;
    }

    public ShapedRecipeBuilder isStrict(boolean isStrict) {
        this.isStrict = isStrict;
        return this;
    }

    public ShapedRecipeBuilder shallowCopy() {
        ShapedRecipeBuilder builder = (ShapedRecipeBuilder)super.shallowCopy();
        builder.output = this.output.m_41777_();
        return builder;
    }

    public void toJson(JsonObject json) {
        if (this.group != null) {
            json.addProperty("group", this.group);
        }
        if (!this.shape.isEmpty()) {
            JsonArray pattern = new JsonArray();
            Iterator iterator = this.shape.iterator();
            while (iterator.hasNext()) {
                String[] strings;
                for (String string : strings = (String[])iterator.next()) {
                    pattern.add(string);
                }
            }
            json.add("pattern", (JsonElement)pattern);
        }
        if (!this.symbolMap.isEmpty()) {
            JsonObject key = new JsonObject();
            this.symbolMap.forEach((k, v) -> key.add(k.toString(), v.m_43942_()));
            json.add("key", (JsonElement)key);
        }
        if (this.output.m_41619_()) {
            GTCEu.LOGGER.error("shaped recipe {} output is empty", (Object)this.id);
            throw new IllegalArgumentException(this.id + ": output items is empty");
        }
        JsonObject result = new JsonObject();
        result.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.output.m_41720_()).toString());
        if (this.output.m_41613_() > 1) {
            result.addProperty("count", (Number)this.output.m_41613_());
        }
        if (this.output.m_41782_() && this.output.m_41783_() != null) {
            result.add("nbt", NBTToJsonConverter.getObject((CompoundTag)this.output.m_41783_()));
        }
        json.add("result", (JsonElement)result);
    }

    protected ResourceLocation defaultId() {
        return BuiltInRegistries.f_257033_.m_7981_((Object)this.output.m_41720_());
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(){

            public void m_7917_(JsonObject pJson) {
                ShapedRecipeBuilder.this.toJson(pJson);
            }

            public ResourceLocation m_6445_() {
                ResourceLocation ID = ShapedRecipeBuilder.this.id == null ? ShapedRecipeBuilder.this.defaultId() : ShapedRecipeBuilder.this.id;
                return new ResourceLocation(ID.m_135827_(), "shaped/" + ID.m_135815_());
            }

            public RecipeSerializer<?> m_6637_() {
                return ShapedRecipeBuilder.this.isStrict ? StrictShapedRecipe.SERIALIZER : RecipeSerializer.f_44076_;
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        });
    }
}

