/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.FluidRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.StressRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.tag.TagUtil;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.multiblock.CleanroomType;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeSerializer;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.common.recipe.BiomeCondition;
import com.gregtechceu.gtceu.common.recipe.CleanroomCondition;
import com.gregtechceu.gtceu.common.recipe.DimensionCondition;
import com.gregtechceu.gtceu.common.recipe.PositionYCondition;
import com.gregtechceu.gtceu.common.recipe.RPMCondition;
import com.gregtechceu.gtceu.common.recipe.RainingCondition;
import com.gregtechceu.gtceu.common.recipe.ThunderCondition;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.utils.NBTToJsonConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GTRecipeBuilder {
    public final Map<RecipeCapability<?>, List<Content>> input = new HashMap();
    public final Map<RecipeCapability<?>, List<Content>> tickInput = new HashMap();
    public final Map<RecipeCapability<?>, List<Content>> output = new HashMap();
    public final Map<RecipeCapability<?>, List<Content>> tickOutput = new HashMap();
    public CompoundTag data = new CompoundTag();
    public final List<RecipeCondition> conditions = new ArrayList<RecipeCondition>();
    public ResourceLocation id;
    public GTRecipeType recipeType;
    public int duration = 100;
    public boolean perTick;
    public String slotName;
    public String uiName;
    public float chance = 1.0f;
    public float tierChanceBoost = 0.0f;
    public boolean isFuel = false;
    public BiConsumer<GTRecipeBuilder, Consumer<FinishedRecipe>> onSave;

    public GTRecipeBuilder(ResourceLocation id, GTRecipeType recipeType) {
        this.id = id;
        this.recipeType = recipeType;
    }

    public GTRecipeBuilder(GTRecipe toCopy, GTRecipeType recipeType) {
        this.id = toCopy.id;
        this.recipeType = recipeType;
        toCopy.inputs.forEach((k, v) -> this.input.put((RecipeCapability<?>)k, new ArrayList(v)));
        toCopy.outputs.forEach((k, v) -> this.output.put((RecipeCapability<?>)k, new ArrayList(v)));
        toCopy.tickInputs.forEach((k, v) -> this.tickInput.put((RecipeCapability<?>)k, new ArrayList(v)));
        toCopy.tickOutputs.forEach((k, v) -> this.tickOutput.put((RecipeCapability<?>)k, new ArrayList(v)));
        this.conditions.addAll(toCopy.conditions);
        this.data = toCopy.data.m_6426_();
        this.duration = toCopy.duration;
        this.isFuel = toCopy.isFuel;
    }

    public static GTRecipeBuilder of(ResourceLocation id, GTRecipeType recipeType) {
        return new GTRecipeBuilder(id, recipeType);
    }

    public static GTRecipeBuilder ofRaw() {
        return new GTRecipeBuilder(GTCEu.id("raw"), null);
    }

    public GTRecipeBuilder copy(String id) {
        return this.copy(GTCEu.id(id));
    }

    public GTRecipeBuilder copy(ResourceLocation id) {
        GTRecipeBuilder copy = new GTRecipeBuilder(id, this.recipeType);
        this.input.forEach((k, v) -> copy.input.put((RecipeCapability<?>)k, new ArrayList(v)));
        this.output.forEach((k, v) -> copy.output.put((RecipeCapability<?>)k, new ArrayList(v)));
        this.tickInput.forEach((k, v) -> copy.tickInput.put((RecipeCapability<?>)k, new ArrayList(v)));
        this.tickOutput.forEach((k, v) -> copy.tickOutput.put((RecipeCapability<?>)k, new ArrayList(v)));
        copy.conditions.addAll(this.conditions);
        copy.data = this.data.m_6426_();
        copy.duration = this.duration;
        copy.chance = this.chance;
        copy.perTick = this.perTick;
        copy.isFuel = this.isFuel;
        copy.uiName = this.uiName;
        copy.slotName = this.slotName;
        copy.onSave = this.onSave;
        return copy;
    }

    public GTRecipeBuilder copyFrom(GTRecipeBuilder builder) {
        return builder.copy(builder.id).onSave(null).recipeType(this.recipeType);
    }

    public <T> GTRecipeBuilder input(RecipeCapability<T> capability, T ... obj) {
        (this.perTick ? this.tickInput : this.input).computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).map(capability::of).map(o -> new Content(o, this.chance, this.tierChanceBoost, this.slotName, this.uiName)).toList());
        return this;
    }

    public <T> GTRecipeBuilder output(RecipeCapability<T> capability, T ... obj) {
        (this.perTick ? this.tickOutput : this.output).computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).map(capability::of).map(o -> new Content(o, this.chance, this.tierChanceBoost, this.slotName, this.uiName)).toList());
        return this;
    }

    public <T> GTRecipeBuilder inputs(RecipeCapability<T> capability, Object ... obj) {
        (this.perTick ? this.tickInput : this.input).computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).map(capability::of).map(o -> new Content(o, this.chance, this.tierChanceBoost, this.slotName, this.uiName)).toList());
        return this;
    }

    public <T> GTRecipeBuilder outputs(RecipeCapability<T> capability, Object ... obj) {
        (this.perTick ? this.tickOutput : this.output).computeIfAbsent(capability, c -> new ArrayList()).addAll(Arrays.stream(obj).map(capability::of).map(o -> new Content(o, this.chance, this.tierChanceBoost, this.slotName, this.uiName)).toList());
        return this;
    }

    public GTRecipeBuilder addCondition(RecipeCondition condition) {
        this.conditions.add(condition);
        return this;
    }

    public GTRecipeBuilder inputEU(long eu) {
        return this.input(EURecipeCapability.CAP, eu);
    }

    public GTRecipeBuilder EUt(long eu) {
        boolean lastPerTick = this.perTick;
        this.perTick = true;
        if (eu > 0L) {
            this.tickInput.remove(EURecipeCapability.CAP);
            this.inputEU(eu);
        } else if (eu < 0L) {
            this.tickOutput.remove(EURecipeCapability.CAP);
            this.outputEU(-eu);
        }
        this.perTick = lastPerTick;
        return this;
    }

    public GTRecipeBuilder outputEU(long eu) {
        return this.output(EURecipeCapability.CAP, eu);
    }

    public GTRecipeBuilder inputItems(Ingredient ... inputs) {
        return this.input(ItemRecipeCapability.CAP, inputs);
    }

    public GTRecipeBuilder inputItems(ItemStack ... inputs) {
        for (ItemStack itemStack : inputs) {
            if (!itemStack.m_41619_()) continue;
            LDLib.LOGGER.error("gt recipe {} input items is empty", (Object)this.id);
            throw new IllegalArgumentException(this.id + ": input items is empty");
        }
        return this.input(ItemRecipeCapability.CAP, (Ingredient[])Arrays.stream(inputs).map(SizedIngredient::create).toArray(Ingredient[]::new));
    }

    public GTRecipeBuilder inputItems(TagKey<Item> tag, int amount) {
        return this.inputItems(SizedIngredient.create(tag, amount));
    }

    public GTRecipeBuilder inputItems(TagKey<Item> tag) {
        return this.inputItems(tag, 1);
    }

    public GTRecipeBuilder inputItems(Item input, int amount) {
        return this.inputItems(new ItemStack((ItemLike)input, amount));
    }

    public GTRecipeBuilder inputItems(Item input) {
        return this.inputItems(SizedIngredient.create(new ItemStack((ItemLike)input)));
    }

    public GTRecipeBuilder inputItems(Supplier<? extends Item> input) {
        return this.inputItems(input.get());
    }

    public GTRecipeBuilder inputItems(Supplier<? extends Item> input, int amount) {
        return this.inputItems(new ItemStack((ItemLike)input.get(), amount));
    }

    public GTRecipeBuilder inputItems(TagPrefix orePrefix, Material material) {
        return this.inputItems(orePrefix, material, 1);
    }

    public GTRecipeBuilder inputItems(UnificationEntry input) {
        return this.inputItems(input.tagPrefix, input.material, 1);
    }

    public GTRecipeBuilder inputItems(UnificationEntry input, int count) {
        return this.inputItems(input.tagPrefix, input.material, count);
    }

    public GTRecipeBuilder inputItems(TagPrefix orePrefix, Material material, int count) {
        TagKey<Item> tag = ChemicalHelper.getTag(orePrefix, material);
        if (tag == null) {
            return this.inputItems(ChemicalHelper.get(orePrefix, material, count));
        }
        return this.inputItems(tag, count);
    }

    public GTRecipeBuilder inputItems(MachineDefinition machine) {
        return this.inputItems(machine, 1);
    }

    public GTRecipeBuilder inputItems(MachineDefinition machine, int count) {
        return this.inputItems(machine.asStack(count));
    }

    public GTRecipeBuilder itemOutputs(ItemStack ... outputs) {
        return this.outputItems(outputs);
    }

    public GTRecipeBuilder itemOutput(UnificationEntry unificationEntry) {
        return this.outputItems(unificationEntry.tagPrefix, unificationEntry.material);
    }

    public GTRecipeBuilder itemOutput(UnificationEntry unificationEntry, int count) {
        return this.outputItems(unificationEntry.tagPrefix, unificationEntry.material, count);
    }

    public GTRecipeBuilder outputItems(ItemStack ... outputs) {
        for (ItemStack itemStack : outputs) {
            if (!itemStack.m_41619_()) continue;
            LDLib.LOGGER.error("gt recipe {} output items is empty", (Object)this.id);
            throw new IllegalArgumentException(this.id + ": output items is empty");
        }
        return this.output(ItemRecipeCapability.CAP, (Ingredient[])Arrays.stream(outputs).map(SizedIngredient::create).toArray(Ingredient[]::new));
    }

    public GTRecipeBuilder outputItems(Item input, int amount) {
        return this.outputItems(new ItemStack((ItemLike)input, amount));
    }

    public GTRecipeBuilder outputItems(Item input) {
        return this.outputItems(new ItemStack((ItemLike)input));
    }

    public GTRecipeBuilder outputItems(Supplier<? extends ItemLike> input) {
        return this.outputItems(new ItemStack((ItemLike)input.get().m_5456_()));
    }

    public GTRecipeBuilder outputItems(Supplier<? extends ItemLike> input, int amount) {
        return this.outputItems(new ItemStack((ItemLike)input.get().m_5456_(), amount));
    }

    public GTRecipeBuilder outputItems(TagPrefix orePrefix, Material material) {
        return this.outputItems(orePrefix, material, 1);
    }

    public GTRecipeBuilder outputItems(TagPrefix orePrefix, Material material, int count) {
        return this.outputItems(ChemicalHelper.get(orePrefix, material, count));
    }

    public GTRecipeBuilder outputItems(MachineDefinition machine) {
        return this.outputItems(machine, 1);
    }

    public GTRecipeBuilder outputItems(MachineDefinition machine, int count) {
        return this.outputItems(machine.asStack(count));
    }

    public GTRecipeBuilder notConsumable(ItemStack itemStack) {
        float lastChance = this.chance;
        this.chance = 0.0f;
        this.inputItems(itemStack);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumable(Item item) {
        float lastChance = this.chance;
        this.chance = 0.0f;
        this.inputItems(item);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumable(Supplier<? extends Item> item) {
        float lastChance = this.chance;
        this.chance = 0.0f;
        this.inputItems(item);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder notConsumable(TagPrefix orePrefix, Material material) {
        float lastChance = this.chance;
        this.chance = 0.0f;
        this.inputItems(orePrefix, material);
        this.chance = lastChance;
        return this;
    }

    public GTRecipeBuilder circuitMeta(int configuration) {
        return this.notConsumable(IntCircuitBehaviour.stack(configuration));
    }

    public GTRecipeBuilder chancedInput(ItemStack stack, int chance, int tierChanceBoost) {
        float lastChance = this.chance;
        float lastTierChanceBoost = this.tierChanceBoost;
        this.chance = (float)chance / 10000.0f;
        this.tierChanceBoost = (float)tierChanceBoost / 10000.0f;
        this.inputItems(stack);
        this.chance = lastChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedInput(FluidStack stack, int chance, int tierChanceBoost) {
        float lastChance = this.chance;
        float lastTierChanceBoost = this.tierChanceBoost;
        this.chance = (float)chance / 10000.0f;
        this.tierChanceBoost = (float)tierChanceBoost / 10000.0f;
        this.inputFluids(stack);
        this.chance = lastChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedOutput(ItemStack stack, int chance, int tierChanceBoost) {
        float lastChance = this.chance;
        float lastTierChanceBoost = this.tierChanceBoost;
        this.chance = (float)chance / 10000.0f;
        this.tierChanceBoost = (float)tierChanceBoost / 10000.0f;
        this.outputItems(stack);
        this.chance = lastChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedOutput(FluidStack stack, int chance, int tierChanceBoost) {
        float lastChance = this.chance;
        float lastTierChanceBoost = this.tierChanceBoost;
        this.chance = (float)chance / 10000.0f;
        this.tierChanceBoost = (float)tierChanceBoost / 10000.0f;
        this.outputFluids(stack);
        this.chance = lastChance;
        this.tierChanceBoost = lastTierChanceBoost;
        return this;
    }

    public GTRecipeBuilder chancedOutput(TagPrefix tag, Material mat, int chance, int tierChanceBoost) {
        return this.chancedOutput(ChemicalHelper.get(tag, mat), chance, tierChanceBoost);
    }

    public GTRecipeBuilder chancedOutput(TagPrefix tag, Material mat, int count, int chance, int tierChanceBoost) {
        return this.chancedOutput(ChemicalHelper.get(tag, mat, count), chance, tierChanceBoost);
    }

    public GTRecipeBuilder inputFluids(FluidStack ... inputs) {
        return this.input(FluidRecipeCapability.CAP, (FluidIngredient[])Arrays.stream(inputs).map(fluid -> {
            if (!Platform.isForge() && fluid.getFluid() == Fluids.f_76193_) {
                return FluidIngredient.of(fluid);
            }
            return FluidIngredient.of(TagUtil.createFluidTag(BuiltInRegistries.f_257020_.m_7981_((Object)fluid.getFluid()).m_135815_()), fluid.getAmount());
        }).toArray(FluidIngredient[]::new));
    }

    public GTRecipeBuilder inputFluids(FluidIngredient ... inputs) {
        return this.input(FluidRecipeCapability.CAP, inputs);
    }

    public GTRecipeBuilder outputFluids(FluidStack ... outputs) {
        return this.output(FluidRecipeCapability.CAP, (FluidIngredient[])Arrays.stream(outputs).map(xva$0 -> FluidIngredient.of(xva$0)).toArray(FluidIngredient[]::new));
    }

    public GTRecipeBuilder outputFluids(FluidIngredient ... outputs) {
        return this.output(FluidRecipeCapability.CAP, outputs);
    }

    public GTRecipeBuilder inputStress(float stress) {
        return this.input(StressRecipeCapability.CAP, Float.valueOf(stress));
    }

    public GTRecipeBuilder outputStress(float stress) {
        return this.output(StressRecipeCapability.CAP, Float.valueOf(stress));
    }

    public GTRecipeBuilder addData(String key, Tag data) {
        this.data.m_128365_(key, data);
        return this;
    }

    public GTRecipeBuilder addData(String key, int data) {
        this.data.m_128405_(key, data);
        return this;
    }

    public GTRecipeBuilder addData(String key, long data) {
        this.data.m_128356_(key, data);
        return this;
    }

    public GTRecipeBuilder addData(String key, String data) {
        this.data.m_128359_(key, data);
        return this;
    }

    public GTRecipeBuilder addData(String key, Float data) {
        this.data.m_128350_(key, data.floatValue());
        return this;
    }

    public GTRecipeBuilder addData(String key, boolean data) {
        this.data.m_128379_(key, data);
        return this;
    }

    public GTRecipeBuilder blastFurnaceTemp(int blastTemp) {
        return this.addData("ebf_temp", blastTemp);
    }

    public GTRecipeBuilder explosivesAmount(int explosivesAmount) {
        return this.addData("explosives_amount", explosivesAmount);
    }

    public GTRecipeBuilder explosivesType(ItemStack explosivesType) {
        return this.addData("explosives_type", (Tag)explosivesType.m_41739_(new CompoundTag()));
    }

    public GTRecipeBuilder solderMultiplier(int multiplier) {
        return this.addData("solderMultiplier", multiplier);
    }

    public GTRecipeBuilder disableDistilleryRecipes(boolean flag) {
        return this.addData("disable_distillery", flag);
    }

    public GTRecipeBuilder fusionStartEU(long eu) {
        return this.addData("eu_to_start", eu);
    }

    public GTRecipeBuilder cleanroom(CleanroomType cleanroomType) {
        return this.addCondition(new CleanroomCondition(cleanroomType));
    }

    public GTRecipeBuilder dimension(ResourceLocation dimension, boolean reverse) {
        return this.addCondition(new DimensionCondition(dimension).setReverse(reverse));
    }

    public GTRecipeBuilder dimension(ResourceLocation dimension) {
        return this.dimension(dimension, false);
    }

    public GTRecipeBuilder biome(ResourceLocation biome, boolean reverse) {
        return this.addCondition(new BiomeCondition(biome).setReverse(reverse));
    }

    public GTRecipeBuilder biome(ResourceLocation biome) {
        return this.biome(biome, false);
    }

    public GTRecipeBuilder rain(float level, boolean reverse) {
        return this.addCondition(new RainingCondition(level).setReverse(reverse));
    }

    public GTRecipeBuilder rain(float level) {
        return this.rain(level, false);
    }

    public GTRecipeBuilder thunder(float level, boolean reverse) {
        return this.addCondition(new ThunderCondition(level).setReverse(reverse));
    }

    public GTRecipeBuilder thunder(float level) {
        return this.thunder(level, false);
    }

    public GTRecipeBuilder posY(int min, int max, boolean reverse) {
        return this.addCondition(new PositionYCondition(min, max).setReverse(reverse));
    }

    public GTRecipeBuilder posY(int min, int max) {
        return this.posY(min, max, false);
    }

    public GTRecipeBuilder rpm(float rpm, boolean reverse) {
        return this.addCondition(new RPMCondition(rpm).setReverse(reverse));
    }

    public GTRecipeBuilder rpm(float rpm) {
        return this.rpm(rpm, false);
    }

    public void toJson(JsonObject json) {
        json.addProperty("type", this.recipeType.registryName.toString());
        json.addProperty("duration", (Number)Math.abs(this.duration));
        if (this.data != null && !this.data.m_128456_()) {
            json.add("data", NBTToJsonConverter.getObject((CompoundTag)this.data));
        }
        json.add("inputs", (JsonElement)this.capabilitiesToJson(this.input));
        json.add("outputs", (JsonElement)this.capabilitiesToJson(this.output));
        json.add("tickInputs", (JsonElement)this.capabilitiesToJson(this.tickInput));
        json.add("tickOutputs", (JsonElement)this.capabilitiesToJson(this.tickOutput));
        if (!this.conditions.isEmpty()) {
            JsonArray array = new JsonArray();
            for (RecipeCondition condition : this.conditions) {
                JsonObject cond = new JsonObject();
                cond.addProperty("type", (String)GTRegistries.RECIPE_CONDITIONS.getKey(condition.getClass()));
                cond.add("data", (JsonElement)condition.serialize());
                array.add((JsonElement)cond);
            }
            json.add("recipeConditions", (JsonElement)array);
        }
        if (this.isFuel) {
            json.addProperty("isFuel", Boolean.valueOf(true));
        }
    }

    public JsonObject capabilitiesToJson(Map<RecipeCapability<?>, List<Content>> contents) {
        JsonObject jsonObject = new JsonObject();
        contents.forEach((cap, list) -> {
            JsonArray contentsJson = new JsonArray();
            for (Content content : list) {
                contentsJson.add(cap.serializer.toJsonContent(content));
            }
            jsonObject.add((String)GTRegistries.RECIPE_CAPABILITIES.getKey((RecipeCapability<?>)cap), (JsonElement)contentsJson);
        });
        return jsonObject;
    }

    public FinishedRecipe build() {
        return new FinishedRecipe(){

            public void m_7917_(JsonObject pJson) {
                GTRecipeBuilder.this.toJson(pJson);
            }

            public ResourceLocation m_6445_() {
                return new ResourceLocation(GTRecipeBuilder.this.id.m_135827_(), GTRecipeBuilder.this.recipeType.registryName.m_135815_() + "/" + GTRecipeBuilder.this.id.m_135815_());
            }

            public RecipeSerializer<?> m_6637_() {
                return GTRecipeSerializer.SERIALIZER;
            }

            @Nullable
            public JsonObject m_5860_() {
                return null;
            }

            @Nullable
            public ResourceLocation m_6448_() {
                return null;
            }
        };
    }

    public void save(Consumer<FinishedRecipe> consumer) {
        if (this.onSave != null) {
            this.onSave.accept(this, consumer);
        }
        consumer.accept(this.build());
    }

    public GTRecipe buildRawRecipe() {
        return new GTRecipe(this.recipeType, this.id, this.input, this.output, this.tickInput, this.tickOutput, this.conditions, this.data, this.duration, this.isFuel);
    }

    public long EUt() {
        if (!this.tickInput.containsKey(EURecipeCapability.CAP)) {
            return 0L;
        }
        if (this.tickInput.get(EURecipeCapability.CAP).isEmpty()) {
            return 0L;
        }
        return (Long)EURecipeCapability.CAP.of(this.tickInput.get((Object)EURecipeCapability.CAP).get((int)0).content);
    }

    public int getSolderMultiplier() {
        return Math.max(1, this.data.m_128451_("solderMultiplier"));
    }

    public GTRecipeBuilder id(ResourceLocation id) {
        this.id = id;
        return this;
    }

    public GTRecipeBuilder recipeType(GTRecipeType recipeType) {
        this.recipeType = recipeType;
        return this;
    }

    public GTRecipeBuilder duration(int duration) {
        this.duration = duration;
        return this;
    }

    public GTRecipeBuilder perTick(boolean perTick) {
        this.perTick = perTick;
        return this;
    }

    public GTRecipeBuilder slotName(String slotName) {
        this.slotName = slotName;
        return this;
    }

    public GTRecipeBuilder uiName(String uiName) {
        this.uiName = uiName;
        return this;
    }

    public GTRecipeBuilder chance(float chance) {
        this.chance = chance;
        return this;
    }

    public GTRecipeBuilder tierChanceBoost(float tierChanceBoost) {
        this.tierChanceBoost = tierChanceBoost;
        return this;
    }

    public GTRecipeBuilder isFuel(boolean isFuel) {
        this.isFuel = isFuel;
        return this;
    }

    public GTRecipeBuilder onSave(BiConsumer<GTRecipeBuilder, Consumer<FinishedRecipe>> onSave) {
        this.onSave = onSave;
        return this;
    }
}

