/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.data.lang;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.tterrag.registrate.providers.RegistrateLangProvider;
import java.util.Iterator;

public class ItemLang {
    public static void init(RegistrateLangProvider provider) {
        ItemLang.initGeneratedNames(provider);
        ItemLang.initItemNames(provider);
        ItemLang.initItemTooltips(provider);
    }

    private static void initGeneratedNames(RegistrateLangProvider provider) {
        for (Material material : GTRegistries.MATERIALS) {
            provider.add(material.getUnlocalizedName(), FormattingUtil.toEnglishName(material.getName()));
        }
        for (GTRecipeType recipeType : GTRegistries.RECIPE_TYPES) {
            provider.add(recipeType.registryName.m_214298_(), FormattingUtil.toEnglishName(recipeType.registryName.m_135815_()));
        }
        for (TagPrefix tagPrefix : TagPrefix.values()) {
            provider.add(tagPrefix.getUnlocalizedName(), tagPrefix.langValue);
        }
        for (Iterator<Object> iterator : GTToolType.values()) {
            provider.add(((GTToolType)((Object)iterator)).getUnlocalizedName(), FormattingUtil.toEnglishName(iterator));
        }
        provider.add("tagprefix.polymer.plate", "%s Sheet");
        provider.add("tagprefix.polymer.foil", "Thin %s Sheet");
        provider.add("tagprefix.polymer.nugget", "%s Chip");
        provider.add("tagprefix.polymer.dense_plate", "Dense %s Sheet");
        provider.add("tagprefix.polymer.double_plate", "Double %s Sheet");
        provider.add("tagprefix.polymer.tiny_dust", "Tiny Pile of %s Pulp");
        provider.add("tagprefix.polymer.small_dust", "Small Pile of %s Pulp");
        provider.add("tagprefix.polymer.dust", "%s Pulp");
        provider.add("tagprefix.polymer.ingot", "%s Ingot");
    }

    private static void initItemNames(RegistrateLangProvider provider) {
    }

    private static void initItemTooltips(RegistrateLangProvider provider) {
        provider.add("item.gtceu.credit.copper.tooltip", "\u00a770.125 Credits");
        provider.add("item.gtceu.credit.cupronickel.tooltip", "\u00a771 Credit");
        provider.add("item.gtceu.credit.silver.tooltip", "\u00a778 Credits");
        provider.add("item.gtceu.credit.gold.tooltip", "\u00a7764 Credits");
        provider.add("item.gtceu.credit.platinum.tooltip", "\u00a77512 Credits");
        provider.add("item.gtceu.credit.osmium.tooltip", "\u00a774096 Credits");
        provider.add("item.gtceu.credit.naquadah.tooltip", "\u00a7732768 Credits");
        provider.add("item.gtceu.credit.neutronium.tooltip", "\u00a77262144 Credits");
        provider.add("item.gtceu.coin.gold.ancient.tooltip", "\u00a77Found in ancient Ruins");
        provider.add("item.gtceu.coin.doge.tooltip", "\u00a77wow much coin how monyey so cwypto pwz minye v wich vewy cuwwency wow");
        provider.add("item.gtceu.coin.chocolate.tooltip", "\u00a77Wrapped in Gold");
        provider.add("item.gtceu.shape.empty.tooltip", "\u00a77Raw Plate to make Molds and Extrude Shapes");
        provider.add("item.gtceu.nano_saber.tooltip", "\u00a77Ryujin no ken wo kurae!");
        provider.add("item.gtceu.shape.mold.plate.tooltip", "\u00a77Mold for making Plates");
        provider.add("item.gtceu.shape.mold.casing.tooltip", "\u00a77Mold for making Item Casings");
        provider.add("item.gtceu.shape.mold.gear.tooltip", "\u00a77Mold for making Gears");
        provider.add("item.gtceu.shape.mold.credit.tooltip", "\u00a77Secure Mold for making Coins (Don't lose it!)");
        provider.add("item.gtceu.shape.mold.bottle.tooltip", "\u00a77Mold for making Bottles");
        provider.add("item.gtceu.shape.mold.ingot.tooltip", "\u00a77Mold for making Ingots");
        provider.add("item.gtceu.shape.mold.ball.tooltip", "\u00a77Mold for making Balls");
        provider.add("item.gtceu.shape.mold.block.tooltip", "\u00a77Mold for making Blocks");
        provider.add("item.gtceu.shape.mold.nugget.tooltip", "\u00a77Mold for making Nuggets");
        provider.add("item.gtceu.shape.mold.cylinder.tooltip", "\u00a77Mold for shaping Cylinders");
        provider.add("item.gtceu.shape.mold.anvil.tooltip", "\u00a77Mold for shaping Anvils");
        provider.add("item.gtceu.shape.mold.name.tooltip", "\u00a77Mold for naming Items in the Forming Press (rename Mold with Anvil)");
        provider.add("item.gtceu.shape.mold.gear.small.tooltip", "\u00a77Mold for making small Gears");
        provider.add("item.gtceu.shape.mold.rotor.tooltip", "\u00a77Mold for making Rotors");
        provider.add("item.gtceu.shape.extruder.plate.tooltip", "\u00a77Extruder Shape for making Plates");
        provider.add("item.gtceu.shape.extruder.rod.tooltip", "\u00a77Extruder Shape for making Rods");
        provider.add("item.gtceu.shape.extruder.bolt.tooltip", "\u00a77Extruder Shape for making Bolts");
        provider.add("item.gtceu.shape.extruder.ring.tooltip", "\u00a77Extruder Shape for making Rings");
        provider.add("item.gtceu.shape.extruder.cell.tooltip", "\u00a77Extruder Shape for making Cells");
        provider.add("item.gtceu.shape.extruder.ingot.tooltip", "\u00a77Extruder Shape for, wait, can't we just use a Furnace?");
        provider.add("item.gtceu.shape.extruder.wire.tooltip", "\u00a77Extruder Shape for making Wires");
        provider.add("item.gtceu.shape.extruder.casing.tooltip", "\u00a77Extruder Shape for making Item Casings");
        provider.add("item.gtceu.shape.extruder.pipe.tiny.tooltip", "\u00a77Extruder Shape for making tiny Pipes");
        provider.add("item.gtceu.shape.extruder.pipe.small.tooltip", "\u00a77Extruder Shape for making small Pipes");
        provider.add("item.gtceu.shape.extruder.pipe.normal.tooltip", "\u00a77Extruder Shape for making Pipes");
        provider.add("item.gtceu.shape.extruder.pipe.large.tooltip", "\u00a77Extruder Shape for making large Pipes");
        provider.add("item.gtceu.shape.extruder.pipe.huge.tooltip", "\u00a77Extruder Shape for making full Block Pipes");
        provider.add("item.gtceu.shape.extruder.block.tooltip", "\u00a77Extruder Shape for making Blocks");
        provider.add("item.gtceu.shape.extruder.sword.tooltip", "\u00a77Extruder Shape for making Swords");
        provider.add("item.gtceu.shape.extruder.pickaxe.tooltip", "\u00a77Extruder Shape for making Pickaxes");
        provider.add("item.gtceu.shape.extruder.shovel.tooltip", "\u00a77Extruder Shape for making Shovels");
        provider.add("item.gtceu.shape.extruder.axe.tooltip", "\u00a77Extruder Shape for making Axes");
        provider.add("item.gtceu.shape.extruder.hoe.tooltip", "\u00a77Extruder Shape for making Hoes");
        provider.add("item.gtceu.shape.extruder.hammer.tooltip", "\u00a77Extruder Shape for making Hammers");
        provider.add("item.gtceu.shape.extruder.file.tooltip", "\u00a77Extruder Shape for making Files");
        provider.add("item.gtceu.shape.extruder.saw.tooltip", "\u00a77Extruder Shape for making Saws");
        provider.add("item.gtceu.shape.extruder.gear.tooltip", "\u00a77Extruder Shape for making Gears");
        provider.add("item.gtceu.shape.extruder.bottle.tooltip", "\u00a77Extruder Shape for making Bottles");
        provider.add("item.gtceu.shape.extruder.gear_small.tooltip", "\u00a77Extruder Shape for making Small Gears");
        provider.add("item.gtceu.shape.extruder.foil.tooltip", "\u00a77Extruder Shape for making Foils from Non-Metals");
        provider.add("item.gtceu.shape.extruder.rod_long.tooltip", "\u00a77Extruder Shape for making Long Rods");
        provider.add("item.gtceu.shape.extruder.rotor.tooltip", "\u00a77Extruder Shape for making Rotors");
        provider.add("item.gtceu.spray.empty.tooltip", "\u00a77Can be filled with sprays of various colors");
        provider.add("fluid_cell.empty", "Empty");
        provider.add("item.gtceu.tool.matchbox.tooltip", "\u00a77This is not a Car");
        provider.add("item.gtceu.tool.lighter.platinum.tooltip", "\u00a77A known Prank Master is engraved on it");
        provider.add("item.gtceu.battery.hull.lv.tooltip", "\u00a77An empty LV Battery Hull");
        provider.add("item.gtceu.battery.hull.mv.tooltip", "\u00a77An empty \u00a7bMV \u00a77Battery Hull");
        provider.add("item.gtceu.battery.hull.hv.tooltip", "\u00a77An empty \u00a76HV \u00a77Battery Hull");
        provider.add("item.gtceu.battery.hull.ev.tooltip", "\u00a77An empty \u00a75EV \u00a77Battery Hull");
        provider.add("item.gtceu.battery.hull.iv.tooltip", "\u00a77An empty \u00a71IV \u00a77Battery Hull");
        provider.add("item.gtceu.battery.hull.luv.tooltip", "\u00a77An empty \u00a7dLuV \u00a77Battery Hull");
        provider.add("item.gtceu.battery.hull.zpm.tooltip", "\u00a77An empty \u00a7fZPM \u00a77Battery Hull");
        provider.add("item.gtceu.battery.hull.uv.tooltip", "\u00a77An empty \u00a73UV \u00a77Battery Hull");
        provider.add("item.gtceu.battery.charge_time", "\u00a7aHolds %s%s of Power (%s)");
        provider.add("item.gtceu.battery.charge_detailed", "%d/%d EU - Tier %s \u00a77(\u00a7%c%d%s remaining\u00a77)");
        provider.add("item.gtceu.battery.charge_unit.second", "sec");
        provider.add("item.gtceu.battery.charge_unit.minute", "min");
        provider.add("item.gtceu.battery.charge_unit.hour", "hr");
        provider.add("item.gtceu.battery.re.ulv.tantalum.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.battery.re.lv.cadmium.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.battery.re.lv.lithium.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.battery.re.lv.sodium.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.battery.re.mv.cadmium.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.battery.re.mv.lithium.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.battery.re.mv.sodium.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.battery.re.hv.cadmium.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.battery.re.hv.lithium.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.battery.re.hv.sodium.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.battery.ev.vanadium.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.battery.iv.vanadium.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.battery.luv.vanadium.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.battery.zpm.naquadria.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.battery.uv.naquadria.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.energy_crystal.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.lapotron_crystal.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.energy.lapotronic_orb.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.energy.lapotronic_orb_cluster.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.energy.module.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.energy.cluster.tooltip", "\u00a77Reusable Battery");
        provider.add("item.gtceu.max.battery.tooltip", "\u00a77Fill this to win Minecraft");
        provider.add("item.gtceu.electric.pump.tooltip", "\u00a77Transfers \u00a7fFluids\u00a77 at specific rates as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.fluid.regulator.tooltip", "\u00a77Limits \u00a7fFluids\u00a77 to specific quantities as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.conveyor.module.tooltip", "\u00a77Transfers \u00a7fItems\u00a77 at specific rates as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.robot.arm.tooltip", "\u00a77Limits \u00a7fItems\u00a77 to specific quantities as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.tool.datastick.tooltip", "\u00a77A Low Capacity Data Storage");
        provider.add("item.gtceu.tool.dataorb.tooltip", "\u00a77A High Capacity Data Storage");
        provider.add("item.gtceu.circuit.integrated.tooltip", "\u00a77Use to open configuration GUI");
        provider.add("item.gtceu.circuit.integrated.gui", "\u00a77Programmed Circuit Configuration");
        provider.add("item.glass.lens", "Glass Lens (White)");
        provider.add("item.gtceu.boule.silicon.tooltip", "\u00a77Raw Circuit");
        provider.add("item.gtceu.boule.glowstone.tooltip", "\u00a77Raw Circuit");
        provider.add("item.gtceu.boule.naquadah.tooltip", "\u00a77Raw Circuit");
        provider.add("item.gtceu.boule.neutronium.tooltip", "\u00a77Raw Circuit");
        provider.add("item.gtceu.wafer.silicon.tooltip", "\u00a77Raw Circuit");
        provider.add("item.gtceu.wafer.glowstone.tooltip", "\u00a77Raw Circuit");
        provider.add("item.gtceu.wafer.naquadah.tooltip", "\u00a77Raw Circuit");
        provider.add("item.gtceu.wafer.neutronium.tooltip", "\u00a77Raw Circuit");
        provider.add("item.gtceu.board.coated.tooltip", "\u00a77A Coated Board");
        provider.add("item.gtceu.board.phenolic.tooltip", "\u00a77A Good Board");
        provider.add("item.gtceu.board.plastic.tooltip", "\u00a77A Good Board");
        provider.add("item.gtceu.board.epoxy.tooltip", "\u00a77An Advanced Board");
        provider.add("item.gtceu.board.fiber_reinforced.tooltip", "\u00a77An Extreme Board");
        provider.add("item.gtceu.board.multilayer.fiber_reinforced.tooltip", "\u00a77An Elite Board");
        provider.add("item.gtceu.board.wetware.tooltip", "\u00a77The Board that keeps life");
        provider.add("item.gtceu.circuit_board.basic.tooltip", "\u00a77A Basic Circuit Board");
        provider.add("item.gtceu.circuit_board.good.tooltip", "\u00a77A Good Circuit Board");
        provider.add("item.gtceu.circuit_board.plastic.tooltip", "\u00a77A Good Circuit Board");
        provider.add("item.gtceu.circuit_board.advanced.tooltip", "\u00a77An Advanced Circuit Board");
        provider.add("item.gtceu.circuit_board.extreme.tooltip", "\u00a77A More Advanced Circuit Board");
        provider.add("item.gtceu.circuit_board.elite.tooltip", "\u00a77An Elite Circuit Board");
        provider.add("item.gtceu.circuit_board.wetware.tooltip", "\u00a77The Board that keeps life");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.vacuum_tube.tooltip", "\u00a77Technically a Diode\n\u00a7cULV-tier");
        provider.add("item.gtceu.component.diode.tooltip", "\u00a77Basic Electronic Component");
        provider.add("item.gtceu.component.resistor.tooltip", "\u00a77Basic Electronic Component");
        provider.add("item.gtceu.component.transistor.tooltip", "\u00a77Basic Electronic Component");
        provider.add("item.gtceu.component.capacitor.tooltip", "\u00a77Basic Electronic Component");
        provider.add("item.gtceu.component.inductor.tooltip", "\u00a77A Small Coil");
        provider.add("item.gtceu.component.smd.diode.tooltip", "\u00a77Electronic Component");
        provider.add("item.gtceu.component.smd.capacitor.tooltip", "\u00a77Electronic Component");
        provider.add("item.gtceu.component.smd.transistor.tooltip", "\u00a77Electronic Component");
        provider.add("item.gtceu.component.smd.resistor.tooltip", "\u00a77Electronic Component");
        provider.add("item.gtceu.component.smd.inductor.tooltip", "\u00a77Electronic Component");
        provider.add("item.gtceu.component.advanced_smd.diode.tooltip", "\u00a77Advanced Electronic Component");
        provider.add("item.gtceu.component.advanced_smd.capacitor.tooltip", "\u00a77Advanced Electronic Component");
        provider.add("item.gtceu.component.advanced_smd.transistor.tooltip", "\u00a77Advanced Electronic Component");
        provider.add("item.gtceu.component.advanced_smd.resistor.tooltip", "\u00a77Advanced Electronic Component");
        provider.add("item.gtceu.component.advanced_smd.inductor.tooltip", "\u00a77Advanced Electronic Component");
        provider.add("item.gtceu.wafer.highly_advanced_system_on_chip.tooltip", "\u00a77Raw Highly Advanced Circuit");
        provider.add("item.gtceu.wafer.advanced_system_on_chip.tooltip", "\u00a77Raw Advanced Circuit");
        provider.add("item.gtceu.wafer.integrated_logic_circuit.tooltip", "\u00a77Raw Integrated Circuit");
        provider.add("item.gtceu.wafer.central_processing_unit.tooltip", "\u00a77Raw Processing Unit");
        provider.add("item.gtceu.wafer.high_power_integrated_circuit.tooltip", "\u00a77Raw High Power Circuit");
        provider.add("item.gtceu.wafer.ultra_high_power_integrated_circuit.tooltip", "\u00a77Raw Ultra High Power Circuit");
        provider.add("item.gtceu.wafer.nand_memory_chip.tooltip", "\u00a77Raw Logic Gate");
        provider.add("item.gtceu.wafer.ultra_low_power_integrated_circuit.tooltip", "\u00a77Raw Ultra Low Power Circuit");
        provider.add("item.gtceu.wafer.low_power_integrated_circuit.tooltip", "\u00a77Raw Low Power Circuit");
        provider.add("item.gtceu.wafer.power_integrated_circuit.tooltip", "\u00a77Raw Power Circuit");
        provider.add("item.gtceu.wafer.nano_central_processing_unit.tooltip", "\u00a77Raw Nano Circuit");
        provider.add("item.gtceu.wafer.nor_memory_chip.tooltip", "\u00a77Raw Logic Gate");
        provider.add("item.gtceu.wafer.qbit_central_processing_unit.tooltip", "\u00a77Raw Qubit Circuit");
        provider.add("item.gtceu.wafer.random_access_memory.tooltip", "\u00a77Raw Memory");
        provider.add("item.gtceu.wafer.system_on_chip.tooltip", "\u00a77Raw Basic Circuit");
        provider.add("item.gtceu.wafer.simple_system_on_chip.tooltip", "\u00a77Raw Simple Circuit");
        provider.add("item.gtceu.engraved.crystal_chip.tooltip", "\u00a77Needed for Circuits");
        provider.add("item.gtceu.crystal.raw.tooltip", "\u00a77Raw Crystal Processor");
        provider.add("item.gtceu.crystal.raw_chip.tooltip", "\u00a77Raw Crystal Processor Parts");
        provider.add("item.gtceu.crystal.central_processing_unit.tooltip", "\u00a77Crystal Processing Unit");
        provider.add("item.gtceu.crystal.system_on_chip.tooltip", "\u00a77Crystal System on Chip");
        provider.add("item.gtceu.plate.advanced_system_on_chip.tooltip", "\u00a77Advanced System on Chip");
        provider.add("item.gtceu.plate.highly_advanced_system_on_chip.tooltip", "\u00a77Highly Advanced System on Chip");
        provider.add("item.gtceu.plate.integrated_logic_circuit.tooltip", "\u00a77Integrated Logic Circuit");
        provider.add("item.gtceu.plate.central_processing_unit.tooltip", "\u00a77Central Processing Unit");
        provider.add("item.gtceu.plate.high_power_integrated_circuit.tooltip", "\u00a77High Power IC");
        provider.add("item.gtceu.plate.ultra_high_power_integrated_circuit.tooltip", "\u00a77Ultra High Power IC");
        provider.add("item.gtceu.plate.nand_memory_chip.tooltip", "\u00a77NAND Logic Gate");
        provider.add("item.gtceu.plate.nano_central_processing_unit.tooltip", "\u00a77Nano Central Processing Unit");
        provider.add("item.gtceu.plate.nor_memory_chip.tooltip", "\u00a77NOR Logic Gate");
        provider.add("item.gtceu.plate.ultra_low_power_integrated_circuit.tooltip", "\u00a77Ultra Low Power IC");
        provider.add("item.gtceu.plate.low_power_integrated_circuit.tooltip", "\u00a77Low Power IC");
        provider.add("item.gtceu.plate.power_integrated_circuit.tooltip", "\u00a77Power IC");
        provider.add("item.gtceu.plate.qbit_central_processing_unit.tooltip", "\u00a77Qubit Central Processing Unit");
        provider.add("item.gtceu.plate.random_access_memory.tooltip", "\u00a77Random Access Memory");
        provider.add("item.gtceu.plate.system_on_chip.tooltip", "\u00a77System on Chip");
        provider.add("item.gtceu.plate.simple_system_on_chip.tooltip", "\u00a77Simple System on Chip");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.electronic.tooltip", "\u00a77Your First Circuit\n\u00a7cLV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.good_electronic.tooltip", "\u00a77Your Second Circuit\n\u00a7cMV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.basic_integrated.tooltip", "\u00a77Smaller and more powerful\n\u00a76LV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.good_integrated.tooltip", "\u00a77Smaller and more powerful\n\u00a76MV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.advanced_integrated.tooltip", "\u00a77Smaller and more powerful\n\u00a76HV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.nand_chip.tooltip", "\u00a77A Superior Simple Circuit\n\u00a76ULV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.microprocessor.tooltip", "\u00a77A Superior Basic Circuit\n\u00a7eLV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.processor.tooltip", "\u00a77Amazing Computation Speed!\n\u00a7eMV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.assembly.tooltip", "\u00a77Amazing Computation Speed!\n\u00a7eHV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.workstation.tooltip", "\u00a77Amazing Computation Speed!\n\u00a7eEV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.mainframe.tooltip", "\u00a77Amazing Computation Speed!\n\u00a7eIV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.nano_processor.tooltip", "\u00a77Smaller than ever\n\u00a7bHV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.nano_assembly.tooltip", "\u00a77Smaller than ever\n\u00a7bEV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.nano_computer.tooltip", "\u00a77Smaller than ever\n\u00a7bIV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.nano_mainframe.tooltip", "\u00a77Smaller than ever\n\u00a7bLuV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.quantum_processor.tooltip", "\u00a77Quantum Computing comes to life!\n\u00a7aEV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.quantum_assembly.tooltip", "\u00a77Quantum Computing comes to life!\n\u00a7aIV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.quantum_computer.tooltip", "\u00a77Quantum Computing comes to life!\n\u00a7aLuV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.quantum_mainframe.tooltip", "\u00a77Quantum Computing comes to life!\n\u00a7aZPM-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.crystal_processor.tooltip", "\u00a77Taking Advantage of Crystal Engraving\n\u00a79IV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.crystal_assembly.tooltip", "\u00a77Taking Advantage of Crystal Engraving\n\u00a79LuV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.crystal_computer.tooltip", "\u00a77Taking Advantage of Crystal Engraving\n\u00a79ZPM-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.crystal_mainframe.tooltip", "\u00a77Taking Advantage of Crystal Engraving\n\u00a79UV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.wetware_processor.tooltip", "\u00a77You have a feeling like it's watching you\n\u00a74LuV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.wetware_assembly.tooltip", "\u00a77Can run Minecraft\n\u00a74ZPM-tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.wetware_computer.tooltip", "\u00a77Ultimate fusion of Flesh and Machine\n\u00a74UV-Tier Circuit");
        LangHandler.multilineLang(provider, "item.gtceu.circuit.wetware_mainframe.tooltip", "\u00a77The best Man has ever seen\n\u00a74UHV-Tier Circuit");
        provider.add("item.gtceu.stem_cells.tooltip", "\u00a77Raw Intelligence");
        provider.add("item.gtceu.processor.neuro.tooltip", "\u00a77Neuro CPU");
        provider.add("item.gtceu.petri_dish.tooltip", "\u00a77For cultivating Cells");
        provider.add("item.gtceu.neutron_reflector.tooltip", "\u00a77Indestructible");
        provider.add("item.gtceu.duct_tape.tooltip", "\u00a77If you can't fix it with this, use more of it!");
        provider.add("item.gtceu.quantumeye.tooltip", "\u00a77Improved Ender Eye");
        provider.add("item.gtceu.quantumstar.tooltip", "\u00a77Improved Nether Star");
        provider.add("item.gtceu.gravistar.tooltip", "\u00a77Ultimate Nether Star");
        LangHandler.multilineLang(provider, "item.gtceu.item_filter.tooltip", "\u00a77Filters \u00a7fItem\u00a77 I/O as \u00a7fCover\u00a77.\nCan be used as a \u00a7fConveyor Module\u00a77 and \u00a7fRobotic Arm\u00a77 upgrade.");
        LangHandler.multilineLang(provider, "item.gtceu.ore_dictionary_filter.tooltip", "\u00a77Filters \u00a7fItem\u00a77 I/O with \u00a7fOre Dictionary\u00a77 as \u00a7fCover\u00a77.\nCan be used as a \u00a7fConveyor Module\u00a77 and \u00a7fRobotic Arm\u00a77 upgrade.");
        LangHandler.multilineLang(provider, "item.gtceu.fluid_filter.tooltip", "\u00a77Filters \u00a7fFluid\u00a77 I/O as \u00a7fCover\u00a77.\nCan be used as an \u00a7fElectric Pump\u00a77 and \u00a7fFluid Regulator\u00a77 upgrade.");
        LangHandler.multilineLang(provider, "item.gtceu.smart_item_filter.tooltip", "\u00a77Filters \u00a7fItem\u00a77 I/O with \u00a7fMachine Recipes\u00a77 as \u00a7fCover\u00a77.\nCan be used as a \u00a7fConveyor Module\u00a77 and \u00a7fRobotic Arm\u00a77 upgrade.");
        provider.add("item.gtceu.cover.controller.tooltip", "\u00a77Turns Machines \u00a7fON/OFF\u00a77 as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.cover.activity.detector.tooltip", "\u00a77Gives out \u00a7fActivity Status\u00a77 as Redstone as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.cover.activity.detector_advanced.tooltip", "\u00a77Gives out \u00a7fMachine Progress\u00a77 as Redstone as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.cover.fluid.detector.tooltip", "\u00a77Gives out \u00a7fFluid Amount\u00a77 as Redstone as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.cover.fluid.detector.advanced.tooltip", "\u00a77Gives \u00a7fRS-Latch\u00a77 controlled \u00a7fFluid Storage Status\u00a77 as Redstone as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.cover.item.detector.tooltip", "\u00a77Gives out \u00a7fItem Amount\u00a77 as Redstone as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.cover.item.detector.advanced.tooltip", "\u00a77Gives \u00a7fRS-Latch\u00a77 controlled \u00a7fItem Storage Status\u00a77 as Redstone as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.cover.energy.detector.tooltip", "\u00a77Gives out \u00a7fEnergy Amount\u00a77 as Redstone as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.cover.energy.detector.advanced.tooltip", "\u00a77Gives \u00a7fRS-Latch\u00a77 controlled \u00a7fEnergy Status\u00a77 as Redstone as \u00a7fCover\u00a77.");
        LangHandler.multilineLang(provider, "item.gtceu.cover.fluid.voiding.tooltip", "\u00a77Voids \u00a7fFluids\u00a77 as \u00a7fCover\u00a77.\nActivate with \u00a7fSoft Mallet\u00a77 after placement.");
        LangHandler.multilineLang(provider, "item.gtceu.cover.fluid.voiding.advanced.tooltip", "\u00a77Voids \u00a7fFluids\u00a77 with amount control as \u00a7fCover\u00a77.\nActivate with \u00a7fSoft Mallet\u00a77 after placement.");
        LangHandler.multilineLang(provider, "item.gtceu.cover.item.voiding.tooltip", "\u00a77Voids \u00a7fItems\u00a77 as \u00a7fCover\u00a77.\nActivate with \u00a7fSoft Mallet\u00a77 after placement.");
        LangHandler.multilineLang(provider, "item.gtceu.cover.item.voiding.advanced.tooltip", "\u00a77Voids \u00a7fItems\u00a77 with amount control as \u00a7fCover\u00a77.\nActivate with \u00a7fSoft Mallet\u00a77 after placement.");
        provider.add("item.gtceu.cover.facade.tooltip", "\u00a77Decorative Outfit \u00a7fCover\u00a77.");
        provider.add("item.gtceu.cover.screen.tooltip", "\u00a77Displays \u00a7fData\u00a77 as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.cover.crafting.tooltip", "\u00a7fAdvanced Workbench\u00a77 on a Machine as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.cover.shutter.tooltip", "\u00a7fBlocks Transfer\u00a77 through attached Side as \u00a7fCover\u00a77.");
        LangHandler.multilineLang(provider, "item.gtceu.cover.solar.panel.tooltip", "\u00a77May the Sun be with you.\nProduces \u00a7fEnergy\u00a77 from the \u00a7eSun\u00a77 as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.cover.infinite_water.tooltip", "\u00a77Fills attached containers with \u00a79Water\u00a77 as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.cover.ender_fluid_link.tooltip", "\u00a77Transports \u00a7fFluids\u00a77 with a \u00a7fWireless \u00a7dEnder\u00a7f Connection\u00a77 as \u00a7fCover\u00a77.");
        provider.add("item.gtceu.gelled_toluene.tooltip", "\u00a77Raw Explosive");
        provider.add("item.gtceu.bottle.purple.drink.tooltip", "\u00a77How about Lemonade. Or some Ice Tea? I got Purple Drink!");
        LangHandler.multilineLang(provider, "item.gtceu.foam_sprayer.tooltip", "\u00a77Sprays Construction Foam\nUse on a frame to foam connected frames\nFoam can be colored");
        provider.add("item.gtceu.brick.fireclay.tooltip", "\u00a77Heat resistant");
    }
}

