/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core.mixins.top;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.MaterialToolTier;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import java.util.HashSet;
import java.util.Map;
import mcjty.theoneprobe.config.Config;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Config.class}, remap=false)
public class ConfigMixin {
    @Shadow
    private static Map<ResourceLocation, String> tooltypeTagsSet;
    @Shadow
    private static Map<ResourceLocation, String> harvestabilityTagsSet;

    @Inject(method={"getTooltypeTags"}, at={@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;")})
    private static void gtceu$injectToolTags(CallbackInfoReturnable<Map<ResourceLocation, String>> cir) {
        for (GTToolType type : GTToolType.values()) {
            if (tooltypeTagsSet.containsKey(type.itemTag.f_203868_())) continue;
            tooltypeTagsSet.put(type.itemTag.f_203868_(), I18n.m_118938_((String)type.getUnlocalizedName(), (Object[])new Object[0]));
        }
    }

    @Inject(method={"getHarvestabilityTags"}, at={@At(value="INVOKE", target="Ljava/util/List;iterator()Ljava/util/Iterator;")})
    private static void gtceu$injectHarvestTags(CallbackInfoReturnable<Map<ResourceLocation, String>> cir) {
        HashSet<Integer> passedTiers = new HashSet<Integer>();
        for (Material mat : GTRegistries.MATERIALS) {
            MaterialToolTier tier;
            int harvestLevel;
            if (!mat.hasProperty(PropertyKey.TOOL) || passedTiers.contains(harvestLevel = (tier = mat.getToolTier()).m_6604_())) continue;
            passedTiers.add(harvestLevel);
            TagKey<Block> tag = CustomTags.TOOL_TIERS[harvestLevel];
            if (harvestabilityTagsSet.containsKey(tag.f_203868_())) continue;
            harvestabilityTagsSet.put(tag.f_203868_(), mat.getLocalizedName().getString());
        }
    }
}

