/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.core;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.addon.AddonFinder;
import com.gregtechceu.gtceu.api.addon.IGTAddon;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.fluids.store.FluidStorage;
import com.gregtechceu.gtceu.common.data.GTRecipes;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.forge.MixinHelpersImpl;
import com.gregtechceu.gtceu.core.mixins.BlockBehaviourAccessor;
import com.gregtechceu.gtceu.data.pack.GTDynamicDataPack;
import com.gregtechceu.gtceu.data.pack.GTDynamicResourcePack;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import com.tterrag.registrate.util.entry.BlockEntry;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.data.loot.packs.VanillaBlockLoot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class MixinHelpers {
    public static void addMaterialBlockTags(Map<ResourceLocation, List<TagLoader.EntryWithSource>> tagMap, TagPrefix prefix, Map<Material, ? extends BlockEntry<? extends Block>> map) {
        if (!prefix.miningToolTag().isEmpty()) {
            map.forEach((material, block) -> {
                tagMap.computeIfAbsent(CustomTags.TOOL_TIERS[material.getBlockHarvestLevel()].f_203868_(), path -> new ArrayList()).add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)block.getId()), "GTCEu Custom Tags"));
                TagLoader.EntryWithSource entry = new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)block.getId()), "GTCEu Custom Tags");
                if (material.hasProperty(PropertyKey.WOOD)) {
                    tagMap.computeIfAbsent(BlockTags.f_144280_.f_203868_(), path -> new ArrayList()).add(entry);
                } else {
                    for (TagKey<Block> tag : prefix.miningToolTag()) {
                        tagMap.computeIfAbsent(tag.f_203868_(), path -> new ArrayList()).add(entry);
                    }
                    if (!ConfigHolder.INSTANCE.machines.requireGTToolsForBlocks) {
                        tagMap.computeIfAbsent(BlockTags.f_144282_.f_203868_(), path -> new ArrayList()).add(entry);
                    }
                }
            });
        }
        map.forEach((material, block) -> {
            for (TagKey<Block> blockTag : prefix.getAllBlockTags((Material)material)) {
                tagMap.computeIfAbsent(blockTag.f_203868_(), path -> new ArrayList()).add(new TagLoader.EntryWithSource(TagEntry.m_215925_((ResourceLocation)block.getId()), "GTCEu Custom Tags"));
            }
        });
    }

    public static void addMaterialBlockLootTables(Map<ResourceLocation, LootTable> lootTables, TagPrefix prefix, Map<Material, ? extends BlockEntry<? extends Block>> map) {
        map.forEach((material, blockEntry) -> {
            ResourceLocation lootTableId = new ResourceLocation(blockEntry.getId().m_135827_(), "blocks/" + blockEntry.getId().m_135815_());
            ((BlockBehaviourAccessor)blockEntry.get()).setDrops(lootTableId);
            lootTables.put(lootTableId, new VanillaBlockLoot().m_247033_((ItemLike)blockEntry.get()).m_79165_(LootContextParamSets.f_81421_).m_79167_());
        });
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addFluidTexture(Material material, FluidStorage.FluidEntry value) {
        void var1_1;
        MixinHelpersImpl.addFluidTexture(material, (FluidStorage.FluidEntry)var1_1);
    }

    public static List<PackResources> addDynamicDataPack(Collection<PackResources> packs) {
        ArrayList<PackResources> packResources = new ArrayList<PackResources>(packs);
        GTDynamicDataPack.clearServer();
        long startTime = System.currentTimeMillis();
        ChemicalHelper.reinitializeUnification();
        GTRecipes.recipeAddition(GTDynamicDataPack::addRecipe);
        GTCEu.LOGGER.info("GregTech Recipe loading took {}ms", (Object)(System.currentTimeMillis() - startTime));
        packResources.add(new GTDynamicDataPack("gtceu:dynamic_data", AddonFinder.getAddons().stream().map(IGTAddon::addonModId).collect(Collectors.toSet())));
        return packResources;
    }

    public static List<PackResources> addDynamicResourcePack(Collection<PackResources> packs) {
        ArrayList<PackResources> packResources = new ArrayList<PackResources>(packs);
        GTDynamicResourcePack.clearClient();
        packResources.add(new GTDynamicResourcePack("gtceu:dynamic_assets", AddonFinder.getAddons().stream().map(IGTAddon::addonModId).collect(Collectors.toSet())));
        return packResources;
    }

    public static void initializeDynamicTextures() {
    }
}

