/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.laser;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ILaserContainer;
import com.gregtechceu.gtceu.api.pipenet.IAttachData;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserNetWalker;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeProperties;
import com.gregtechceu.gtceu.common.pipelike.laser.LevelLaserPipeNet;
import com.lowdragmc.lowdraglib.pipelike.LevelPipeNet;
import com.lowdragmc.lowdraglib.pipelike.Node;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;

public class LaserPipeNet
extends PipeNet<LaserData> {
    private final Map<BlockPos, LaserData> netData = new Object2ObjectOpenHashMap();

    public LaserPipeNet(LevelLaserPipeNet world) {
        super((LevelPipeNet)world);
    }

    @Nullable
    public LaserData getNetData(BlockPos pipePos, Direction facing) {
        LaserData data = this.netData.get(pipePos);
        if (data == null) {
            data = LaserNetWalker.createNetData(this, pipePos, facing);
            if (data == null) {
                return null;
            }
            this.netData.put(pipePos, data);
        }
        return data;
    }

    public void onNeighbourUpdate(BlockPos fromPos) {
        this.netData.clear();
    }

    public void onPipeConnectionsUpdate() {
        this.netData.clear();
    }

    protected void transferNodeData(Map<BlockPos, Node<LaserData>> transferredNodes, PipeNet<LaserData> parentNet) {
        super.transferNodeData(transferredNodes, parentNet);
        this.netData.clear();
        ((LaserPipeNet)parentNet).netData.clear();
    }

    protected void writeNodeData(LaserData nodeData, CompoundTag tagCompound) {
        tagCompound.m_128365_("pipePos", (Tag)NbtUtils.m_129224_((BlockPos)nodeData.getPipePos()));
        tagCompound.m_128344_("faceToHandler", (byte)nodeData.faceToHandler.ordinal());
        tagCompound.m_128405_("distance", nodeData.distance);
        tagCompound.m_128344_("connections", nodeData.connections);
    }

    protected LaserData readNodeData(CompoundTag tagCompound) {
        BlockPos pipePos = NbtUtils.m_129239_((CompoundTag)tagCompound.m_128469_("pipePos"));
        Direction direction = Direction.values()[tagCompound.m_128445_("faceToHandler")];
        int distance = tagCompound.m_128451_("distance");
        return new LaserData(pipePos, direction, distance, LaserPipeProperties.INSTANCE, tagCompound.m_128445_("connections"));
    }

    public static class LaserData
    implements IAttachData {
        private final BlockPos pipePos;
        private final Direction faceToHandler;
        private final int distance;
        private final LaserPipeProperties properties;
        byte connections;

        @Override
        public boolean canAttachTo(Direction side) {
            return (this.connections & 1 << side.ordinal()) != 0 && side.m_122434_() == this.faceToHandler.m_122434_();
        }

        @Override
        public boolean setAttached(Direction side, boolean attach) {
            boolean result = this.canAttachTo(side);
            if (result != attach) {
                this.connections = attach ? (byte)(this.connections | 1 << side.ordinal()) : (byte)(this.connections & ~(1 << side.ordinal()));
            }
            return result != attach;
        }

        @Nonnull
        public BlockPos getHandlerPos() {
            return this.pipePos.m_121945_(this.faceToHandler);
        }

        @Nullable
        public ILaserContainer getHandler(@Nonnull Level world) {
            return GTCapabilityHelper.getLaser(world, this.getHandlerPos(), this.faceToHandler.m_122424_());
        }

        public LaserData(BlockPos pipePos, Direction faceToHandler, int distance, LaserPipeProperties properties, byte connections) {
            this.pipePos = pipePos;
            this.faceToHandler = faceToHandler;
            this.distance = distance;
            this.properties = properties;
            this.connections = connections;
        }

        public BlockPos getPipePos() {
            return this.pipePos;
        }

        public Direction getFaceToHandler() {
            return this.faceToHandler;
        }

        public int getDistance() {
            return this.distance;
        }

        public LaserPipeProperties getProperties() {
            return this.properties;
        }

        public byte getConnections() {
            return this.connections;
        }
    }
}

