/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.item;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.common.blockentity.ItemPipeBlockEntity;
import com.gregtechceu.gtceu.common.cover.ItemFilterCover;
import com.gregtechceu.gtceu.common.cover.data.ItemFilterMode;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeData;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeNet;
import com.lowdragmc.lowdraglib.pipelike.Node;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import com.lowdragmc.lowdraglib.pipelike.PipeNetWalker;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ItemNetWalker
extends PipeNetWalker<ItemPipeData, ItemPipeNet> {
    private ItemPipeProperties minProperties;
    private final List<ItemPipeNet.Inventory> inventories;
    private final List<Predicate<ItemStack>> filters = new ArrayList<Predicate<ItemStack>>();
    private final List<Predicate<ItemStack>> nextFilters = new ArrayList<Predicate<ItemStack>>();
    private BlockPos sourcePipe;
    private Direction facingToHandler;

    public static List<ItemPipeNet.Inventory> createNetData(ItemPipeNet pipeNet, BlockPos sourcePipe) {
        try {
            ItemNetWalker walker = new ItemNetWalker(pipeNet, sourcePipe, 1, new ArrayList<ItemPipeNet.Inventory>(), null);
            walker.traversePipeNet();
            return walker.inventories;
        }
        catch (Exception e) {
            GTCEu.LOGGER.error("error while create net data for ItemPipeNet", (Throwable)e);
            return null;
        }
    }

    protected ItemNetWalker(ItemPipeNet world, BlockPos sourcePipe, int distance, List<ItemPipeNet.Inventory> inventories, ItemPipeProperties properties) {
        super((PipeNet)world, sourcePipe, distance);
        this.inventories = inventories;
        this.minProperties = properties;
    }

    protected PipeNetWalker<ItemPipeData, ItemPipeNet> createSubWalker(ItemPipeNet world, BlockPos nextPos, int walkedBlocks) {
        ItemNetWalker walker = new ItemNetWalker(world, nextPos, walkedBlocks, this.inventories, this.minProperties);
        walker.facingToHandler = this.facingToHandler;
        walker.sourcePipe = this.sourcePipe;
        walker.filters.addAll(this.filters);
        List<Predicate<ItemStack>> moreFilters = this.nextFilters;
        if (moreFilters != null && !moreFilters.isEmpty()) {
            walker.filters.addAll(moreFilters);
        }
        return walker;
    }

    protected boolean checkPipe(Node<ItemPipeData> pipeNode, BlockPos pos) {
        if (!this.nextFilters.isEmpty()) {
            this.filters.addAll(this.nextFilters);
        }
        this.nextFilters.clear();
        ItemPipeProperties pipeProperties = ((ItemPipeData)pipeNode.data).properties;
        this.minProperties = this.minProperties == null ? pipeProperties : new ItemPipeProperties(this.minProperties.getPriority() + pipeProperties.getPriority(), Math.min(this.minProperties.getTransferRate(), pipeProperties.getTransferRate()));
        return true;
    }

    protected void checkNeighbour(Node<ItemPipeData> pipeNode, BlockPos pipePos, Direction faceToNeighbour) {
        if (pipeNode == null || pipePos.equals((Object)this.sourcePipe) && faceToNeighbour == this.facingToHandler) {
            return;
        }
        if (this.getLevel().m_7702_(pipePos.m_121945_(faceToNeighbour)) instanceof ItemPipeBlockEntity && !this.isValidPipe(pipePos, faceToNeighbour)) {
            return;
        }
        IItemTransfer handler = ItemTransferHelper.getItemTransfer((Level)this.getLevel(), (BlockPos)pipePos, (Direction)faceToNeighbour.m_122424_());
        if (handler != null) {
            ArrayList<Predicate<ItemStack>> filters = new ArrayList<Predicate<ItemStack>>(this.filters);
            List<Predicate<ItemStack>> moreFilters = this.nextFilters;
            if (moreFilters != null && !moreFilters.isEmpty()) {
                filters.addAll(moreFilters);
            }
            this.inventories.add(new ItemPipeNet.Inventory(new BlockPos((Vec3i)pipePos), faceToNeighbour, this.getWalkedBlocks(), this.minProperties, filters));
        }
    }

    protected boolean isValidPipe(BlockPos pipePos, Direction faceToNeighbour) {
        ItemFilterCover filterCover;
        ItemPipeBlockEntity neighbourPipeBE;
        BlockEntity currentPipe;
        block7: {
            block6: {
                currentPipe = this.getLevel().m_7702_(pipePos);
                BlockEntity blockEntity = this.getLevel().m_7702_(pipePos.m_121945_(faceToNeighbour));
                if (!(blockEntity instanceof ItemPipeBlockEntity)) break block6;
                neighbourPipeBE = (ItemPipeBlockEntity)blockEntity;
                if (currentPipe instanceof ItemPipeBlockEntity) break block7;
            }
            return false;
        }
        ItemPipeBlockEntity currentPipeBE = (ItemPipeBlockEntity)currentPipe;
        CoverBehavior thisCover = currentPipeBE.getCoverContainer().getCoverAtSide(faceToNeighbour);
        CoverBehavior neighbourCover = neighbourPipeBE.getCoverContainer().getCoverAtSide(faceToNeighbour.m_122424_());
        ArrayList<Predicate<ItemStack>> filters = new ArrayList<Predicate<ItemStack>>();
        if (thisCover instanceof ItemFilterCover && (filterCover = (ItemFilterCover)thisCover).getFilterMode() != ItemFilterMode.FILTER_INSERT) {
            filters.add(filterCover.getItemFilter()::test);
        }
        if (neighbourCover instanceof ItemFilterCover && (filterCover = (ItemFilterCover)neighbourCover).getFilterMode() != ItemFilterMode.FILTER_EXTRACT) {
            filters.add(filterCover.getItemFilter()::test);
        }
        if (!filters.isEmpty()) {
            this.nextFilters.addAll(filters);
        }
        return true;
    }
}

