/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.pipelike.cable;

import com.gregtechceu.gtceu.common.pipelike.cable.CableData;
import com.gregtechceu.gtceu.common.pipelike.cable.CableRoutePath;
import com.gregtechceu.gtceu.common.pipelike.cable.EnergyNet;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.pipelike.Node;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import com.lowdragmc.lowdraglib.pipelike.PipeNetWalker;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class EnergyNetWalker
extends PipeNetWalker<CableData, EnergyNet> {
    private final List<CableRoutePath> routes;
    private List<Pair<BlockPos, CableData>> pipes = new ArrayList<Pair<BlockPos, CableData>>();
    private int loss;

    @Nullable
    public static List<CableRoutePath> createNetData(EnergyNet pipeNet, BlockPos sourcePipe) {
        try {
            EnergyNetWalker walker = new EnergyNetWalker(pipeNet, sourcePipe, 1, new ArrayList<CableRoutePath>());
            walker.traversePipeNet();
            return walker.routes;
        }
        catch (Exception e) {
            LDLib.LOGGER.error("error while create net data for energynet", (Throwable)e);
            return null;
        }
    }

    public EnergyNetWalker(EnergyNet pipeNet, BlockPos sourcePipe, int walkedBlocks, List<CableRoutePath> routes) {
        super((PipeNet)pipeNet, sourcePipe, walkedBlocks);
        this.routes = routes;
    }

    @NotNull
    protected PipeNetWalker<CableData, EnergyNet> createSubWalker(EnergyNet pipeNet, BlockPos nextPos, int walkedBlocks) {
        EnergyNetWalker walker = new EnergyNetWalker(pipeNet, nextPos, walkedBlocks, this.routes);
        walker.loss = this.loss;
        walker.pipes = new ArrayList<Pair<BlockPos, CableData>>(this.pipes);
        return walker;
    }

    protected boolean checkPipe(Node<CableData> pipeNode, BlockPos pos) {
        this.pipes.add((Pair<BlockPos, CableData>)new Pair((Object)pos.m_7949_(), (Object)((CableData)pipeNode.data)));
        this.loss += ((CableData)pipeNode.data).properties().getLossPerBlock();
        return true;
    }

    protected void checkNeighbour(Node<CableData> pipeNode, BlockPos pipePos, Direction faceToNeighbour) {
        if (((CableData)pipeNode.data).canAttachTo(faceToNeighbour)) {
            this.routes.add(new CableRoutePath(pipePos.m_7949_(), faceToNeighbour, (Pair[])this.pipes.toArray(Pair[]::new), this.getWalkedBlocks(), this.loss));
        }
    }
}

