/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.trait;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.data.worldgen.GTOreDefinition;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.BedrockOreVeinSavedData;
import com.gregtechceu.gtceu.api.data.worldgen.bedrockore.OreVeinWorldEntry;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.common.machine.multiblock.electric.BedrockOreMinerMachine;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.recipe.builder.GTRecipeBuilder;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class BedrockOreMinerLogic
extends RecipeLogic {
    public static final int MAX_PROGRESS = 20;
    @Nullable
    private List<Map.Entry<Integer, Material>> veinMaterials;

    public BedrockOreMinerLogic(BedrockOreMinerMachine machine) {
        super(machine);
    }

    @Override
    public BedrockOreMinerMachine getMachine() {
        return (BedrockOreMinerMachine)super.getMachine();
    }

    @Override
    public void findAndHandleRecipe() {
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            GTRecipe match;
            ServerLevel serverLevel = (ServerLevel)level;
            this.lastRecipe = null;
            BedrockOreVeinSavedData data = BedrockOreVeinSavedData.getOrCreate(serverLevel);
            if (this.veinMaterials == null) {
                this.veinMaterials = data.getOreInChunk(this.getChunkX(), this.getChunkZ());
                if (this.veinMaterials == null) {
                    if (this.subscription != null) {
                        this.subscription.unsubscribe();
                        this.subscription = null;
                    }
                    return;
                }
            }
            if ((match = this.getOreMinerRecipe()) != null) {
                GTRecipe copied = match.copy(new ContentModifier(match.duration, 0.0));
                if (match.matchRecipe(this.machine).isSuccess() && copied.matchTickRecipe(this.machine).isSuccess()) {
                    this.setupRecipe(match);
                }
            }
        }
    }

    @Nullable
    private GTRecipe getOreMinerRecipe() {
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.veinMaterials != null) {
                GTRecipe recipe;
                BedrockOreVeinSavedData data = BedrockOreVeinSavedData.getOrCreate(serverLevel);
                Material material = this.veinMaterials.get(GTUtil.getRandomItem(this.veinMaterials, this.veinMaterials.size())).getValue();
                ItemStack stack = ChemicalHelper.get(TagPrefix.get(ConfigHolder.INSTANCE.machines.bedrockOreDropTagPrefix), material, this.getOreToProduce(data.getOreVeinWorldEntry(this.getChunkX(), this.getChunkZ())));
                if (stack.m_41619_()) {
                    stack = ChemicalHelper.get(TagPrefix.crushed, material, this.getOreToProduce(data.getOreVeinWorldEntry(this.getChunkX(), this.getChunkZ())));
                }
                if (stack.m_41619_()) {
                    stack = ChemicalHelper.get(TagPrefix.gem, material, this.getOreToProduce(data.getOreVeinWorldEntry(this.getChunkX(), this.getChunkZ())));
                }
                if (stack.m_41619_()) {
                    stack = ChemicalHelper.get(TagPrefix.ore, material, this.getOreToProduce(data.getOreVeinWorldEntry(this.getChunkX(), this.getChunkZ())));
                }
                if ((recipe = GTRecipeBuilder.ofRaw().duration(20).EUt(GTValues.VA[this.getMachine().getEnergyTier()]).outputItems(stack).buildRawRecipe()).matchRecipe(this.getMachine()).isSuccess() && recipe.matchTickRecipe(this.getMachine()).isSuccess()) {
                    return recipe;
                }
            }
        }
        return null;
    }

    private int getOreToProduce(OreVeinWorldEntry entry) {
        GTOreDefinition definition = entry.getDefinition();
        if (definition != null) {
            int depletedYield = definition.getDepletedYield();
            int regularYield = entry.getOreYield();
            int remainingOperations = entry.getOperationsRemaining();
            int produced = Math.max(depletedYield, regularYield * remainingOperations / 100000);
            produced *= BedrockOreMinerMachine.getRigMultiplier(this.getMachine().getTier());
            if (this.isOverclocked()) {
                produced = produced * 3 / 2;
            }
            return produced;
        }
        return 0;
    }

    @Override
    public void onRecipeFinish() {
        this.machine.afterWorking();
        if (this.lastRecipe != null) {
            this.lastRecipe.postWorking(this.machine);
            this.lastRecipe.handleRecipeIO(IO.OUT, this.machine);
        }
        this.depleteVein();
        GTRecipe match = this.getOreMinerRecipe();
        if (match != null) {
            GTRecipe copied = match.copy(new ContentModifier(match.duration, 0.0));
            if (match.matchRecipe(this.machine).isSuccess() && copied.matchTickRecipe(this.machine).isSuccess()) {
                this.setupRecipe(match);
                return;
            }
        }
        this.setStatus(RecipeLogic.Status.IDLE);
        this.progress = 0;
        this.duration = 0;
    }

    protected void depleteVein() {
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            int chance = BedrockOreMinerMachine.getDepletionChance(this.getMachine().getTier());
            BedrockOreVeinSavedData data = BedrockOreVeinSavedData.getOrCreate(serverLevel);
            if (chance == 1 || GTValues.RNG.m_188503_(chance) == 0) {
                data.depleteVein(this.getChunkX(), this.getChunkZ(), 0, false);
            }
        }
    }

    protected boolean isOverclocked() {
        return this.getMachine().getEnergyTier() > this.getMachine().getTier();
    }

    private int getChunkX() {
        return SectionPos.m_123171_((int)this.getMachine().getPos().m_123341_());
    }

    private int getChunkZ() {
        return SectionPos.m_123171_((int)this.getMachine().getPos().m_123343_());
    }

    @Nullable
    public List<Map.Entry<Integer, Material>> getVeinMaterials() {
        return this.veinMaterials;
    }
}

