/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.steam;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialStack;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IMachineModifyDrops;
import com.gregtechceu.gtceu.api.machine.steam.SteamBoilerMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SteamSolidBoilerMachine
extends SteamBoilerMachine
implements IMachineModifyDrops {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(SteamSolidBoilerMachine.class, SteamBoilerMachine.MANAGED_FIELD_HOLDER);
    public static final Object2BooleanMap<Item> FUEL_CACHE = new Object2BooleanOpenHashMap();
    @Persisted
    public final NotifiableItemStackHandler fuelHandler;
    @Persisted
    public final NotifiableItemStackHandler ashHandler;

    public SteamSolidBoilerMachine(IMachineBlockEntity holder, boolean isHighPressure, Object ... args) {
        super(holder, isHighPressure, args);
        this.fuelHandler = this.createFuelHandler(args).setFilter(itemStack -> FUEL_CACHE.computeIfAbsent((Object)itemStack.m_41720_(), item -> {
            if (this.isRemote()) {
                return true;
            }
            return this.recipeLogic.getRecipeManager().m_44013_((RecipeType)this.getRecipeType()).stream().anyMatch(recipe -> {
                List list = recipe.inputs.getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList());
                if (!list.isEmpty()) {
                    return Arrays.stream(((Ingredient)ItemRecipeCapability.CAP.of(((Content)list.get((int)0)).content)).m_43908_()).map(ItemStack::m_41720_).anyMatch(i -> i == item);
                }
                return false;
            });
        }));
        this.ashHandler = this.createAshHandler(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableItemStackHandler createFuelHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, 1, IO.IN, IO.IN);
    }

    protected NotifiableItemStackHandler createAshHandler(Object ... args) {
        return new NotifiableItemStackHandler(this, 1, IO.OUT, IO.OUT);
    }

    @Override
    protected long getBaseSteamOutput() {
        return this.isHighPressure ? 300 : 120;
    }

    @Override
    public void afterWorking() {
        ItemStack remaining;
        ItemStack[] input;
        List inputs;
        super.afterWorking();
        if (this.recipeLogic.getLastRecipe() != null && !(inputs = this.recipeLogic.getLastRecipe().inputs.getOrDefault(ItemRecipeCapability.CAP, Collections.emptyList())).isEmpty() && (input = ((Ingredient)ItemRecipeCapability.CAP.of(((Content)inputs.get((int)0)).content)).m_43908_()).length > 0 && !(remaining = SteamSolidBoilerMachine.getBurningFuelRemainder(input[0])).m_41619_()) {
            this.ashHandler.insertItem(0, remaining, false);
        }
    }

    public static ItemStack getBurningFuelRemainder(ItemStack fuelStack) {
        float remainderChance;
        ItemStack remainder;
        MaterialStack materialStack = ChemicalHelper.getMaterial(fuelStack);
        if (materialStack == null) {
            return ItemStack.f_41583_;
        }
        if (materialStack.material() == GTMaterials.Charcoal) {
            remainder = ChemicalHelper.get(TagPrefix.dust, GTMaterials.Ash);
            remainderChance = 0.3f;
        } else if (materialStack.material() == GTMaterials.Coal) {
            remainder = ChemicalHelper.get(TagPrefix.dust, GTMaterials.DarkAsh);
            remainderChance = 0.35f;
        } else if (materialStack.material() == GTMaterials.Coke) {
            remainder = ChemicalHelper.get(TagPrefix.dust, GTMaterials.Ash);
            remainderChance = 0.5f;
        } else {
            return ItemStack.f_41583_;
        }
        return GTValues.RNG.m_188501_() <= remainderChance ? remainder : ItemStack.f_41583_;
    }

    @Override
    public ModularUI createUI(Player entityPlayer) {
        return super.createUI(entityPlayer).widget((Widget)new SlotWidget((IItemTransfer)this.fuelHandler.storage, 0, 115, 62).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.COAL_OVERLAY_STEAM.get(this.isHighPressure)}))).widget((Widget)new SlotWidget((IItemTransfer)this.ashHandler.storage, 0, 115, 26, true, false).setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT_STEAM.get(this.isHighPressure), GuiTextures.DUST_OVERLAY_STEAM.get(this.isHighPressure)}))).widget((Widget)new ProgressWidget(this.recipeLogic::getProgressPercent, 115, 44, 18, 18).setProgressTexture((IGuiTexture)GuiTextures.PROGRESS_BAR_BOILER_FUEL.get(this.isHighPressure).getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)GuiTextures.PROGRESS_BAR_BOILER_FUEL.get(this.isHighPressure).getSubTexture(0.0, 0.5, 1.0, 0.5)).setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP));
    }

    @Override
    public void onDrops(List<ItemStack> drops, Player entity) {
        SteamSolidBoilerMachine.clearInventory(drops, (IItemTransfer)this.fuelHandler.storage);
        SteamSolidBoilerMachine.clearInventory(drops, (IItemTransfer)this.ashHandler.storage);
    }
}

