/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.multiblock.part;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredIOPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableLaserContainer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;

@ParametersAreNonnullByDefault
public class LaserHatchPartMachine
extends TieredIOPartMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(TieredIOPartMachine.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    private NotifiableLaserContainer buffer;

    public LaserHatchPartMachine(IMachineBlockEntity holder, IO io, int tier, int amperage) {
        super(holder, tier, io);
        if (io == IO.OUT) {
            this.buffer = NotifiableLaserContainer.emitterContainer(this, GTValues.V[tier] * 64L * (long)amperage, GTValues.V[tier], amperage);
            this.buffer.setSideOutputCondition(s -> s == this.getFrontFacing());
        } else {
            this.buffer = NotifiableLaserContainer.receiverContainer(this, GTValues.V[tier] * 64L * (long)amperage, GTValues.V[tier], amperage);
            this.buffer.setSideInputCondition(s -> s == this.getFrontFacing());
        }
    }

    @Override
    public boolean shouldOpenUI(Player player, InteractionHand hand, BlockHitResult hit) {
        return false;
    }

    @Override
    public boolean canShared() {
        return false;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }
}

