/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.machine.electric;

import appeng.me.helpers.IGridConnectedBlockEntity;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.multiblock.part.MultiblockPartMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.part.TieredPartMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.integration.ae2.machine.trait.GridNodeHostTrait;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class HullMachine
extends TieredPartMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(HullMachine.class, MultiblockPartMachine.MANAGED_FIELD_HOLDER);
    private final Object gridNodeHost = GTCEu.isAE2Loaded() ? new GridNodeHostTrait(this) : null;
    @Persisted
    protected NotifiableEnergyContainer energyContainer;

    public HullMachine(IMachineBlockEntity holder, int tier) {
        super(holder, tier);
        this.reinitializeEnergyContainer();
    }

    protected void reinitializeEnergyContainer() {
        long tierVoltage = GTValues.V[this.getTier()];
        this.energyContainer = new NotifiableEnergyContainer(this, tierVoltage * 16L, tierVoltage, 1L, tierVoltage, 1L);
        this.energyContainer.setSideOutputCondition(s -> s == this.getFrontFacing());
    }

    @Override
    public void onLoad() {
        Object object;
        super.onLoad();
        if (GTCEu.isAE2Loaded() && (object = this.gridNodeHost) instanceof GridNodeHostTrait) {
            GridNodeHostTrait connectedBlockEntity = (GridNodeHostTrait)object;
            object = this.getLevel();
            if (object instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)object;
                level.m_7654_().m_6937_((Runnable)new TickTask(0, connectedBlockEntity::init));
            }
        }
    }

    @Override
    public void onUnload() {
        Object object;
        super.onUnload();
        if (GTCEu.isAE2Loaded() && (object = this.gridNodeHost) instanceof GridNodeHostTrait) {
            GridNodeHostTrait connectedBlockEntity = (GridNodeHostTrait)object;
            connectedBlockEntity.getMainNode().destroy();
        }
    }

    @Override
    public void setFrontFacing(Direction facing) {
        Object object;
        super.setFrontFacing(facing);
        if (this.isFacingValid(facing) && GTCEu.isAE2Loaded() && (object = this.gridNodeHost) instanceof GridNodeHostTrait) {
            GridNodeHostTrait connectedBlockEntity = (GridNodeHostTrait)object;
            connectedBlockEntity.init();
        }
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void saveCustomPersistedData(CompoundTag tag, boolean forDrop) {
        Object object;
        super.saveCustomPersistedData(tag, forDrop);
        if (GTCEu.isAE2Loaded() && (object = this.gridNodeHost) instanceof IGridConnectedBlockEntity) {
            IGridConnectedBlockEntity connectedBlockEntity = (IGridConnectedBlockEntity)object;
            CompoundTag nbt = new CompoundTag();
            connectedBlockEntity.getMainNode().saveToNBT(nbt);
            tag.m_128365_("grid_node", (Tag)nbt);
        }
    }

    @Override
    public void loadCustomPersistedData(CompoundTag tag) {
        Object object;
        super.loadCustomPersistedData(tag);
        if (GTCEu.isAE2Loaded() && (object = this.gridNodeHost) instanceof IGridConnectedBlockEntity) {
            IGridConnectedBlockEntity connectedBlockEntity = (IGridConnectedBlockEntity)object;
            connectedBlockEntity.getMainNode().loadFromNBT(tag.m_128469_("grid_node"));
        }
    }
}

