/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.cover;

import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.cover.CoverDefinition;
import com.gregtechceu.gtceu.api.cover.filter.ItemFilter;
import com.gregtechceu.gtceu.api.cover.filter.SimpleItemFilter;
import com.gregtechceu.gtceu.api.gui.widget.EnumSelectorWidget;
import com.gregtechceu.gtceu.api.gui.widget.IntInputWidget;
import com.gregtechceu.gtceu.common.cover.ConveyorCover;
import com.gregtechceu.gtceu.common.cover.data.TransferMode;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class RobotArmCover
extends ConveyorCover {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(RobotArmCover.class, ConveyorCover.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    protected TransferMode transferMode;
    @Persisted
    protected int globalTransferLimit;
    protected int itemsTransferBuffered;
    private IntInputWidget stackSizeInput;

    public RobotArmCover(CoverDefinition definition, ICoverable coverHolder, Direction attachedSide, int tier) {
        super(definition, coverHolder, attachedSide, tier);
        this.setTransferMode(TransferMode.TRANSFER_ANY);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected int doTransferItems(IItemTransfer sourceInventory, IItemTransfer targetInventory, int maxTransferAmount) {
        return switch (this.transferMode) {
            default -> throw new IncompatibleClassChangeError();
            case TransferMode.TRANSFER_ANY -> this.moveInventoryItems(sourceInventory, targetInventory, maxTransferAmount);
            case TransferMode.TRANSFER_EXACT -> this.doTransferExact(sourceInventory, targetInventory, maxTransferAmount);
            case TransferMode.KEEP_EXACT -> this.doKeepExact(sourceInventory, targetInventory, maxTransferAmount);
        };
    }

    protected int doTransferExact(IItemTransfer sourceInventory, IItemTransfer targetInventory, int maxTransferAmount) {
        Map<ItemStack, ConveyorCover.TypeItemInfo> sourceItemAmount = this.countInventoryItemsByType(sourceInventory);
        Iterator<ItemStack> iterator = sourceItemAmount.keySet().iterator();
        while (iterator.hasNext()) {
            ConveyorCover.TypeItemInfo sourceInfo = sourceItemAmount.get(iterator.next());
            int itemAmount = sourceInfo.totalCount;
            int itemToMoveAmount = this.getFilteredItemAmount(sourceInfo.itemStack);
            if (itemAmount >= itemToMoveAmount) {
                sourceInfo.totalCount = itemToMoveAmount;
                continue;
            }
            iterator.remove();
        }
        int itemsTransferred = 0;
        int maxTotalTransferAmount = maxTransferAmount + this.itemsTransferBuffered;
        boolean notEnoughTransferRate = false;
        for (ConveyorCover.TypeItemInfo itemInfo : sourceItemAmount.values()) {
            if (maxTotalTransferAmount >= itemInfo.totalCount) {
                boolean result = RobotArmCover.moveInventoryItemsExact(sourceInventory, targetInventory, itemInfo);
                itemsTransferred += result ? itemInfo.totalCount : 0;
                maxTotalTransferAmount -= result ? itemInfo.totalCount : 0;
                continue;
            }
            notEnoughTransferRate = true;
        }
        this.itemsTransferBuffered = itemsTransferred == 0 && notEnoughTransferRate ? (this.itemsTransferBuffered += maxTransferAmount) : 0;
        return Math.min(itemsTransferred, maxTransferAmount);
    }

    protected int doKeepExact(IItemTransfer sourceInventory, IItemTransfer targetInventory, int maxTransferAmount) {
        Map<ItemStack, ConveyorCover.GroupItemInfo> targetItemAmounts = this.countInventoryItemsByMatchSlot(targetInventory);
        Map<ItemStack, ConveyorCover.GroupItemInfo> sourceItemAmounts = this.countInventoryItemsByMatchSlot(sourceInventory);
        Iterator<ItemStack> iterator = sourceItemAmounts.keySet().iterator();
        while (iterator.hasNext()) {
            ItemStack filteredItem = iterator.next();
            ConveyorCover.GroupItemInfo sourceInfo = sourceItemAmounts.get(filteredItem);
            int itemToKeepAmount = this.getFilteredItemAmount(sourceInfo.itemStack);
            int itemAmount = 0;
            if (targetItemAmounts.containsKey(filteredItem)) {
                ConveyorCover.GroupItemInfo destItemInfo = targetItemAmounts.get(filteredItem);
                itemAmount = destItemInfo.totalCount;
            }
            if (itemAmount < itemToKeepAmount) {
                sourceInfo.totalCount = itemToKeepAmount - itemAmount;
                continue;
            }
            iterator.remove();
        }
        return this.moveInventoryItems(sourceInventory, targetInventory, sourceItemAmounts, maxTransferAmount);
    }

    private int getFilteredItemAmount(ItemStack itemStack) {
        if (!this.filterHandler.isFilterPresent()) {
            return this.globalTransferLimit;
        }
        ItemFilter filter = (ItemFilter)this.filterHandler.getFilter();
        return filter.isBlackList() ? this.globalTransferLimit : filter.testItemCount(itemStack);
    }

    @Override
    @NotNull
    protected String getUITitle() {
        return "cover.robotic_arm.title";
    }

    @Override
    protected void buildAdditionalUI(WidgetGroup group) {
        group.addWidget((Widget)new EnumSelectorWidget(146, 45, 20, 20, (Enum[])TransferMode.values(), (Enum)this.transferMode, this::setTransferMode));
        this.stackSizeInput = new IntInputWidget(64, 45, 80, 20, () -> this.globalTransferLimit, val -> {
            this.globalTransferLimit = val;
        });
        this.configureStackSizeInput();
        group.addWidget((Widget)this.stackSizeInput);
    }

    private void setTransferMode(TransferMode transferMode) {
        this.transferMode = transferMode;
        this.configureStackSizeInput();
        if (!this.isRemote()) {
            this.configureFilter();
        }
    }

    @Override
    protected void configureFilter() {
        Object f = this.filterHandler.getFilter();
        if (f instanceof SimpleItemFilter) {
            SimpleItemFilter filter;
            filter.setMaxStackSize((filter = (SimpleItemFilter)f).isBlackList() ? 1 : this.transferMode.maxStackSize);
        }
        this.configureStackSizeInput();
    }

    private void configureStackSizeInput() {
        if (this.stackSizeInput == null) {
            return;
        }
        this.stackSizeInput.setVisible(this.shouldShowStackSize());
        this.stackSizeInput.setMin(1);
        this.stackSizeInput.setMax(this.transferMode.maxStackSize);
    }

    private boolean shouldShowStackSize() {
        if (this.transferMode == TransferMode.TRANSFER_ANY) {
            return false;
        }
        if (!this.filterHandler.isFilterPresent()) {
            return true;
        }
        return ((ItemFilter)this.filterHandler.getFilter()).isBlackList();
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    public int getGlobalTransferLimit() {
        return this.globalTransferLimit;
    }
}

