/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ILaserContainer;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.common.blockentity.forge.LaserPipeBlockEntityImpl;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserNetHandler;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeNet;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeType;
import com.gregtechceu.gtceu.common.pipelike.laser.LevelLaserPipeNet;
import com.gregtechceu.gtceu.utils.TaskHandler;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class LaserPipeBlockEntity
extends PipeBlockEntity<LaserPipeType, LaserPipeNet.LaserData> {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(LaserPipeBlockEntity.class, PipeBlockEntity.MANAGED_FIELD_HOLDER);
    protected final EnumMap<Direction, LaserNetHandler> handlers = new EnumMap(Direction.class);
    public final ILaserContainer clientCapability = new DefaultLaserContainer();
    private WeakReference<LaserPipeNet> currentPipeNet = new WeakReference<Object>(null);
    protected LaserNetHandler defaultHandler;
    private int ticksActive = 0;
    private int activeDuration = 0;
    @Persisted
    @DescSynced
    private boolean active = false;

    protected LaserPipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static LaserPipeBlockEntity create(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        void var2_2;
        void var1_1;
        return LaserPipeBlockEntityImpl.create(type, (BlockPos)var1_1, (BlockState)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void onBlockEntityRegister(BlockEntityType<LaserPipeBlockEntity> cableBlockEntityBlockEntityType) {
        LaserPipeBlockEntityImpl.onBlockEntityRegister(cableBlockEntityBlockEntityType);
    }

    public void initHandlers() {
        LaserPipeNet net = this.getLaserPipeNet();
        if (net == null) {
            return;
        }
        for (Direction facing : Direction.values()) {
            this.handlers.put(facing, new LaserNetHandler(net, this, facing));
        }
        this.defaultHandler = new LaserNetHandler(net, this, null);
    }

    public void checkNetwork() {
        if (this.defaultHandler != null) {
            LaserPipeNet current = this.getLaserPipeNet();
            if (this.defaultHandler.getNet() != current) {
                this.defaultHandler.updateNetwork(current);
                for (LaserNetHandler handler : this.handlers.values()) {
                    handler.updateNetwork(current);
                }
            }
        }
    }

    public LaserPipeNet getLaserPipeNet() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return null;
        }
        LaserPipeNet currentPipeNet = (LaserPipeNet)((Object)this.currentPipeNet.get());
        if (currentPipeNet != null && currentPipeNet.isValid() && currentPipeNet.containsNode(this.getPipePos())) {
            return currentPipeNet;
        }
        LevelLaserPipeNet worldNet = (LevelLaserPipeNet)((Object)this.getPipeBlock().getWorldPipeNet((ServerLevel)this.getPipeLevel()));
        currentPipeNet = (LaserPipeNet)worldNet.getNetFromPos(this.getPipePos());
        if (currentPipeNet != null) {
            this.currentPipeNet = new WeakReference<LaserPipeNet>(currentPipeNet);
        }
        return currentPipeNet;
    }

    public void setActive(boolean active, int duration) {
        boolean stateChanged = false;
        if (this.active && !active) {
            this.active = false;
            stateChanged = true;
        } else if (!this.active && active) {
            this.active = true;
            stateChanged = true;
            this.activeDuration = duration;
            TaskHandler.enqueueServerTask((ServerLevel)this.m_58904_(), () -> {
                if (++this.ticksActive % this.activeDuration == 0) {
                    this.ticksActive = 0;
                    this.setActive(false, -1);
                }
            }, 0);
        } else if (this.active) {
            this.ticksActive = 0;
            this.activeDuration = duration;
        }
        if (stateChanged) {
            this.notifyBlockUpdate();
            this.m_6596_();
        }
    }

    @Override
    public boolean canAttachTo(Direction side) {
        if (this.f_58857_ != null) {
            if (this.f_58857_.m_7702_(this.m_58899_().m_121945_(side)) instanceof LaserPipeBlockEntity) {
                return false;
            }
            return GTCapabilityHelper.getLaser(this.f_58857_, this.m_58899_().m_121945_(side), side.m_122424_()) != null;
        }
        return false;
    }

    @Override
    protected boolean canToolTunePipe(GTToolType toolType) {
        return toolType == GTToolType.WIRE_CUTTER;
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public EnumMap<Direction, LaserNetHandler> getHandlers() {
        return this.handlers;
    }

    public LaserNetHandler getDefaultHandler() {
        return this.defaultHandler;
    }

    public boolean isActive() {
        return this.active;
    }

    private static class DefaultLaserContainer
    implements ILaserContainer {
        private DefaultLaserContainer() {
        }

        @Override
        public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
            return 0L;
        }

        @Override
        public boolean inputsEnergy(Direction side) {
            return false;
        }

        @Override
        public long changeEnergy(long differenceAmount) {
            return 0L;
        }

        @Override
        public long getEnergyStored() {
            return 0L;
        }

        @Override
        public long getEnergyCapacity() {
            return 0L;
        }

        @Override
        public long getInputAmperage() {
            return 0L;
        }

        @Override
        public long getInputVoltage() {
            return 0L;
        }
    }
}

