/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.common.block.ItemPipeBlock;
import com.gregtechceu.gtceu.common.blockentity.forge.ItemPipeBlockEntityImpl;
import com.gregtechceu.gtceu.common.pipelike.item.ItemNetHandler;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeData;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeNet;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeType;
import com.gregtechceu.gtceu.utils.FacingPos;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ItemPipeBlockEntity
extends PipeBlockEntity<ItemPipeType, ItemPipeData> {
    protected WeakReference<ItemPipeNet> currentItemPipeNet = new WeakReference<Object>(null);
    protected final EnumMap<Direction, ItemNetHandler> handlers = new EnumMap(Direction.class);
    private final Map<FacingPos, Integer> transferred = new HashMap<FacingPos, Integer>();
    protected ItemNetHandler defaultHandler;

    public ItemPipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static ItemPipeBlockEntity create(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        void var2_2;
        void var1_1;
        return ItemPipeBlockEntityImpl.create(type, (BlockPos)var1_1, (BlockState)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void onBlockEntityRegister(BlockEntityType<ItemPipeBlockEntity> cableBlockEntityBlockEntityType) {
        ItemPipeBlockEntityImpl.onBlockEntityRegister(cableBlockEntityBlockEntityType);
    }

    public void initHandlers() {
        ItemPipeNet net = this.getItemPipeNet();
        if (net == null) {
            return;
        }
        for (Direction facing : Direction.values()) {
            this.handlers.put(facing, new ItemNetHandler(net, this, facing));
        }
        this.defaultHandler = new ItemNetHandler(net, this, null);
    }

    public void checkNetwork() {
        if (this.defaultHandler != null) {
            ItemPipeNet current = this.getItemPipeNet();
            if (this.defaultHandler.getNet() != current) {
                this.defaultHandler.updateNetwork(current);
                for (ItemNetHandler handler : this.handlers.values()) {
                    handler.updateNetwork(current);
                }
            }
        }
    }

    @Override
    public boolean canAttachTo(Direction side) {
        if (this.f_58857_ == null) {
            return false;
        }
        if (this.f_58857_.m_7702_(this.m_58899_().m_121945_(side)) instanceof ItemPipeBlockEntity) {
            return false;
        }
        return ItemTransferHelper.getItemTransfer((Level)this.f_58857_, (BlockPos)this.m_58899_().m_121945_(side), (Direction)side.m_122424_()) != null;
    }

    @Nullable
    public ItemPipeNet getItemPipeNet() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level = this.m_58900_().m_60734_();
            if (level instanceof ItemPipeBlock) {
                ItemPipeBlock itemPipeBlock = (ItemPipeBlock)level;
                ItemPipeNet currentItemPipeNet = (ItemPipeNet)((Object)this.currentItemPipeNet.get());
                if (currentItemPipeNet != null && currentItemPipeNet.isValid() && currentItemPipeNet.containsNode(this.m_58899_())) {
                    return currentItemPipeNet;
                }
                currentItemPipeNet = (ItemPipeNet)itemPipeBlock.getWorldPipeNet(serverLevel).getNetFromPos(this.m_58899_());
                if (currentItemPipeNet != null) {
                    this.currentItemPipeNet = new WeakReference<ItemPipeNet>(currentItemPipeNet);
                }
            }
        }
        return (ItemPipeNet)((Object)this.currentItemPipeNet.get());
    }

    public void resetTransferred() {
        this.transferred.clear();
    }

    public IItemTransfer getHandler(@Nullable Direction side, boolean useCoverCapability) {
        ItemNetHandler handler = this.getHandlers().getOrDefault(side, this.getDefaultHandler());
        if (!useCoverCapability || side == null) {
            return handler;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        return cover != null ? cover.getItemTransferCap(side, handler) : handler;
    }

    public EnumMap<Direction, ItemNetHandler> getHandlers() {
        return this.handlers;
    }

    public Map<FacingPos, Integer> getTransferred() {
        return this.transferred;
    }

    public ItemNetHandler getDefaultHandler() {
        return this.defaultHandler;
    }
}

