/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.common.block.FluidPipeBlock;
import com.gregtechceu.gtceu.common.blockentity.forge.FluidPipeBlockEntityImpl;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeData;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeNet;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.FluidPipeType;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.ref.WeakReference;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidPipeBlockEntity
extends PipeBlockEntity<FluidPipeType, FluidPipeData> {
    protected WeakReference<FluidPipeNet> currentFluidPipeNet = new WeakReference<Object>(null);

    public FluidPipeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static FluidPipeBlockEntity create(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        void var2_2;
        void var1_1;
        return FluidPipeBlockEntityImpl.create(type, (BlockPos)var1_1, (BlockState)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void onBlockEntityRegister(BlockEntityType<FluidPipeBlockEntity> cableBlockEntityBlockEntityType) {
        FluidPipeBlockEntityImpl.onBlockEntityRegister(cableBlockEntityBlockEntityType);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static IFluidTransfer getNetHandler(FluidPipeBlockEntity pipe, @Nullable Direction side) {
        void var1_1;
        return FluidPipeBlockEntityImpl.getNetHandler(pipe, (Direction)var1_1);
    }

    @Override
    public boolean canAttachTo(Direction side) {
        if (this.f_58857_ != null) {
            if (this.f_58857_.m_7702_(this.m_58899_().m_121945_(side)) instanceof FluidPipeBlockEntity) {
                return false;
            }
            return FluidTransferHelper.getFluidTransfer((Level)this.f_58857_, (BlockPos)this.m_58899_().m_121945_(side), (Direction)side.m_122424_()) != null;
        }
        return false;
    }

    @Nullable
    public FluidPipeNet getFluidPipeNet() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level = this.m_58900_().m_60734_();
            if (level instanceof FluidPipeBlock) {
                FluidPipeBlock fluidPipeBlock = (FluidPipeBlock)level;
                FluidPipeNet currentFluidPipeNet = (FluidPipeNet)((Object)this.currentFluidPipeNet.get());
                if (currentFluidPipeNet != null && currentFluidPipeNet.isValid() && currentFluidPipeNet.containsNode(this.m_58899_())) {
                    return currentFluidPipeNet;
                }
                currentFluidPipeNet = (FluidPipeNet)fluidPipeBlock.getWorldPipeNet(serverLevel).getNetFromPos(this.m_58899_());
                if (currentFluidPipeNet != null) {
                    this.currentFluidPipeNet = new WeakReference<FluidPipeNet>(currentFluidPipeNet);
                }
            }
        }
        return (FluidPipeNet)((Object)this.currentFluidPipeNet.get());
    }

    public IFluidTransfer getHandler(@Nullable Direction side, boolean useCoverCapability) {
        IFluidTransfer handler = FluidPipeBlockEntity.getNetHandler(this, side);
        if (!useCoverCapability || side == null) {
            return handler;
        }
        CoverBehavior cover = this.getCoverContainer().getCoverAtSide(side);
        return cover != null ? cover.getFluidTransferCap(side, handler) : handler;
    }
}

