/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.blockentity;

import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.common.block.CableBlock;
import com.gregtechceu.gtceu.common.blockentity.forge.CableBlockEntityImpl;
import com.gregtechceu.gtceu.common.pipelike.cable.CableData;
import com.gregtechceu.gtceu.common.pipelike.cable.EnergyNet;
import com.gregtechceu.gtceu.common.pipelike.cable.EnergyNetHandler;
import com.gregtechceu.gtceu.common.pipelike.cable.Insulation;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.lang.ref.WeakReference;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CableBlockEntity
extends PipeBlockEntity<Insulation, CableData> {
    protected WeakReference<EnergyNet> currentEnergyNet = new WeakReference<Object>(null);

    public CableBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static CableBlockEntity create(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        void var2_2;
        void var1_1;
        return CableBlockEntityImpl.create(type, (BlockPos)var1_1, (BlockState)var2_2);
    }

    @Override
    public boolean canAttachTo(Direction side) {
        if (this.f_58857_ != null) {
            if (this.f_58857_.m_7702_(this.m_58899_().m_121945_(side)) instanceof CableBlockEntity) {
                return false;
            }
            return GTCapabilityHelper.getEnergyContainer(this.f_58857_, this.m_58899_().m_121945_(side), side.m_122424_()) != null;
        }
        return false;
    }

    @Nullable
    private EnergyNet getEnergyNet() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level = this.m_58900_().m_60734_();
            if (level instanceof CableBlock) {
                CableBlock cableBlock = (CableBlock)level;
                EnergyNet currentEnergyNet = (EnergyNet)((Object)this.currentEnergyNet.get());
                if (currentEnergyNet != null && currentEnergyNet.isValid() && currentEnergyNet.containsNode(this.m_58899_())) {
                    return currentEnergyNet;
                }
                currentEnergyNet = (EnergyNet)cableBlock.getWorldPipeNet(serverLevel).getNetFromPos(this.m_58899_());
                if (currentEnergyNet != null) {
                    this.currentEnergyNet = new WeakReference<EnergyNet>(currentEnergyNet);
                }
            }
        }
        return (EnergyNet)((Object)this.currentEnergyNet.get());
    }

    @Nullable
    public IEnergyContainer getEnergyContainer(@Nullable Direction side) {
        if (side != null && this.isBlocked(side)) {
            return null;
        }
        if (this.isRemote()) {
            return IEnergyContainer.DEFAULT;
        }
        EnergyNet ENet = this.getEnergyNet();
        if (ENet != null) {
            return new EnergyNetHandler(ENet, this);
        }
        return IEnergyContainer.DEFAULT;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void onBlockEntityRegister(BlockEntityType<CableBlockEntity> cableBlockEntityBlockEntityType) {
        CableBlockEntityImpl.onBlockEntityRegister(cableBlockEntityBlockEntityType);
    }

    @Override
    public ResourceTexture getPipeTexture(boolean isBlock) {
        return isBlock ? GuiTextures.TOOL_WIRE_CONNECT : GuiTextures.TOOL_WIRE_BLOCK;
    }

    @Override
    protected boolean canToolTunePipe(GTToolType toolType) {
        return toolType == GTToolType.WIRE_CUTTER;
    }
}

