/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.client.renderer.block.PipeBlockRenderer;
import com.gregtechceu.gtceu.common.data.GTBlockEntities;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeNet;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeProperties;
import com.gregtechceu.gtceu.common.pipelike.laser.LaserPipeType;
import com.gregtechceu.gtceu.common.pipelike.laser.LevelLaserPipeNet;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class LaserPipeBlock
extends PipeBlock<LaserPipeType, LaserPipeNet.LaserData, LevelLaserPipeNet> {
    public final PipeBlockRenderer renderer;
    public final PipeModel model = new PipeModel(LaserPipeType.NORMAL.getThickness(), () -> GTCEu.id("block/pipe/pipe_laser_side"), () -> GTCEu.id("block/pipe/pipe_laser_in"), null, null);

    public LaserPipeBlock(BlockBehaviour.Properties properties, LaserPipeType type) {
        super(properties, type);
        this.renderer = new PipeBlockRenderer(this.model);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static BlockColor tintedColor() {
        return (blockState, level, blockPos, index) -> {
            PipeBlockEntity pipe;
            BlockEntity patt2270$temp;
            if (blockPos != null && level != null && (patt2270$temp = level.m_7702_(blockPos)) instanceof PipeBlockEntity && (pipe = (PipeBlockEntity)patt2270$temp).isPainted()) {
                return pipe.getRealColor();
            }
            return -1;
        };
    }

    @Override
    public LevelLaserPipeNet getWorldPipeNet(ServerLevel world) {
        return LevelLaserPipeNet.getOrCreate(world);
    }

    @Override
    public BlockEntityType<? extends PipeBlockEntity<LaserPipeType, LaserPipeNet.LaserData>> getBlockEntityType() {
        return (BlockEntityType)GTBlockEntities.LASER_PIPE.get();
    }

    @Override
    public LaserPipeNet.LaserData createRawData(BlockState pState, @Nullable ItemStack pStack) {
        return new LaserPipeNet.LaserData(BlockPos.f_121853_, Direction.NORTH, 0, LaserPipeProperties.INSTANCE, 0);
    }

    @Override
    public LaserPipeNet.LaserData getFallbackType() {
        return new LaserPipeNet.LaserData(BlockPos.f_121853_, Direction.NORTH, 0, LaserPipeProperties.INSTANCE, 0);
    }

    @Override
    @Nullable
    public PipeBlockRenderer getRenderer(BlockState state) {
        return this.renderer;
    }

    @Override
    protected PipeModel getPipeModel() {
        return this.model;
    }
}

