/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.common.block;

import com.gregtechceu.gtceu.api.block.MaterialPipeBlock;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ItemPipeProperties;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.client.model.PipeModel;
import com.gregtechceu.gtceu.common.data.GTBlockEntities;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeData;
import com.gregtechceu.gtceu.common.pipelike.item.ItemPipeType;
import com.gregtechceu.gtceu.common.pipelike.item.LevelItemPipeNet;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.jetbrains.annotations.Nullable;

public class ItemPipeBlock
extends MaterialPipeBlock<ItemPipeType, ItemPipeData, LevelItemPipeNet> {
    public ItemPipeBlock(BlockBehaviour.Properties properties, ItemPipeType itemPipeType, Material material) {
        super(properties, itemPipeType, material);
    }

    @Override
    protected ItemPipeData createMaterialData() {
        return new ItemPipeData(this.material.getProperty(PropertyKey.ITEM_PIPE), 0);
    }

    @Override
    protected PipeModel createPipeModel() {
        return ((ItemPipeType)this.pipeType).createPipeModel(this.material);
    }

    @Override
    public LevelItemPipeNet getWorldPipeNet(ServerLevel level) {
        return LevelItemPipeNet.getOrCreate(level);
    }

    @Override
    public BlockEntityType<? extends PipeBlockEntity<ItemPipeType, ItemPipeData>> getBlockEntityType() {
        return (BlockEntityType)GTBlockEntities.ITEM_PIPE.get();
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        super.m_5871_(stack, level, tooltip, flag);
        ItemPipeProperties properties = ((ItemPipeType)this.pipeType).modifyProperties((ItemPipeData)this.createRawData(this.m_49966_(), stack)).properties();
        if (properties.getTransferRate() % 1.0f != 0.0f) {
            tooltip.add((Component)Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate", (Object[])new Object[]{(int)((double)(properties.getTransferRate() * 64.0f) + 0.5)}));
        } else {
            tooltip.add((Component)Component.m_237110_((String)"gtceu.universal.tooltip.item_transfer_rate_stacks", (Object[])new Object[]{(int)properties.getTransferRate()}));
        }
        tooltip.add((Component)Component.m_237110_((String)"gtceu.item_pipe.priority", (Object[])new Object[]{properties.getPriority()}));
    }
}

