/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.machine;

import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.client.model.SpriteOverrider;
import com.gregtechceu.gtceu.client.renderer.machine.IControllerRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.ISplitShaftRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.MachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.TieredHullMachineRenderer;
import com.gregtechceu.gtceu.client.renderer.machine.WorkableCasingMachineRenderer;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class SplitShaftTieredHullMachineRenderer
extends TieredHullMachineRenderer
implements ISplitShaftRenderer {
    public SplitShaftTieredHullMachineRenderer(int tier, ResourceLocation modelLocation) {
        super(tier, modelLocation);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean renderReplacedPartMachine(List<BakedQuad> quads, IMultiPart part, Direction frontFacing, @Nullable Direction side, RandomSource rand, Direction modelFacing, ModelState modelState) {
        List<IMultiController> controllers = part.getControllers();
        for (IMultiController controller : controllers) {
            BlockState state = controller.self().getBlockState();
            Block block = state.m_60734_();
            if (!(block instanceof MetaMachineBlock)) continue;
            MetaMachineBlock block2 = (MetaMachineBlock)block;
            IRenderer renderer = block2.definition.getRenderer();
            if (renderer instanceof WorkableCasingMachineRenderer) {
                WorkableCasingMachineRenderer workableCasingMachineRenderer = (WorkableCasingMachineRenderer)renderer;
                ResourceLocation baseTexture = workableCasingMachineRenderer.baseCasing;
                BakedModel bakeModel = ModelFactory.getUnBakedModel((ResourceLocation)this.modelLocation).m_7611_(ModelFactory.getModeBaker(), (Function)new SpriteOverrider(Map.of("bottom", baseTexture, "top", baseTexture, "side", baseTexture)), ModelFactory.getRotation((Direction)frontFacing), this.modelLocation);
                if (bakeModel == null) continue;
                quads.addAll(bakeModel.m_213637_(part.self().getDefinition().defaultBlockState(), side, rand));
                return true;
            }
            if (renderer instanceof IControllerRenderer) {
                IControllerRenderer controllerRenderer = (IControllerRenderer)renderer;
                controllerRenderer.renderPartModel(quads, controller, part, frontFacing, side, rand, modelFacing, modelState);
                return true;
            }
            if (!(renderer instanceof MachineRenderer)) continue;
            MachineRenderer machineRenderer = (MachineRenderer)renderer;
            machineRenderer.renderBaseModel(quads, block2.definition, controller.self(), frontFacing, side, rand);
            return true;
        }
        return false;
    }
}

