/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer.cover;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.cover.CoverBehavior;
import com.gregtechceu.gtceu.client.model.ModelUtil;
import com.gregtechceu.gtceu.client.renderer.cover.ICoverRenderer;
import com.gregtechceu.gtceu.common.cover.FacadeCover;
import com.gregtechceu.gtceu.common.item.FacadeItemBehaviour;
import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.utils.FacadeBlockAndTintGetter;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4d;
import org.joml.Quaternionf;

public class FacadeCoverRenderer
implements ICoverRenderer {
    public static final FacadeCoverRenderer INSTANCE = new FacadeCoverRenderer();

    protected FacadeCoverRenderer() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useBlockLight(ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        Minecraft mc = Minecraft.m_91087_();
        ItemStack renderItem = FacadeItemBehaviour.getFacadeStack(stack);
        BlockState blockState = null;
        Item item = renderItem.m_41720_();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            blockState = blockItem.m_40614_().m_49966_();
        }
        if (blockState != null && mc.f_91073_ != null && !(model = mc.m_91289_().m_110910_(blockState)).m_7521_()) {
            matrixStack.m_85836_();
            ModelFactory.MODEL_TRANSFORM_BLOCK.m_269404_(transformType).m_111763_(leftHand, matrixStack);
            matrixStack.m_85837_(0.0, -0.1, -0.5);
            if (transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                matrixStack.m_85837_(0.5, 0.5, 0.5);
                matrixStack.m_252781_(new Quaternionf(new AxisAngle4d().set(90.0, 0.0, 1.0, 0.0)));
                matrixStack.m_85837_(-0.5, -0.5, -0.5);
            }
            PoseStack.Pose pose = matrixStack.m_85850_();
            FacadeBlockAndTintGetter level = new FacadeBlockAndTintGetter((BlockAndTintGetter)mc.f_91073_, BlockPos.f_121853_, blockState, null);
            LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>(ModelUtil.getBakedModelQuads(model, (BlockAndTintGetter)level, BlockPos.f_121853_, blockState, Direction.NORTH, mc.f_91073_.f_46441_));
            AABB cube = new AABB(0.01, 0.01, 0.01, 0.99, 0.99, 0.0625);
            for (Direction side : Direction.values()) {
                if (side == Direction.NORTH) continue;
                quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)GTCEu.id("block/cable/wire"))).cube(cube).cubeUV().tintIndex(-1).bake());
                quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)ModelFactory.getBlockSprite((ResourceLocation)GTCEu.id("block/cable/wire"))).cube(cube).cubeUV().tintIndex(-1).bake());
            }
            for (BakedQuad bakedQuad : quads) {
                buffer.m_6299_(RenderType.m_110463_()).m_85987_(pose, bakedQuad, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay);
            }
            matrixStack.m_85849_();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderCover(List<BakedQuad> quads, Direction side, RandomSource rand, @NotNull CoverBehavior coverBehavior, Direction modelFacing, ModelState modelState) {
        FacadeCover facadeCover;
        BlockState state;
        if (coverBehavior instanceof FacadeCover && (state = (facadeCover = (FacadeCover)coverBehavior).getFacadeState()).m_60799_() == RenderShape.MODEL) {
            BlockRenderDispatcher brd = Minecraft.m_91087_().m_91289_();
            BakedModel model = brd.m_110910_(state);
            FacadeBlockAndTintGetter level = new FacadeBlockAndTintGetter((BlockAndTintGetter)coverBehavior.coverHolder.getLevel(), coverBehavior.coverHolder.getPos(), state, null);
            if (side == coverBehavior.attachedSide) {
                quads.addAll(ModelUtil.getBakedModelQuads(model, (BlockAndTintGetter)level, BlockPos.f_121853_, state, side, rand));
            } else if (side == null && coverBehavior.coverHolder.shouldRenderBackSide()) {
                Vec3i normal = coverBehavior.attachedSide.m_122436_();
                AABB cube = new AABB(normal.m_123341_() == 0 ? 0.0 : (normal.m_123341_() > 0 ? 1.0 : 0.0), normal.m_123342_() == 0 ? 0.0 : (normal.m_123342_() > 0 ? 1.0 : 0.0), normal.m_123343_() == 0 ? 0.0 : (normal.m_123343_() > 0 ? 1.0 : 0.0), normal.m_123341_() == 0 ? 1.0 : (normal.m_123341_() > 0 ? 1.0 : 0.0), normal.m_123342_() == 0 ? 1.0 : (normal.m_123342_() > 0 ? 1.0 : 0.0), normal.m_123343_() == 0 ? 1.0 : (normal.m_123343_() > 0 ? 1.0 : 0.0));
                for (BakedQuad quad : ModelUtil.getBakedModelQuads(model, (BlockAndTintGetter)level, BlockPos.f_121853_, state, coverBehavior.attachedSide, rand)) {
                    quads.add(FaceQuad.builder((Direction)coverBehavior.attachedSide.m_122424_(), (TextureAtlasSprite)quad.m_173410_()).cube(cube).shade(quad.m_111307_()).tintIndex(quad.m_111305_()).bake());
                }
            }
        }
    }
}

