/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model;

import com.lowdragmc.lowdraglib.client.bakedpipeline.FaceQuad;
import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PipeModel {
    public static final int ITEM_CONNECTIONS = 12;
    public final float thickness;
    public final AABB coreCube;
    public final Map<Direction, AABB> sideCubes;
    public Supplier<ResourceLocation> sideTexture;
    public Supplier<ResourceLocation> endTexture;
    @Nullable
    public @Nullable Supplier<@Nullable ResourceLocation> secondarySideTexture;
    @Nullable
    public @Nullable Supplier<@Nullable ResourceLocation> secondaryEndTexture;
    public ResourceLocation sideOverlayTexture;
    public ResourceLocation endOverlayTexture;
    @OnlyIn(value=Dist.CLIENT)
    TextureAtlasSprite sideSprite;
    @OnlyIn(value=Dist.CLIENT)
    TextureAtlasSprite endSprite;
    @OnlyIn(value=Dist.CLIENT)
    TextureAtlasSprite secondarySideSprite;
    @OnlyIn(value=Dist.CLIENT)
    TextureAtlasSprite secondaryEndSprite;
    @OnlyIn(value=Dist.CLIENT)
    TextureAtlasSprite sideOverlaySprite;
    @OnlyIn(value=Dist.CLIENT)
    TextureAtlasSprite endOverlaySprite;
    private final Map<Optional<Direction>, List<BakedQuad>> itemModelCache = new ConcurrentHashMap<Optional<Direction>, List<BakedQuad>>();

    public PipeModel(float thickness, Supplier<ResourceLocation> sideTexture, Supplier<ResourceLocation> endTexture, @Nullable @Nullable Supplier<@Nullable ResourceLocation> secondarySideTexture, @Nullable @Nullable Supplier<@Nullable ResourceLocation> secondaryEndTexture) {
        this.sideTexture = sideTexture;
        this.endTexture = endTexture;
        this.secondarySideTexture = secondarySideTexture;
        this.secondaryEndTexture = secondaryEndTexture;
        this.thickness = thickness;
        double min = (1.0 - (double)thickness) / 2.0;
        double max = min + (double)thickness;
        this.coreCube = new AABB(min, min, min, max, max, max);
        this.sideCubes = new EnumMap<Direction, AABB>(Direction.class);
        Direction[] directionArray = Direction.values();
        int n = directionArray.length;
        for (int i = 0; i < n; ++i) {
            Direction side;
            Vec3i normal = (side = directionArray[i]).m_122436_();
            this.sideCubes.put(side, new AABB(normal.m_123341_() == 0 ? min : (normal.m_123341_() > 0 ? max : 0.0), normal.m_123342_() == 0 ? min : (normal.m_123342_() > 0 ? max : 0.0), normal.m_123343_() == 0 ? min : (normal.m_123343_() > 0 ? max : 0.0), normal.m_123341_() == 0 ? max : (normal.m_123341_() > 0 ? 1.0 : min), normal.m_123342_() == 0 ? max : (normal.m_123342_() > 0 ? 1.0 : min), normal.m_123343_() == 0 ? max : (normal.m_123343_() > 0 ? 1.0 : min)));
        }
    }

    public VoxelShape getShapes(int connections) {
        ArrayList<VoxelShape> shapes = new ArrayList<VoxelShape>(7);
        shapes.add(Shapes.m_83064_((AABB)this.coreCube));
        for (Direction side : Direction.values()) {
            if (!this.isConnected(connections, side)) continue;
            shapes.add(Shapes.m_83064_((AABB)this.sideCubes.get(side)));
        }
        return shapes.stream().reduce(Shapes.m_83040_(), Shapes::m_83110_);
    }

    public boolean isConnected(int connections, Direction side) {
        return (connections >> side.ordinal() & 1) == 1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<BakedQuad> bakeQuads(@Nullable Direction side, int connections) {
        if (this.sideSprite == null) {
            this.sideSprite = ModelFactory.getBlockSprite((ResourceLocation)this.sideTexture.get());
        }
        if (this.endSprite == null) {
            this.endSprite = ModelFactory.getBlockSprite((ResourceLocation)this.endTexture.get());
        }
        if (this.secondarySideTexture != null && this.secondarySideTexture.get() != null && this.secondarySideSprite == null) {
            this.secondarySideSprite = ModelFactory.getBlockSprite((ResourceLocation)this.secondarySideTexture.get());
        }
        if (this.secondaryEndTexture != null && this.secondaryEndTexture.get() != null && this.secondaryEndSprite == null) {
            this.secondaryEndSprite = ModelFactory.getBlockSprite((ResourceLocation)this.secondaryEndTexture.get());
        }
        if (this.sideOverlayTexture != null && this.sideOverlaySprite == null) {
            this.sideOverlaySprite = ModelFactory.getBlockSprite((ResourceLocation)this.sideOverlayTexture);
        }
        if (this.endOverlayTexture != null && this.endOverlaySprite == null) {
            this.endOverlaySprite = ModelFactory.getBlockSprite((ResourceLocation)this.endOverlayTexture);
        }
        if (side != null) {
            if (this.thickness == 1.0f) {
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)this.sideSprite).cube(this.coreCube).cubeUV().tintIndex(0).bake());
                if (this.secondarySideSprite != null) {
                    quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)this.secondarySideSprite).cube(this.coreCube).cubeUV().tintIndex(0).bake());
                }
                return quads;
            }
            if (this.isConnected(connections, side)) {
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)this.endSprite).cube(this.sideCubes.get(side).m_82400_(-0.001)).cubeUV().tintIndex(1).bake());
                if (this.secondaryEndSprite != null) {
                    quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)this.secondaryEndSprite).cube(this.sideCubes.get(side)).cubeUV().tintIndex(1).bake());
                }
                if (this.endOverlaySprite != null) {
                    quads.add(FaceQuad.builder((Direction)side, (TextureAtlasSprite)this.endOverlaySprite).cube(this.sideCubes.get(side)).cubeUV().tintIndex(0).bake());
                }
                if (this.sideOverlaySprite != null) {
                    for (Direction face : Direction.values()) {
                        if (face == side || face == side.m_122424_()) continue;
                        quads.add(FaceQuad.builder((Direction)face, (TextureAtlasSprite)this.sideOverlaySprite).cube(this.sideCubes.get(side)).cubeUV().tintIndex(2).bake());
                    }
                }
                return quads;
            }
            return Collections.emptyList();
        }
        LinkedList<BakedQuad> quads = new LinkedList<BakedQuad>();
        if (this.thickness < 1.0f) {
            for (Direction face : Direction.values()) {
                if (!this.isConnected(connections, face)) {
                    quads.add(FaceQuad.builder((Direction)face, (TextureAtlasSprite)this.sideSprite).cube(this.coreCube).cubeUV().tintIndex(0).bake());
                    if (this.secondarySideSprite != null) {
                        quads.add(FaceQuad.builder((Direction)face, (TextureAtlasSprite)this.secondarySideSprite).cube(this.coreCube).cubeUV().tintIndex(0).bake());
                    }
                }
                for (Direction facing : Direction.values()) {
                    if (facing.m_122434_() == face.m_122434_() || !this.isConnected(connections, facing)) continue;
                    quads.add(FaceQuad.builder((Direction)face, (TextureAtlasSprite)this.sideSprite).cube(this.sideCubes.get(facing)).cubeUV().tintIndex(0).bake());
                    if (this.secondarySideSprite != null) {
                        quads.add(FaceQuad.builder((Direction)face, (TextureAtlasSprite)this.secondarySideSprite).cube(this.sideCubes.get(facing)).cubeUV().tintIndex(0).bake());
                    }
                    if (this.sideOverlaySprite == null) continue;
                    quads.add(FaceQuad.builder((Direction)face, (TextureAtlasSprite)this.sideOverlaySprite).cube(this.sideCubes.get(facing).m_82400_(0.001)).cubeUV().tintIndex(2).bake());
                }
            }
        }
        return quads;
    }

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    public TextureAtlasSprite getParticleTexture() {
        if (this.sideSprite == null) {
            this.sideSprite = ModelFactory.getBlockSprite((ResourceLocation)this.sideTexture.get());
        }
        return this.sideSprite;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack matrixStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        IItemRendererProvider.disabled.set(true);
        Minecraft.m_91087_().m_91291_().m_115143_(stack, transformType, leftHand, matrixStack, buffer, combinedLight, combinedOverlay, (state, direction, random) -> this.itemModelCache.computeIfAbsent(Optional.ofNullable(direction), direction1 -> this.bakeQuads(direction1.orElse(null), 12)));
        IItemRendererProvider.disabled.set(false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerTextureAtlas(Consumer<ResourceLocation> register) {
        this.itemModelCache.clear();
        register.accept(this.sideTexture.get());
        register.accept(this.endTexture.get());
        if (this.sideOverlayTexture != null) {
            register.accept(this.sideOverlayTexture);
        }
        if (this.endOverlayTexture != null) {
            register.accept(this.endOverlayTexture);
        }
        this.sideSprite = null;
        this.endSprite = null;
        this.endOverlaySprite = null;
    }

    public void setSideOverlayTexture(ResourceLocation sideOverlayTexture) {
        this.sideOverlayTexture = sideOverlayTexture;
    }

    public void setEndOverlayTexture(ResourceLocation endOverlayTexture) {
        this.endOverlayTexture = endOverlayTexture;
    }
}

