/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.UnificationEntry;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TooltipsHandler {
    private static final String ITEM_PREFIX = "item.gtceu";
    private static final String BLOCK_PREFIX = "block.gtceu";

    public static void appendTooltips(ItemStack stack, TooltipFlag flag, List<Component> tooltips) {
        String translationKey;
        UnificationEntry unificationEntry;
        IElectricItem energyItem = GTCapabilityHelper.getElectricItem(stack);
        if (energyItem != null) {
            tooltips.add(1, (Component)Component.m_237110_((String)"metaitem.generic.electric_item.stored", (Object[])new Object[]{energyItem.getCharge(), energyItem.getMaxCharge(), Component.m_237113_((String)String.format("%.2f%%", Float.valueOf((float)energyItem.getCharge() * 100.0f / (float)energyItem.getMaxCharge()))).m_130940_(ChatFormatting.GREEN)}));
        }
        if ((unificationEntry = ChemicalHelper.getUnificationEntry((ItemLike)stack.m_41720_())) != null && unificationEntry.material != null && unificationEntry.material.getChemicalFormula() != null && !unificationEntry.material.getChemicalFormula().isEmpty()) {
            tooltips.add(1, (Component)Component.m_237113_((String)unificationEntry.material.getChemicalFormula()).m_130940_(ChatFormatting.YELLOW));
        }
        if ((translationKey = stack.m_41778_()).startsWith(ITEM_PREFIX) || translationKey.startsWith(BLOCK_PREFIX)) {
            String tooltipKey = translationKey + ".tooltip";
            if (I18n.m_118936_((String)tooltipKey)) {
                tooltips.add(1, (Component)Component.m_237115_((String)tooltipKey));
            } else {
                List<MutableComponent> multiLang = LangHandler.getMultiLang(tooltipKey);
                if (multiLang != null && multiLang.size() > 0) {
                    tooltips.addAll(1, multiLang);
                }
            }
        }
    }

    public static void appendFluidTooltips(Fluid fluid, List<Component> tooltips, TooltipFlag flag) {
        Material material = ChemicalHelper.getMaterial(fluid);
        if (material != null && material.getChemicalFormula() != null && !material.getChemicalFormula().isEmpty()) {
            tooltips.add(1, (Component)Component.m_237113_((String)material.getChemicalFormula()).m_130940_(ChatFormatting.YELLOW));
        }
    }
}

