/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.syncdata;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.syncdata.IEnhancedManaged;
import com.gregtechceu.gtceu.api.syncdata.RequireRerender;
import com.gregtechceu.gtceu.api.syncdata.UpdateListener;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.syncdata.IManaged;
import com.lowdragmc.lowdraglib.syncdata.field.FieldManagedStorage;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BiFunction;
import net.minecraft.Util;

public class EnhancedFieldManagedStorage
extends FieldManagedStorage {
    private final IEnhancedManaged enhancedManaged;
    private boolean initialized = false;
    static final BiFunction<Field, Class<?>, Method> METHOD_CACHES = Util.m_143821_((rawField, clazz) -> {
        String methodName = rawField.getAnnotation(UpdateListener.class).methodName();
        Method method = null;
        while (clazz != null && method == null) {
            try {
                method = clazz.getDeclaredMethod(methodName, rawField.getType(), rawField.getType());
                method.setAccessible(true);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            clazz = clazz.getSuperclass();
        }
        if (method == null) {
            GTCEu.LOGGER.error("couldn't find the listener method {} for synced field {}", (Object)methodName, (Object)rawField.getName());
        }
        return method;
    });

    public EnhancedFieldManagedStorage(IEnhancedManaged enhancedManaged) {
        super((IManaged)enhancedManaged);
        this.enhancedManaged = enhancedManaged;
    }

    public void init() {
        super.init();
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (LDLib.isClient()) {
            this.initEnhancedFeature();
        }
    }

    public void initEnhancedFeature() {
        for (IRef syncField : this.getSyncFields()) {
            Method method;
            Field rawField = syncField.getKey().getRawField();
            if (rawField.isAnnotationPresent(RequireRerender.class)) {
                this.addSyncUpdateListener(syncField.getKey(), this.enhancedManaged::scheduleRender);
            }
            if (!rawField.isAnnotationPresent(UpdateListener.class) || (method = METHOD_CACHES.apply(rawField, this.enhancedManaged.getClass())) == null) continue;
            this.addSyncUpdateListener(syncField.getKey(), (name, newValue, oldValue) -> {
                try {
                    method.invoke((Object)this.enhancedManaged, newValue, oldValue);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

