/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate;

import com.google.common.base.Suppliers;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.registry.registrate.CompassNode;
import com.gregtechceu.gtceu.api.registry.registrate.CompassSection;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.common.data.GTCompassSections;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.tterrag.registrate.Registrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MultiblockMachineBuilder
extends MachineBuilder<MultiblockMachineDefinition> {
    private Function<MultiblockMachineDefinition, BlockPattern> pattern;
    private final List<Function<MultiblockMachineDefinition, List<MultiblockShapeInfo>>> shapeInfos = new ArrayList<Function<MultiblockMachineDefinition, List<MultiblockShapeInfo>>>();
    private final List<Supplier<ItemStack[]>> recoveryItems = new ArrayList<Supplier<ItemStack[]>>();
    private Comparator<IMultiPart> partSorter = (a, b) -> 0;
    private TriFunction<IMultiController, IMultiPart, Direction, BlockState> partAppearance;
    private BiConsumer<IMultiController, List<Component>> additionalDisplay = (m, l) -> {};

    protected MultiblockMachineBuilder(Registrate registrate, String name, Function<IMachineBlockEntity, ? extends MultiblockControllerMachine> metaMachine, BiFunction<BlockBehaviour.Properties, MultiblockMachineDefinition, IMachineBlock> blockFactory, BiFunction<IMachineBlock, Item.Properties, MetaMachineItem> itemFactory, TriFunction<BlockEntityType<?>, BlockPos, BlockState, IMachineBlockEntity> blockEntityFactory) {
        super(registrate, name, MultiblockMachineDefinition::createDefinition, metaMachine::apply, blockFactory, itemFactory, blockEntityFactory);
        this.compassSections(GTCompassSections.MULTIBLOCK);
    }

    public static MultiblockMachineBuilder createMulti(Registrate registrate, String name, Function<IMachineBlockEntity, ? extends MultiblockControllerMachine> metaMachine, BiFunction<BlockBehaviour.Properties, MultiblockMachineDefinition, IMachineBlock> blockFactory, BiFunction<IMachineBlock, Item.Properties, MetaMachineItem> itemFactory, TriFunction<BlockEntityType<?>, BlockPos, BlockState, IMachineBlockEntity> blockEntityFactory) {
        return new MultiblockMachineBuilder(registrate, name, metaMachine, blockFactory, itemFactory, blockEntityFactory);
    }

    public MultiblockMachineBuilder shapeInfo(Function<MultiblockMachineDefinition, MultiblockShapeInfo> shape) {
        this.shapeInfos.add(d -> List.of((MultiblockShapeInfo)shape.apply((MultiblockMachineDefinition)d)));
        return this;
    }

    public MultiblockMachineBuilder shapeInfos(Function<MultiblockMachineDefinition, List<MultiblockShapeInfo>> shapes) {
        this.shapeInfos.add(shapes);
        return this;
    }

    public MultiblockMachineBuilder recoveryItems(Supplier<ItemLike[]> items) {
        this.recoveryItems.add(() -> (ItemStack[])Arrays.stream((ItemLike[])items.get()).map(ItemLike::m_5456_).map(Item::m_7968_).toArray(ItemStack[]::new));
        return this;
    }

    public MultiblockMachineBuilder recoveryStacks(Supplier<ItemStack[]> stacks) {
        this.recoveryItems.add(stacks);
        return this;
    }

    public MultiblockMachineBuilder renderer(@Nullable Supplier<IRenderer> renderer) {
        return (MultiblockMachineBuilder)super.renderer(renderer);
    }

    public MultiblockMachineBuilder shape(VoxelShape shape) {
        return (MultiblockMachineBuilder)super.shape(shape);
    }

    public MultiblockMachineBuilder rotationState(RotationState rotationState) {
        return (MultiblockMachineBuilder)super.rotationState(rotationState);
    }

    public MultiblockMachineBuilder hasTESR(boolean hasTESR) {
        return (MultiblockMachineBuilder)super.hasTESR(hasTESR);
    }

    public MultiblockMachineBuilder blockProp(NonNullUnaryOperator<BlockBehaviour.Properties> blockProp) {
        return (MultiblockMachineBuilder)super.blockProp(blockProp);
    }

    public MultiblockMachineBuilder itemProp(NonNullUnaryOperator<Item.Properties> itemProp) {
        return (MultiblockMachineBuilder)super.itemProp(itemProp);
    }

    public MultiblockMachineBuilder blockBuilder(Consumer<BlockBuilder<? extends Block, ?>> blockBuilder) {
        return (MultiblockMachineBuilder)super.blockBuilder(blockBuilder);
    }

    public MultiblockMachineBuilder itemBuilder(Consumer<ItemBuilder<? extends MetaMachineItem, ?>> itemBuilder) {
        return (MultiblockMachineBuilder)super.itemBuilder(itemBuilder);
    }

    public MultiblockMachineBuilder recipeTypes(GTRecipeType ... recipeTypes) {
        return (MultiblockMachineBuilder)super.recipeTypes(recipeTypes);
    }

    public MultiblockMachineBuilder recipeType(GTRecipeType recipeTypes) {
        return (MultiblockMachineBuilder)super.recipeType(recipeTypes);
    }

    public MultiblockMachineBuilder tier(int tier) {
        return (MultiblockMachineBuilder)super.tier(tier);
    }

    public MultiblockMachineBuilder recipeOutputLimits(Object2IntMap<RecipeCapability<?>> map) {
        return (MultiblockMachineBuilder)super.recipeOutputLimits(map);
    }

    public MultiblockMachineBuilder addOutputLimit(RecipeCapability<?> capability, int limit) {
        return (MultiblockMachineBuilder)super.addOutputLimit(capability, limit);
    }

    public MultiblockMachineBuilder itemColor(BiFunction<ItemStack, Integer, Integer> itemColor) {
        return (MultiblockMachineBuilder)super.itemColor(itemColor);
    }

    public MultiblockMachineBuilder modelRenderer(Supplier<ResourceLocation> model) {
        return (MultiblockMachineBuilder)super.modelRenderer(model);
    }

    public MultiblockMachineBuilder defaultModelRenderer() {
        return (MultiblockMachineBuilder)super.defaultModelRenderer();
    }

    public MultiblockMachineBuilder overlayTieredHullRenderer(String name) {
        return (MultiblockMachineBuilder)super.overlayTieredHullRenderer(name);
    }

    public MultiblockMachineBuilder workableTieredHullRenderer(ResourceLocation workableModel) {
        return (MultiblockMachineBuilder)super.workableTieredHullRenderer(workableModel);
    }

    public MultiblockMachineBuilder workableCasingRenderer(ResourceLocation baseCasing, ResourceLocation overlayModel) {
        return (MultiblockMachineBuilder)super.workableCasingRenderer(baseCasing, overlayModel);
    }

    public MultiblockMachineBuilder workableCasingRenderer(ResourceLocation baseCasing, ResourceLocation overlayModel, boolean tint) {
        return (MultiblockMachineBuilder)super.workableCasingRenderer(baseCasing, overlayModel, tint);
    }

    public MultiblockMachineBuilder sidedWorkableCasingRenderer(String basePath, ResourceLocation overlayModel, boolean tint) {
        return (MultiblockMachineBuilder)super.sidedWorkableCasingRenderer(basePath, overlayModel, tint);
    }

    public MultiblockMachineBuilder tooltipBuilder(BiConsumer<ItemStack, List<Component>> tooltipBuilder) {
        return (MultiblockMachineBuilder)super.tooltipBuilder(tooltipBuilder);
    }

    public MultiblockMachineBuilder appearance(Supplier<BlockState> state) {
        return (MultiblockMachineBuilder)super.appearance(state);
    }

    public MultiblockMachineBuilder appearanceBlock(Supplier<? extends Block> block) {
        return (MultiblockMachineBuilder)super.appearanceBlock(block);
    }

    public MultiblockMachineBuilder langValue(String langValue) {
        return (MultiblockMachineBuilder)super.langValue(langValue);
    }

    public MultiblockMachineBuilder overlaySteamHullRenderer(String name) {
        return (MultiblockMachineBuilder)super.overlaySteamHullRenderer(name);
    }

    public MultiblockMachineBuilder workableSteamHullRenderer(boolean isHighPressure, ResourceLocation workableModel) {
        return (MultiblockMachineBuilder)super.workableSteamHullRenderer(isHighPressure, workableModel);
    }

    public MultiblockMachineBuilder tooltips(Component ... components) {
        return (MultiblockMachineBuilder)super.tooltips(components);
    }

    public MultiblockMachineBuilder abilities(PartAbility ... abilities) {
        return (MultiblockMachineBuilder)super.abilities(abilities);
    }

    public MultiblockMachineBuilder paintingColor(int paintingColor) {
        return (MultiblockMachineBuilder)super.paintingColor(paintingColor);
    }

    public MultiblockMachineBuilder recipeModifier(BiFunction<MetaMachine, GTRecipe, GTRecipe> recipeModifier) {
        return (MultiblockMachineBuilder)super.recipeModifier(recipeModifier);
    }

    public MultiblockMachineBuilder recipeModifier(BiFunction<MetaMachine, GTRecipe, GTRecipe> recipeModifier, boolean alwaysTryModifyRecipe) {
        return (MultiblockMachineBuilder)super.recipeModifier(recipeModifier, alwaysTryModifyRecipe);
    }

    public MultiblockMachineBuilder alwaysTryModifyRecipe(boolean alwaysTryModifyRecipe) {
        return (MultiblockMachineBuilder)super.alwaysTryModifyRecipe(alwaysTryModifyRecipe);
    }

    public MultiblockMachineBuilder editableUI(@Nullable EditableMachineUI editableUI) {
        return (MultiblockMachineBuilder)super.editableUI(editableUI);
    }

    public MultiblockMachineBuilder compassSections(CompassSection ... sections) {
        return (MultiblockMachineBuilder)super.compassSections(sections);
    }

    public MultiblockMachineBuilder compassNodeSelf() {
        return (MultiblockMachineBuilder)super.compassNodeSelf();
    }

    public MultiblockMachineBuilder compassNode(String compassNode) {
        return (MultiblockMachineBuilder)super.compassNode(compassNode);
    }

    public MultiblockMachineBuilder compassPreNodes(CompassSection section, String ... compassNodes) {
        return (MultiblockMachineBuilder)super.compassPreNodes(section, compassNodes);
    }

    public MultiblockMachineBuilder compassPreNodes(ResourceLocation ... compassNodes) {
        return (MultiblockMachineBuilder)super.compassPreNodes(compassNodes);
    }

    public MultiblockMachineBuilder compassPreNodes(CompassNode ... compassNodes) {
        return (MultiblockMachineBuilder)super.compassPreNodes(compassNodes);
    }

    public MultiblockMachineBuilder onBlockEntityRegister(NonNullConsumer<BlockEntityType<BlockEntity>> onBlockEntityRegister) {
        return (MultiblockMachineBuilder)super.onBlockEntityRegister(onBlockEntityRegister);
    }

    @Override
    public MultiblockMachineDefinition register() {
        MultiblockMachineDefinition definition = (MultiblockMachineDefinition)super.register();
        if (this.pattern == null) {
            throw new IllegalStateException("missing pattern while creating multiblock " + this.name);
        }
        definition.setPatternFactory((Supplier<BlockPattern>)Suppliers.memoize(() -> this.pattern.apply(definition)));
        definition.setShapes(() -> this.shapeInfos.stream().map(factory -> (List)factory.apply(definition)).flatMap(Collection::stream).toList());
        if (!this.recoveryItems.isEmpty()) {
            definition.setRecoveryItems(() -> (ItemStack[])this.recoveryItems.stream().map(Supplier::get).flatMap(Arrays::stream).toArray(ItemStack[]::new));
        }
        definition.setPartSorter(this.partSorter);
        if (this.partAppearance == null) {
            this.partAppearance = (controller, part, side) -> definition.getAppearance().get();
        }
        definition.setPartAppearance(this.partAppearance);
        definition.setAdditionalDisplay(this.additionalDisplay);
        return definition;
    }

    public MultiblockMachineBuilder pattern(Function<MultiblockMachineDefinition, BlockPattern> pattern) {
        this.pattern = pattern;
        return this;
    }

    public MultiblockMachineBuilder partSorter(Comparator<IMultiPart> partSorter) {
        this.partSorter = partSorter;
        return this;
    }

    public MultiblockMachineBuilder partAppearance(TriFunction<IMultiController, IMultiPart, Direction, BlockState> partAppearance) {
        this.partAppearance = partAppearance;
        return this;
    }

    public BiConsumer<IMultiController, List<Component>> additionalDisplay() {
        return this.additionalDisplay;
    }

    public MultiblockMachineBuilder additionalDisplay(BiConsumer<IMultiController, List<Component>> additionalDisplay) {
        this.additionalDisplay = additionalDisplay;
        return this;
    }
}

