/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.CompassSection;
import com.gregtechceu.gtceu.utils.FormattingUtil;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.json.SimpleIGuiTextureJsonUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CompassNode {
    private final ResourceLocation sectionID;
    private final ResourceLocation nodeID;
    private ResourceLocation page;
    private int size = 24;
    @Nullable
    private Position position = null;
    private final Set<ResourceLocation> preNodes = new HashSet<ResourceLocation>();
    private final List<Supplier<? extends Item>> items = new ArrayList<Supplier<? extends Item>>();
    private final Set<TagKey<Item>> tags = new HashSet<TagKey<Item>>();
    @Nullable
    private Supplier<IGuiTexture> icon = null;
    private String lang;

    private CompassNode(ResourceLocation sectionID, String nodeID) {
        this.sectionID = sectionID;
        this.lang = FormattingUtil.toEnglishName(nodeID);
        this.page = this.nodeID = GTCEu.id(sectionID.m_135815_() + "/" + nodeID);
    }

    public static CompassNode getOrCreate(ResourceLocation sectionID, String nodeID) {
        CompassNode exist = (CompassNode)GTRegistries.COMPASS_NODES.get(GTCEu.id(sectionID.m_135815_() + "/" + nodeID));
        return exist == null ? new CompassNode(sectionID, nodeID).register() : exist;
    }

    public static CompassNode getOrCreate(CompassSection section, String nodeID) {
        return CompassNode.getOrCreate(section.sectionID(), nodeID);
    }

    public static CompassNode getOrCreate(CompassSection section, Supplier<? extends Item> item) {
        return CompassNode.getOrCreate(section.sectionID(), BuiltInRegistries.f_257033_.m_7981_((Object)item.get()).m_135815_()).addItem(item);
    }

    private CompassNode register() {
        GTRegistries.COMPASS_NODES.register(this.nodeID, this);
        return this;
    }

    public String getUnlocalizedKey() {
        return this.nodeID.m_214296_("compass.node");
    }

    public CompassNode position(int x, int y) {
        this.position = new Position(x, y);
        return this;
    }

    public CompassNode addPreNode(ResourceLocation ... nodeID) {
        this.preNodes.addAll(Arrays.stream(nodeID).toList());
        return this;
    }

    public CompassNode addPreNode(CompassNode ... node) {
        this.preNodes.addAll(Arrays.stream(node).map(CompassNode::nodeID).toList());
        return this;
    }

    public CompassNode addItem(Supplier<? extends Item> item) {
        this.items.add(item);
        return this;
    }

    public CompassNode addTag(TagKey<Item> ... tags) {
        this.tags.addAll(List.of(tags));
        return this;
    }

    public CompassNode iconIfNull(Supplier<IGuiTexture> icon) {
        this.icon = this.icon == null ? icon : this.icon;
        return this;
    }

    public ResourceLocation sectionID() {
        return this.sectionID;
    }

    public ResourceLocation nodeID() {
        return this.nodeID;
    }

    public CompassNode page(ResourceLocation page) {
        this.page = page;
        return this;
    }

    public CompassNode size(int size) {
        this.size = size;
        return this;
    }

    public CompassNode position(@Nullable Position position) {
        this.position = position;
        return this;
    }

    public CompassNode icon(@Nullable Supplier<IGuiTexture> icon) {
        this.icon = icon;
        return this;
    }

    public CompassNode lang(String lang) {
        this.lang = lang;
        return this;
    }

    public String lang() {
        return this.lang;
    }

    public static class CompassNodeProvider
    implements DataProvider {
        private final PackOutput output;
        private final Predicate<ResourceLocation> existingHelper;

        public CompassNodeProvider(PackOutput output, Predicate<ResourceLocation> existingHelper) {
            this.output = output;
            this.existingHelper = existingHelper;
        }

        public CompletableFuture<?> m_213708_(CachedOutput cache) {
            return this.generate(this.output.m_247566_(PackOutput.Target.RESOURCE_PACK).resolve("gtceu"), cache);
        }

        public String m_6055_() {
            return "GTCEU's Compass Nodes";
        }

        public CompletableFuture<?> generate(Path path, CachedOutput cache) {
            HashMap<ResourceLocation, List> nodesNOPosition = new HashMap<ResourceLocation, List>();
            CompletionStage<Object> future = CompletableFuture.completedFuture(null);
            for (CompassNode node : GTRegistries.COMPASS_NODES) {
                if (node.position == null) {
                    nodesNOPosition.computeIfAbsent(node.sectionID, k -> new ArrayList()).add(node);
                    continue;
                }
                this.genNodeData(path, cache, node);
            }
            block1: for (List nodes : nodesNOPosition.values()) {
                int size = nodes.size();
                int row = (int)Math.ceil(Math.sqrt(size));
                for (int i = 0; i < row; ++i) {
                    boolean done = false;
                    for (int j = 0; j < row; ++j) {
                        int index = i * row + j;
                        if (index >= nodes.size()) {
                            done = true;
                            break;
                        }
                        CompassNode node = (CompassNode)nodes.get(index);
                        node.position = new Position(-(row * 50) + 50 * j, 50 * i);
                        Path finalPath = path;
                        future = future.thenComposeAsync(v -> this.genNodeData(finalPath, cache, node));
                    }
                    if (done) continue block1;
                }
            }
            return future;
        }

        private CompletableFuture<?> genNodeData(Path path, CachedOutput cache, CompassNode node) {
            if (node.position == null) {
                return CompletableFuture.completedFuture(null);
            }
            String resourcePath = "compass/nodes/" + node.nodeID.m_135815_() + ".json";
            if (this.existingHelper.test(GTCEu.id(resourcePath))) {
                return CompletableFuture.completedFuture(null);
            }
            JsonObject json = new JsonObject();
            json.addProperty("section", node.sectionID.toString());
            json.addProperty("page", node.page.toString());
            if (node.icon == null) {
                node.icon = !node.items.isEmpty() ? () -> new ItemStackTexture(new Item[]{node.items.get(0).get()}) : () -> IGuiTexture.EMPTY;
            }
            json.add("button_texture", (JsonElement)SimpleIGuiTextureJsonUtils.toJson((IGuiTexture)node.icon.get()));
            if (node.size != 24) {
                json.addProperty("size", (Number)node.size);
            }
            JsonArray pos = new JsonArray();
            pos.add((Number)node.position.x);
            pos.add((Number)node.position.y);
            json.add("position", (JsonElement)pos);
            if (!node.preNodes.isEmpty()) {
                JsonArray pre = new JsonArray();
                for (ResourceLocation resourceLocation : node.preNodes) {
                    pre.add(resourceLocation.toString());
                }
                json.add("pre_nodes", (JsonElement)pre);
            }
            JsonArray items = new JsonArray();
            if (!node.tags.isEmpty()) {
                for (TagKey tagKey : node.tags) {
                    items.add("#" + tagKey.f_203868_());
                }
            }
            if (!node.items.isEmpty()) {
                for (Supplier supplier : node.items) {
                    items.add(BuiltInRegistries.f_257033_.m_7981_((Object)((Item)supplier.get())).toString());
                }
            }
            if (!items.isEmpty()) {
                json.add("items", (JsonElement)items);
            }
            return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)json, (Path)path.resolve(resourcePath));
        }
    }
}

