/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.core.mixins.ShapedRecipeInvoker;
import java.util.Map;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public class ShapedEnergyTransferRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<ShapedEnergyTransferRecipe> SERIALIZER = new Serializer();
    private CraftingContainer craftingContainer;
    private final Ingredient chargeIngredient;
    private final boolean transferMaxCharge;
    private final boolean overrideCharge;

    public ShapedEnergyTransferRecipe(ResourceLocation id, String group, int width, int height, Ingredient chargeIngredient, boolean overrideCharge, boolean transferMaxCharge, NonNullList<Ingredient> recipeItems, ItemStack result) {
        super(id, group, CraftingBookCategory.MISC, width, height, recipeItems, result);
        this.chargeIngredient = chargeIngredient;
        this.transferMaxCharge = transferMaxCharge;
        this.overrideCharge = overrideCharge;
    }

    public boolean m_5818_(CraftingContainer inv, Level level) {
        this.craftingContainer = inv;
        return super.m_5818_(inv, level);
    }

    public ItemStack m_8043_(RegistryAccess registryManager) {
        long maxCharge = 0L;
        long charge = 0L;
        ItemStack resultStack = super.m_8043_(registryManager);
        for (ItemStack chargeStack : this.chargeIngredient.m_43908_()) {
            for (int i = 0; i < this.craftingContainer.m_6643_(); ++i) {
                ItemStack stack;
                IElectricItem electricItem;
                if (!ItemStack.m_41656_((ItemStack)this.craftingContainer.m_8020_(i), (ItemStack)chargeStack) || (electricItem = GTCapabilityHelper.getElectricItem(stack = this.craftingContainer.m_8020_(i))) == null) continue;
                resultStack.m_41784_().m_128356_("MaxCharge", maxCharge += electricItem.getMaxCharge());
                resultStack.m_41784_().m_128356_("Charge", charge += electricItem.getCharge());
                return resultStack;
            }
        }
        return resultStack;
    }

    public Ingredient getChargeIngredient() {
        return this.chargeIngredient;
    }

    public boolean isTransferMaxCharge() {
        return this.transferMaxCharge;
    }

    public boolean isOverrideCharge() {
        return this.overrideCharge;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedEnergyTransferRecipe> {
        public ShapedEnergyTransferRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String string = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            Map<String, Ingredient> map = ShapedRecipeInvoker.callKeyFromJson(GsonHelper.m_13930_((JsonObject)json, (String)"key"));
            String[] strings = ShapedRecipeInvoker.callPatternFromJson(GsonHelper.m_13933_((JsonObject)json, (String)"pattern"));
            int i = strings[0].length();
            int j = strings.length;
            NonNullList<Ingredient> nonNullList = ShapedRecipeInvoker.callDissolvePattern(strings, map, i, j);
            boolean overrideCharge = GsonHelper.m_13912_((JsonObject)json, (String)"overrideCharge");
            boolean transferMaxCharge = GsonHelper.m_13912_((JsonObject)json, (String)"transferMaxCharge");
            Ingredient chargeIngredient = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"chargeIngredient"));
            ItemStack itemStack = ShapedEnergyTransferRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new ShapedEnergyTransferRecipe(recipeId, string, i, j, chargeIngredient, overrideCharge, transferMaxCharge, nonNullList, itemStack);
        }

        public ShapedEnergyTransferRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int i = buffer.m_130242_();
            int j = buffer.m_130242_();
            boolean overrideCharge = buffer.readBoolean();
            boolean transferMaxCharge = buffer.readBoolean();
            Ingredient chargeIngredient = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            String string = buffer.m_130277_();
            NonNullList nonNullList = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            nonNullList.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            ItemStack itemStack = buffer.m_130267_();
            return new ShapedEnergyTransferRecipe(recipeId, string, i, j, chargeIngredient, overrideCharge, transferMaxCharge, (NonNullList<Ingredient>)nonNullList, itemStack);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedEnergyTransferRecipe recipe) {
            buffer.m_130130_(recipe.m_44220_());
            buffer.m_130130_(recipe.m_44221_());
            buffer.writeBoolean(recipe.isOverrideCharge());
            buffer.writeBoolean(recipe.isTransferMaxCharge());
            recipe.getChargeIngredient().m_43923_(buffer);
            buffer.m_130070_(recipe.m_6076_());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.m_8043_(GTRegistries.builtinRegistry()));
        }
    }
}

