/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet.longdistance;

import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDEndpoint;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistanceNetwork;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistancePipeBlock;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class NetworkBuilder
implements Runnable {
    private final LinkedList<BlockPos> starts = new LinkedList();
    private final LongDistanceNetwork.WorldData worldData;
    private LongDistanceNetwork network;
    private final LevelAccessor world;
    private final LinkedList<BlockPos> currentPoints = new LinkedList();
    private final ObjectOpenHashSet<BlockPos> walked = new ObjectOpenHashSet();
    private final List<BlockPos> pipes = new ArrayList<BlockPos>();
    private final List<ILDEndpoint> endpoints = new ArrayList<ILDEndpoint>();

    public NetworkBuilder(LongDistanceNetwork.WorldData worldData, LongDistanceNetwork network, BlockPos start) {
        this.worldData = worldData;
        this.network = network;
        this.world = worldData.getWorld();
        this.starts.add(start);
    }

    public NetworkBuilder(LongDistanceNetwork.WorldData worldData, LongDistanceNetwork network, Collection<BlockPos> starts) {
        this.worldData = worldData;
        this.network = network;
        this.world = worldData.getWorld();
        this.starts.addAll(starts);
    }

    @Override
    public void run() {
        boolean first = true;
        while (!this.starts.isEmpty()) {
            BlockPos start = this.starts.pollFirst();
            if (first) {
                first = false;
                this.checkNetwork(start);
                continue;
            }
            LongDistanceNetwork ldn = this.worldData.getNetwork(start);
            if (ldn != null) continue;
            this.network = this.network.getPipeType().createNetwork(this.worldData);
            this.currentPoints.clear();
            this.walked.clear();
            this.pipes.clear();
            this.endpoints.clear();
            this.checkNetwork(start);
        }
    }

    private void checkNetwork(BlockPos start) {
        this.currentPoints.add(start);
        this.checkPos(this.world.m_8055_(start), start);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        while (!this.currentPoints.isEmpty()) {
            BlockPos current = this.currentPoints.pollFirst();
            for (Direction facing : Direction.values()) {
                BlockState blockState;
                pos.m_122190_((Vec3i)current).m_122173_(facing);
                if (this.walked.contains((Object)pos) || (blockState = this.world.m_8055_((BlockPos)pos)).m_60795_()) continue;
                this.checkPos(blockState, (BlockPos)pos);
            }
        }
        this.network.setData(this.pipes, this.endpoints);
    }

    private void checkPos(BlockState blockState, BlockPos pos) {
        BlockPos bp = pos.m_7949_();
        if (blockState.m_60734_() instanceof LongDistancePipeBlock && this.network.getPipeType().isValidBlock(blockState)) {
            this.pipes.add(bp);
            this.currentPoints.addLast(bp);
        } else {
            ILDEndpoint endpoint = ILDEndpoint.tryGet(this.world, pos);
            if (endpoint != null && this.network.getPipeType().isValidEndpoint(endpoint)) {
                this.pipes.add(bp);
                this.endpoints.add(endpoint);
            }
        }
        this.walked.add((Object)bp);
    }
}

