/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet.longdistance;

import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDEndpoint;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistanceNetwork;
import com.gregtechceu.gtceu.common.pipelike.fluidpipe.longdistance.LDFluidPipeType;
import com.gregtechceu.gtceu.common.pipelike.item.longdistance.LDItemPipeType;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public abstract class LongDistancePipeType {
    private static final Object2ObjectOpenHashMap<String, LongDistancePipeType> PIPE_TYPES = new Object2ObjectOpenHashMap();
    private static LDFluidPipeType FLUID;
    private static LDItemPipeType ITEM;
    private final String name;

    protected LongDistancePipeType(String name) {
        this.name = Objects.requireNonNull(name);
        if (PIPE_TYPES.containsKey((Object)name)) {
            throw new IllegalArgumentException("Pipe Type with name " + name + " already exists!");
        }
        for (LongDistancePipeType pipeType : PIPE_TYPES.values()) {
            if (this.getClass() != pipeType.getClass()) continue;
            throw new IllegalStateException("Duplicate Pipe Type " + name + " and " + pipeType.name);
        }
        PIPE_TYPES.put((Object)name, (Object)this);
    }

    public static void init() {
        FLUID = LDFluidPipeType.INSTANCE;
        ITEM = LDItemPipeType.INSTANCE;
    }

    public static LDFluidPipeType fluid() {
        return FLUID;
    }

    public static LDItemPipeType item() {
        return ITEM;
    }

    public static LongDistancePipeType getPipeType(String name) {
        return (LongDistancePipeType)PIPE_TYPES.get((Object)name);
    }

    public abstract boolean isValidBlock(BlockState var1);

    public abstract boolean isValidEndpoint(ILDEndpoint var1);

    public int getMinLength() {
        return 0;
    }

    public boolean satisfiesMinLength(ILDEndpoint endpoint1, ILDEndpoint endpoint2) {
        BlockPos p = endpoint2.getPos();
        int minLength = this.getMinLength();
        return endpoint1 != endpoint2 && endpoint1.getPos().m_123331_((Vec3i)p) >= (double)(minLength * minLength);
    }

    @Nonnull
    public LongDistanceNetwork createNetwork(LongDistanceNetwork.WorldData worldData) {
        return new LongDistanceNetwork(this, worldData);
    }

    public final LongDistanceNetwork createNetwork(Level world) {
        return this.createNetwork(LongDistanceNetwork.WorldData.get((LevelAccessor)world));
    }

    public final String getName() {
        return this.name;
    }
}

