/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet;

import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.blockentity.IPaintable;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.pipenet.IAttachData;
import com.gregtechceu.gtceu.api.pipenet.IPipeType;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.pipelike.PipeNet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public interface IPipeNode<PipeType extends Enum<PipeType>, NodeDataType extends IAttachData>
extends ITickSubscription,
IPaintable {
    public long getOffsetTimer();

    public ICoverable getCoverContainer();

    public boolean isBlocked(Direction var1);

    public void setConnections(int var1);

    public int getConnections();

    public int getNumConnections();

    public void setBlocked(Direction var1, boolean var2);

    public boolean canAttachTo(Direction var1);

    public int getVisualConnections();

    default public boolean isConnected(Direction side) {
        return !this.isBlocked(side);
    }

    default public void updateConnections() {
        PipeNet<NodeDataType> net = this.getPipeNet();
        if (net != null) {
            BlockPos pos = this.getPipePos();
            net.onNeighbourUpdate(pos);
            NodeDataType data = this.getNodeData();
            boolean dataDirty = false;
            if (data == null) {
                LDLib.LOGGER.warn("data shouldn't be null here, did you add pipe without placement?");
                net.getWorldData().addNode(pos, ((IPipeType)this.getPipeType()).modifyProperties(this.getPipeBlock().getFallbackType()), 0, 0, true);
                data = this.getNodeData();
                if (data == null) {
                    throw new IllegalStateException("data shouldn't be null here!");
                }
            }
            for (Direction side : Direction.values()) {
                boolean canAttach;
                if (this.isBlocked(side) || net.containsNode(pos.m_121945_(side)) || !data.setAttached(side, canAttach = this.canAttachTo(side))) continue;
                dataDirty = true;
            }
            if (dataDirty) {
                net.updateNodeData(pos, data);
            }
        }
    }

    default public BlockEntity self() {
        return (BlockEntity)this;
    }

    default public Level getPipeLevel() {
        return this.self().m_58904_();
    }

    default public BlockPos getPipePos() {
        return this.self().m_58899_();
    }

    default public void markAsDirty() {
        this.self().m_6596_();
    }

    default public boolean isInValid() {
        return this.self().m_58901_();
    }

    default public boolean isRemote() {
        Level level = this.getPipeLevel();
        if (level == null) {
            return LDLib.isRemote();
        }
        return level.f_46443_;
    }

    default public PipeBlock<PipeType, NodeDataType, ?> getPipeBlock() {
        return (PipeBlock)this.self().m_58900_().m_60734_();
    }

    @Nullable
    default public PipeNet<NodeDataType> getPipeNet() {
        Level level = this.getPipeLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return this.getPipeBlock().getWorldPipeNet(serverLevel).getNetFromPos(this.getPipePos());
        }
        return null;
    }

    default public PipeType getPipeType() {
        return this.getPipeBlock().pipeType;
    }

    @Nullable
    default public NodeDataType getNodeData() {
        PipeNet<NodeDataType> net = this.getPipeNet();
        if (net != null) {
            return (NodeDataType)((IAttachData)net.getNodeAt((BlockPos)this.getPipePos()).data);
        }
        return null;
    }

    default public void notifyBlockUpdate() {
        Level level = this.getPipeLevel();
        if (level != null) {
            level.m_46672_(this.getPipePos(), level.m_8055_(this.getPipePos()).m_60734_());
        }
    }

    default public void scheduleRenderUpdate() {
        BlockPos pos = this.getPipePos();
        Level level = this.getPipeLevel();
        if (level != null) {
            BlockState state = level.m_8055_(pos);
            if (level.f_46443_) {
                level.m_7260_(pos, state, state, 8);
            } else {
                level.m_7696_(pos, state.m_60734_(), 1, 0);
            }
        }
    }

    default public void serverTick() {
    }

    default public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        if (!this.isRemote()) {
            this.updateConnections();
        }
        this.getCoverContainer().onNeighborChanged(block, fromPos, isMoving);
    }

    default public void scheduleNeighborShapeUpdate() {
        Level level = this.getPipeLevel();
        BlockPos pos = this.getPipePos();
        if (level == null || pos == null) {
            return;
        }
        level.m_8055_(pos).m_60701_((LevelAccessor)level, pos, 3);
    }

    @Override
    default public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @Nullable
    public Material getFrameMaterial();
}

