/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern;

import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.pattern.MultiblockWorldSavedData;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.error.PatternError;
import com.gregtechceu.gtceu.api.pattern.error.PatternStringError;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import com.gregtechceu.gtceu.api.pattern.util.PatternMatchContext;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MultiblockState {
    public static final PatternError UNLOAD_ERROR = new PatternStringError("multiblocked.pattern.error.chunk");
    public static final PatternError UNINIT_ERROR = new PatternStringError("multiblocked.pattern.error.init");
    private BlockPos pos;
    private BlockState blockState;
    private BlockEntity tileEntity;
    private boolean tileEntityInitialized;
    private final PatternMatchContext matchContext;
    private Map<SimplePredicate, Integer> globalCount;
    private Map<SimplePredicate, Integer> layerCount;
    public TraceabilityPredicate predicate;
    public IO io;
    public PatternError error;
    public final Level world;
    public final BlockPos controllerPos;
    public IMultiController lastController;
    public LongOpenHashSet cache;

    public MultiblockState(Level world, BlockPos controllerPos) {
        this.world = world;
        this.controllerPos = controllerPos;
        this.error = UNINIT_ERROR;
        this.matchContext = new PatternMatchContext();
    }

    protected void clean() {
        this.matchContext.reset();
        this.globalCount = new HashMap<SimplePredicate, Integer>();
        this.layerCount = new HashMap<SimplePredicate, Integer>();
        this.cache = new LongOpenHashSet();
    }

    protected boolean update(BlockPos posIn, TraceabilityPredicate predicate) {
        this.pos = posIn;
        this.blockState = null;
        this.tileEntity = null;
        this.tileEntityInitialized = false;
        this.predicate = predicate;
        this.error = null;
        if (!this.world.m_46749_(posIn)) {
            this.error = UNLOAD_ERROR;
            return false;
        }
        return true;
    }

    public IMultiController getController() {
        if (this.world.m_46749_(this.controllerPos)) {
            IMachineBlockEntity machineBlockEntity;
            Object object = this.world.m_7702_(this.controllerPos);
            if (object instanceof IMachineBlockEntity && (object = (machineBlockEntity = (IMachineBlockEntity)object).getMetaMachine()) instanceof IMultiController) {
                IMultiController controller;
                this.lastController = controller = (IMultiController)object;
                return this.lastController;
            }
        } else {
            this.error = UNLOAD_ERROR;
        }
        return null;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public void setError(PatternError error) {
        this.error = error;
        if (error != null) {
            error.setWorldState(this);
        }
    }

    public BlockState getBlockState() {
        if (this.blockState == null) {
            this.blockState = this.world.m_8055_(this.pos);
        }
        if (this.blockState == null) {
            System.out.printf("error", new Object[0]);
        }
        return this.blockState;
    }

    @Nullable
    public BlockEntity getTileEntity() {
        if (!this.getBlockState().m_155947_()) {
            return null;
        }
        if (this.tileEntity == null && !this.tileEntityInitialized) {
            this.tileEntity = this.world.m_7702_(this.pos);
            this.tileEntityInitialized = true;
        }
        return this.tileEntity;
    }

    public BlockPos getPos() {
        return this.pos.m_7949_();
    }

    public BlockState getOffsetState(Direction face) {
        if (this.pos instanceof BlockPos.MutableBlockPos) {
            ((BlockPos.MutableBlockPos)this.pos).m_122173_(face);
            BlockState blockState = this.world.m_8055_(this.pos);
            ((BlockPos.MutableBlockPos)this.pos).m_122173_(face.m_122424_());
            return blockState;
        }
        return this.world.m_8055_(this.pos.m_121945_(face));
    }

    public Level getWorld() {
        return this.world;
    }

    public void addPosCache(BlockPos pos) {
        this.cache.add(pos.m_121878_());
    }

    public boolean isPosInCache(BlockPos pos) {
        return this.cache.contains(pos.m_121878_());
    }

    public Collection<BlockPos> getCache() {
        return this.cache.stream().map(BlockPos::m_122022_).collect(Collectors.toList());
    }

    public void onBlockStateChanged(BlockPos pos, BlockState state) {
        Level level = this.world;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (pos.equals((Object)this.controllerPos)) {
                if (this.lastController != null && !state.m_60713_(this.lastController.self().getBlockState().m_60734_())) {
                    this.lastController.onStructureInvalid();
                    MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
                    mwsd.removeMapping(this);
                }
            } else {
                IMultiController controller = this.getController();
                if (controller != null) {
                    LongSet activeBlocks;
                    if (controller.isFormed() && state.m_60734_() instanceof ActiveBlock && (activeBlocks = this.getMatchContext().getOrDefault("vaBlocks", LongSets.emptySet())).contains(pos.m_121878_())) {
                        return;
                    }
                    if (controller.checkPatternWithLock()) {
                        controller.onStructureFormed();
                    } else {
                        controller.onStructureInvalid();
                        MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
                        mwsd.removeMapping(this);
                        mwsd.addAsyncLogic(controller);
                    }
                }
            }
        }
    }

    public PatternMatchContext getMatchContext() {
        return this.matchContext;
    }

    public Map<SimplePredicate, Integer> getGlobalCount() {
        return this.globalCount;
    }

    public Map<SimplePredicate, Integer> getLayerCount() {
        return this.layerCount;
    }
}

