/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class NotifiableEnergyContainer
extends NotifiableRecipeHandlerTrait<Long>
implements IEnergyContainer {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(NotifiableEnergyContainer.class, NotifiableRecipeHandlerTrait.MANAGED_FIELD_HOLDER);
    protected IO handlerIO;
    @Persisted
    @DescSynced
    protected long energyStored;
    private long energyCapacity;
    private long inputVoltage;
    private long inputAmperage;
    private long outputVoltage;
    private long outputAmperage;
    private Predicate<Direction> sideInputCondition;
    private Predicate<Direction> sideOutputCondition;
    protected long amps;
    protected long lastTS = Long.MIN_VALUE;
    protected TickableSubscription outputSubs;

    public NotifiableEnergyContainer(MetaMachine machine, long maxCapacity, long maxInputVoltage, long maxInputAmperage, long maxOutputVoltage, long maxOutputAmperage) {
        super(machine);
        boolean isOUT;
        this.energyCapacity = maxCapacity;
        this.inputVoltage = maxInputVoltage;
        this.inputAmperage = maxInputAmperage;
        this.outputVoltage = maxOutputVoltage;
        this.outputAmperage = maxOutputAmperage;
        boolean isIN = this.inputVoltage != 0L && this.inputAmperage != 0L;
        boolean bl = isOUT = this.outputVoltage != 0L && this.outputAmperage != 0L;
        this.handlerIO = isIN && isOUT ? IO.BOTH : (isIN ? IO.IN : (isOUT ? IO.OUT : IO.NONE));
    }

    public static NotifiableEnergyContainer emitterContainer(MetaMachine machine, long maxCapacity, long maxOutputVoltage, long maxOutputAmperage) {
        return new NotifiableEnergyContainer(machine, maxCapacity, 0L, 0L, maxOutputVoltage, maxOutputAmperage);
    }

    public static NotifiableEnergyContainer receiverContainer(MetaMachine machine, long maxCapacity, long maxInputVoltage, long maxInputAmperage) {
        return new NotifiableEnergyContainer(machine, maxCapacity, maxInputVoltage, maxInputAmperage, 0L, 0L);
    }

    public void resetBasicInfo(long maxCapacity, long maxInputVoltage, long maxInputAmperage, long maxOutputVoltage, long maxOutputAmperage) {
        boolean isOUT;
        this.energyCapacity = maxCapacity;
        this.inputVoltage = maxInputVoltage;
        this.inputAmperage = maxInputAmperage;
        this.outputVoltage = maxOutputVoltage;
        this.outputAmperage = maxOutputAmperage;
        boolean isIN = this.inputVoltage != 0L && this.inputAmperage != 0L;
        boolean bl = isOUT = this.outputVoltage != 0L && this.outputAmperage != 0L;
        this.handlerIO = isIN && isOUT ? IO.BOTH : (isIN ? IO.IN : (isOUT ? IO.OUT : IO.NONE));
        this.checkOutputSubscription();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public void onMachineLoad() {
        super.onMachineLoad();
        this.checkOutputSubscription();
    }

    public void checkOutputSubscription() {
        if (this.getOutputVoltage() > 0L && this.getOutputAmperage() > 0L) {
            if (this.getEnergyStored() >= this.getOutputVoltage()) {
                this.outputSubs = this.getMachine().subscribeServerTick(this.outputSubs, this::serverTick);
            } else if (this.outputSubs != null) {
                this.outputSubs.unsubscribe();
                this.outputSubs = null;
            }
        }
    }

    public void setEnergyStored(long energyStored) {
        if (this.energyStored == energyStored) {
            return;
        }
        this.energyStored = energyStored;
        this.checkOutputSubscription();
        this.notifyListeners();
    }

    public void serverTick() {
        long outputVoltage = this.getOutputVoltage();
        long outputAmperes = Math.min(this.getEnergyStored() / outputVoltage, this.getOutputAmperage());
        if (outputAmperes == 0L) {
            return;
        }
        long amperesUsed = 0L;
        for (Direction side : Direction.values()) {
            if (!this.outputsEnergy(side)) continue;
            Direction oppositeSide = side.m_122424_();
            IEnergyContainer energyContainer = GTCapabilityHelper.getEnergyContainer(this.machine.getLevel(), this.machine.getPos().m_121945_(side), oppositeSide);
            if (energyContainer != null && energyContainer.inputsEnergy(oppositeSide) && (amperesUsed += energyContainer.acceptEnergyFromNetwork(oppositeSide, outputVoltage, outputAmperes - amperesUsed)) == outputAmperes) break;
        }
        if (amperesUsed > 0L) {
            this.setEnergyStored(this.getEnergyStored() - amperesUsed * outputVoltage);
        }
    }

    public boolean dischargeOrRechargeEnergyContainers(IItemTransfer itemHandler, int slotIndex, boolean simulate) {
        ItemStack stackInSlot = itemHandler.getStackInSlot(slotIndex).m_41777_();
        if (stackInSlot.m_41619_()) {
            return false;
        }
        IElectricItem electricItem = GTCapabilityHelper.getElectricItem(stackInSlot);
        if (electricItem != null && this.handleElectricItem(electricItem, simulate)) {
            if (!simulate) {
                itemHandler.setStackInSlot(slotIndex, stackInSlot);
                itemHandler.onContentsChanged();
            }
            return true;
        }
        return false;
    }

    private boolean handleElectricItem(IElectricItem electricItem, boolean simulate) {
        byte machineTier = GTUtil.getTierByVoltage(Math.max(this.getInputVoltage(), this.getOutputVoltage()));
        int chargeTier = Math.min(machineTier, electricItem.getTier());
        double chargePercent = (double)this.getEnergyStored() / ((double)this.getEnergyCapacity() * 1.0);
        if (electricItem.canProvideChargeExternally() && this.getEnergyCanBeInserted() > 0L && chargePercent <= 0.5 && chargeTier == machineTier) {
            long dischargedBy = electricItem.discharge(this.getEnergyCanBeInserted(), machineTier, false, true, simulate);
            if (!simulate) {
                this.addEnergy(dischargedBy);
            }
            return dischargedBy > 0L;
        }
        if (chargePercent > 0.65) {
            long chargedBy = electricItem.charge(this.getEnergyStored(), chargeTier, false, simulate);
            if (!simulate) {
                this.removeEnergy(chargedBy);
            }
            return chargedBy > 0L;
        }
        return false;
    }

    @Override
    public long acceptEnergyFromNetwork(Direction side, long voltage, long amperage) {
        long latestTS = this.getMachine().getOffsetTimer();
        if (this.lastTS < latestTS) {
            this.amps = 0L;
            this.lastTS = latestTS;
        }
        if (this.amps >= this.getInputAmperage()) {
            return 0L;
        }
        long canAccept = this.getEnergyCapacity() - this.getEnergyStored();
        if (voltage > 0L && (side == null || this.inputsEnergy(side))) {
            long amperesAccepted;
            MetaMachine metaMachine;
            if (voltage > this.getInputVoltage() && (metaMachine = this.machine) instanceof IExplosionMachine) {
                IExplosionMachine explosionMachine = (IExplosionMachine)((Object)metaMachine);
                explosionMachine.doExplosion(GTUtil.getExplosionPower(voltage));
                return Math.min(amperage, this.getInputAmperage() - this.amps);
            }
            if (canAccept >= voltage && (amperesAccepted = Math.min(canAccept / voltage, Math.min(amperage, this.getInputAmperage() - this.amps))) > 0L) {
                this.setEnergyStored(this.getEnergyStored() + voltage * amperesAccepted);
                this.amps += amperesAccepted;
                return amperesAccepted;
            }
        }
        return 0L;
    }

    @Override
    public boolean inputsEnergy(Direction side) {
        return !this.outputsEnergy(side) && this.getInputVoltage() > 0L && (this.sideInputCondition == null || this.sideInputCondition.test(side));
    }

    @Override
    public boolean outputsEnergy(Direction side) {
        return this.getOutputVoltage() > 0L && (this.sideOutputCondition == null || this.sideOutputCondition.test(side));
    }

    @Override
    public long changeEnergy(long energyToAdd) {
        long newEnergyStored;
        long oldEnergyStored = this.getEnergyStored();
        long l = newEnergyStored = this.energyCapacity - oldEnergyStored < energyToAdd ? this.energyCapacity : oldEnergyStored + energyToAdd;
        if (newEnergyStored < 0L) {
            newEnergyStored = 0L;
        }
        this.setEnergyStored(newEnergyStored);
        return newEnergyStored - oldEnergyStored;
    }

    @Override
    public List<Long> handleRecipeInner(IO io, GTRecipe recipe, List<Long> left, @Nullable String slotName, boolean simulate) {
        NotifiableEnergyContainer capability = this;
        long sum = left.stream().reduce(0L, Long::sum);
        if (io == IO.IN) {
            long canOutput = capability.getEnergyStored();
            if (!simulate) {
                capability.addEnergy(-Math.min(canOutput, sum));
            }
            sum -= canOutput;
        } else if (io == IO.OUT) {
            long canInput = capability.getEnergyCapacity() - capability.getEnergyStored();
            if (!simulate) {
                capability.addEnergy(Math.min(canInput, sum));
            }
            sum -= canInput;
        }
        return sum <= 0L ? null : Collections.singletonList(sum);
    }

    @Override
    public RecipeCapability<Long> getCapability() {
        return EURecipeCapability.CAP;
    }

    @Override
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Override
    public long getEnergyStored() {
        return this.energyStored;
    }

    @Override
    public long getEnergyCapacity() {
        return this.energyCapacity;
    }

    @Override
    public long getInputVoltage() {
        return this.inputVoltage;
    }

    @Override
    public long getInputAmperage() {
        return this.inputAmperage;
    }

    @Override
    public long getOutputVoltage() {
        return this.outputVoltage;
    }

    @Override
    public long getOutputAmperage() {
        return this.outputAmperage;
    }

    public void setSideInputCondition(Predicate<Direction> sideInputCondition) {
        this.sideInputCondition = sideInputCondition;
    }

    public void setSideOutputCondition(Predicate<Direction> sideOutputCondition) {
        this.sideOutputCondition = sideOutputCondition;
    }
}

