/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.side.item.ItemTransferHelper;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemHandlerProxyTrait
extends MachineTrait
implements IItemTransfer,
ICapabilityTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ItemHandlerProxyTrait.class);
    public final IO capabilityIO;
    @Nullable
    public IItemTransfer proxy;

    public ItemHandlerProxyTrait(MetaMachine machine, IO capabilityIO) {
        super(machine);
        this.capabilityIO = capabilityIO;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public void onContentsChanged() {
        if (this.proxy != null) {
            this.proxy.onContentsChanged();
        }
    }

    public int getSlots() {
        return this.proxy == null ? 0 : this.proxy.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.proxy == null ? ItemStack.f_41583_ : this.proxy.getStackInSlot(slot);
    }

    public void setStackInSlot(int index, ItemStack stack) {
        if (this.proxy != null) {
            this.proxy.setStackInSlot(index, stack);
        }
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate, boolean notifyChanges) {
        if (this.proxy != null && this.canCapInput()) {
            return this.proxy.insertItem(slot, stack, simulate, notifyChanges);
        }
        return stack;
    }

    public ItemStack insertItemInternal(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.proxy == null ? stack : this.proxy.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
        if (this.proxy != null && this.canCapOutput()) {
            return this.proxy.extractItem(slot, amount, simulate, notifyChanges);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        return this.proxy == null ? ItemStack.f_41583_ : this.proxy.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.proxy == null ? 0 : this.proxy.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.proxy != null && this.proxy.isItemValid(slot, stack);
    }

    @NotNull
    public Object createSnapshot() {
        return this.proxy != null ? this.proxy.createSnapshot() : new Object();
    }

    public void restoreFromSnapshot(Object snapshot) {
        if (this.proxy != null) {
            this.proxy.restoreFromSnapshot(snapshot);
        }
    }

    public boolean isEmpty() {
        IItemTransfer iItemTransfer = this.proxy;
        if (iItemTransfer instanceof NotifiableItemStackHandler) {
            NotifiableItemStackHandler itemStackHandler = (NotifiableItemStackHandler)iItemTransfer;
            return itemStackHandler.isEmpty();
        }
        boolean isEmpty = true;
        if (this.proxy != null) {
            for (int i = 0; i < this.proxy.getSlots(); ++i) {
                if (this.proxy.getStackInSlot(i).m_41619_()) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    public void exportToNearby(Direction ... facings) {
        if (this.isEmpty()) {
            return;
        }
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            ItemTransferHelper.exportToTarget((IItemTransfer)this, (int)Integer.MAX_VALUE, f -> true, (Level)level, (BlockPos)pos.m_121945_(facing), (Direction)facing.m_122424_());
        }
    }

    @Override
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }

    public ItemHandlerProxyTrait setProxy(@Nullable IItemTransfer proxy) {
        this.proxy = proxy;
        return this;
    }

    @Nullable
    public IItemTransfer getProxy() {
        return this.proxy;
    }
}

