/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.steam;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.UITemplate;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.gregtechceu.gtceu.api.machine.steam.SteamWorkableMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableFluidTank;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.data.GTMaterials;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidStorage;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class SteamBoilerMachine
extends SteamWorkableMachine
implements IUIMachine,
IExplosionMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(SteamBoilerMachine.class, SteamWorkableMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    public final NotifiableFluidTank waterTank;
    @Persisted
    @DescSynced
    private int currentTemperature;
    @Persisted
    private int timeBeforeCoolingDown;
    private boolean hasNoWater;
    @Nullable
    protected TickableSubscription temperatureSubs;
    @Nullable
    protected TickableSubscription autoOutputSubs;
    @Nullable
    protected ISubscription steamTankSubs;

    public SteamBoilerMachine(IMachineBlockEntity holder, boolean isHighPressure, Object ... args) {
        super(holder, isHighPressure, args);
        this.waterTank = this.createWaterTank(args);
        this.waterTank.setFilter(fluid -> Fluids.f_76193_ == fluid.getFluid());
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    protected NotifiableFluidTank createSteamTank(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, 1, 16L * FluidHelper.getBucket(), IO.OUT);
    }

    protected NotifiableFluidTank createWaterTank(Object ... args) {
        return new NotifiableFluidTank((MetaMachine)this, 1, 16L * FluidHelper.getBucket(), IO.IN);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, this::updateAutoOutputSubscription));
        }
        this.updateSteamSubscription();
        this.steamTankSubs = this.steamTank.addChangedListener(this::updateAutoOutputSubscription);
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.steamTankSubs != null) {
            this.steamTankSubs.unsubscribe();
            this.steamTankSubs = null;
        }
    }

    @Override
    public void setOutputFacing(@NotNull Direction outputFacing) {
    }

    @Override
    public void onNeighborChanged(Block block, BlockPos fromPos, boolean isMoving) {
        super.onNeighborChanged(block, fromPos, isMoving);
        this.updateAutoOutputSubscription();
    }

    protected void updateAutoOutputSubscription() {
        if (Direction.m_235666_().filter(direction -> direction != this.getFrontFacing() && direction != Direction.DOWN).anyMatch(direction -> FluidTransferHelper.getFluidTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(direction), (Direction)direction.m_122424_()) != null)) {
            this.autoOutputSubs = this.subscribeServerTick(this.autoOutputSubs, this::autoOutput);
        } else if (this.autoOutputSubs != null) {
            this.autoOutputSubs.unsubscribe();
            this.autoOutputSubs = null;
        }
    }

    protected void autoOutput() {
        if (this.getOffsetTimer() % 5L == 0L) {
            this.steamTank.exportToNearby((Direction[])Direction.m_235666_().filter(direction -> direction != this.getFrontFacing() && direction != Direction.DOWN).filter(direction -> FluidTransferHelper.getFluidTransfer((Level)this.getLevel(), (BlockPos)this.getPos().m_121945_(direction), (Direction)direction.m_122424_()) != null).toArray(Direction[]::new));
            this.updateAutoOutputSubscription();
        }
    }

    protected void updateSteamSubscription() {
        if (this.currentTemperature > 0) {
            this.temperatureSubs = this.subscribeServerTick(this.temperatureSubs, this::updateCurrentTemperature);
        } else if (this.temperatureSubs != null) {
            this.temperatureSubs.unsubscribe();
            this.temperatureSubs = null;
        }
    }

    protected void updateCurrentTemperature() {
        if (this.recipeLogic.isWorking()) {
            if (this.getOffsetTimer() % 12L == 0L && this.currentTemperature < this.getMaxTemperature()) {
                if (this.isHighPressure) {
                    ++this.currentTemperature;
                } else if (this.getOffsetTimer() % 24L == 0L) {
                    ++this.currentTemperature;
                }
            }
        } else if (this.timeBeforeCoolingDown == 0) {
            if (this.currentTemperature > 0) {
                this.currentTemperature -= this.getCoolDownRate();
                this.timeBeforeCoolingDown = this.getCooldownInterval();
            }
        } else {
            --this.timeBeforeCoolingDown;
        }
        if (this.getOffsetTimer() % 10L == 0L) {
            if (this.currentTemperature >= 100) {
                Level level;
                long fillAmount = (long)((double)this.getBaseSteamOutput() * ((double)this.currentTemperature / ((double)this.getMaxTemperature() * 1.0)) / 2.0);
                boolean hasDrainedWater = !this.waterTank.drainInternal(FluidHelper.getBucket() / 1000L, false).isEmpty();
                long filledSteam = 0L;
                if (hasDrainedWater) {
                    filledSteam = this.steamTank.fillInternal(GTMaterials.Steam.getFluid(fillAmount * FluidHelper.getBucket() / 1000L), false);
                }
                if (this.hasNoWater && hasDrainedWater) {
                    this.doExplosion(2.0f);
                } else {
                    boolean bl = this.hasNoWater = !hasDrainedWater;
                }
                if (filledSteam == 0L && hasDrainedWater && (level = this.getLevel()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    float x = (float)this.getPos().m_123341_() + 0.5f;
                    float y = (float)this.getPos().m_123342_() + 0.5f;
                    float z = (float)this.getPos().m_123343_() + 0.5f;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, (double)x + (double)this.getFrontFacing().m_122429_() * 0.6, (double)y + (double)this.getFrontFacing().m_122430_() * 0.6, (double)z + (double)this.getFrontFacing().m_122431_() * 0.6, 7 + GTValues.RNG.m_188503_(3), (double)this.getFrontFacing().m_122429_() / 2.0, (double)this.getFrontFacing().m_122430_() / 2.0, (double)this.getFrontFacing().m_122431_() / 2.0, 0.1);
                    if (ConfigHolder.INSTANCE.machines.machineSounds) {
                        this.getLevel().m_6263_(null, (double)x, (double)y, (double)z, SoundEvents.f_12031_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    this.steamTank.drainInternal(FluidHelper.getBucket() * 4L, false);
                }
            } else {
                this.hasNoWater = false;
            }
        }
        this.updateSteamSubscription();
    }

    protected int getCooldownInterval() {
        return this.isHighPressure ? 40 : 45;
    }

    protected int getCoolDownRate() {
        return 1;
    }

    public int getMaxTemperature() {
        return this.isHighPressure ? 1000 : 500;
    }

    private double getTemperaturePercent() {
        return (double)this.currentTemperature / ((double)this.getMaxTemperature() * 1.0);
    }

    protected abstract long getBaseSteamOutput();

    @Nullable
    public static GTRecipe recipeModifier(MetaMachine machine, @Nonnull GTRecipe recipe) {
        if (machine instanceof SteamBoilerMachine) {
            SteamBoilerMachine boilerMachine = (SteamBoilerMachine)machine;
            recipe = recipe.copy();
            recipe.duration = boilerMachine.isHighPressure ? recipe.duration / 2 : recipe.duration;
            return recipe;
        }
        return null;
    }

    @Override
    public void onWorking() {
        if (this.currentTemperature < this.getMaxTemperature()) {
            this.currentTemperature = Math.max(1, this.currentTemperature);
            this.updateSteamSubscription();
        }
    }

    @Override
    public void afterWorking() {
        super.afterWorking();
        this.timeBeforeCoolingDown = this.getCooldownInterval();
    }

    @Override
    protected InteractionResult onSoftMalletClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    public ModularUI createUI(Player entityPlayer) {
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).background(new IGuiTexture[]{GuiTextures.BACKGROUND_STEAM.get(this.isHighPressure)}).widget((Widget)new LabelWidget(6, 6, this.getBlockState().m_60734_().m_7705_())).widget((Widget)new ProgressWidget(this::getTemperaturePercent, 96, 26, 10, 54).setProgressTexture((IGuiTexture)GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.isHighPressure), (IGuiTexture)GuiTextures.PROGRESS_BAR_BOILER_HEAT).setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP).setDynamicHoverTips(pct -> I18n.m_118938_((String)"gtceu.multiblock.large_boiler.temperature", (Object[])new Object[]{(int)((double)this.currentTemperature + 274.15), (int)((double)this.getMaxTemperature() + 274.15)}))).widget((Widget)new TankWidget((IFluidStorage)this.waterTank.storages[0], 83, 26, 10, 54, false, true).setShowAmount(false).setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP).setBackground((IGuiTexture)GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.isHighPressure))).widget((Widget)new TankWidget((IFluidStorage)this.steamTank.storages[0], 70, 26, 10, 54, true, false).setShowAmount(false).setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP).setBackground((IGuiTexture)GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.isHighPressure))).widget((Widget)new ImageWidget(43, 44, 18, 18, (IGuiTexture)GuiTextures.CANISTER_OVERLAY_STEAM.get(this.isHighPressure))).widget((Widget)UITemplate.bindPlayerInventory(entityPlayer.m_150109_(), (IGuiTexture)GuiTextures.SLOT_STEAM.get(this.isHighPressure), 7, 84, true));
    }

    @Override
    public void animateTick(RandomSource random) {
        if (this.isActive()) {
            BlockPos pos = this.getPos();
            float x = (float)pos.m_123341_() + 0.5f;
            float z = (float)pos.m_123343_() + 0.5f;
            Direction facing = this.getFrontFacing();
            float horizontalOffset = random.m_188501_() * 0.6f - 0.3f;
            float y = (float)pos.m_123342_() + random.m_188501_() * 0.375f;
            if (facing.m_122434_() == Direction.Axis.X) {
                x = facing.m_122421_() == Direction.AxisDirection.POSITIVE ? (x += 0.52f) : (x -= 0.52f);
                z += horizontalOffset;
            } else if (facing.m_122434_() == Direction.Axis.Z) {
                z = facing.m_122421_() == Direction.AxisDirection.POSITIVE ? (z += 0.52f) : (z -= 0.52f);
                x += horizontalOffset;
            }
            this.randomDisplayTick(random, x, y, z);
        }
    }

    protected void randomDisplayTick(RandomSource random, float x, float y, float z) {
        this.getLevel().m_7106_((ParticleOptions)(this.isHighPressure ? ParticleTypes.f_123755_ : ParticleTypes.f_123762_), (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        this.getLevel().m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
    }

    public boolean isHasNoWater() {
        return this.hasNoWater;
    }
}

