/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.multiblock;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.recipe.EURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.IFancyUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.IOverclockMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IDisplayUIMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.WorkableMultiblockMachine;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.ComponentPanelWidget;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WorkableElectricMultiblockMachine
extends WorkableMultiblockMachine
implements IFancyUIMachine,
IDisplayUIMachine,
ITieredMachine,
IOverclockMachine {
    private long maxHatchVoltage = -1L;

    public WorkableElectricMultiblockMachine(IMachineBlockEntity holder, Object ... args) {
        super(holder, args);
    }

    @Override
    public void onStructureInvalid() {
        super.onStructureInvalid();
        this.maxHatchVoltage = -1L;
    }

    @Override
    public void onStructureFormed() {
        this.maxHatchVoltage = -1L;
        super.onStructureFormed();
    }

    @Override
    public void onPartUnload() {
        super.onPartUnload();
        this.maxHatchVoltage = -1L;
    }

    @Override
    public void addDisplayText(List<Component> textList) {
        IDisplayUIMachine.super.addDisplayText(textList);
        if (this.isFormed()) {
            long maxVoltage = this.getMaxVoltage();
            if (maxVoltage > 0L) {
                String voltageName = GTValues.VNF[GTUtil.getFloorTierByVoltage(maxVoltage)];
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.max_energy_per_tick", (Object[])new Object[]{maxVoltage, voltageName}));
            }
            textList.add((Component)Component.m_237115_((String)this.getRecipeType().registryName.m_214298_()).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.AQUA).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237115_((String)"gtceu.gui.machinemode.title")))));
            if (!this.isWorkingEnabled()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.work_paused"));
            } else if (this.isActive()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.running"));
                int currentProgress = (int)(this.recipeLogic.getProgressPercent() * 100.0);
                textList.add((Component)Component.m_237110_((String)"gtceu.multiblock.progress", (Object[])new Object[]{currentProgress}));
            } else {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.idling"));
            }
            if (this.recipeLogic.isWaiting()) {
                textList.add((Component)Component.m_237115_((String)"gtceu.multiblock.waiting").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED)));
            }
        }
        this.getDefinition().getAdditionalDisplay().accept(this, textList);
    }

    @Override
    public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 178, 137);
        WidgetGroup container = new WidgetGroup(4, 4, 170, 129);
        container.addWidget((Widget)new DraggableScrollableWidgetGroup(4, 4, 162, 121).setBackground(this.getScreenTexture()).addWidget((Widget)new LabelWidget(4, 5, this.self().getBlockState().m_60734_().m_7705_())).addWidget((Widget)new ComponentPanelWidget(4, 17, this::addDisplayText).setMaxWidthLimit(150).clickHandler(this::handleDisplayClick)));
        container.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)container);
        return group;
    }

    @Override
    public ModularUI createUI(Player entityPlayer) {
        return IFancyUIMachine.super.createUI(entityPlayer);
    }

    @Override
    public List<IFancyUIProvider> getSubTabs() {
        return this.getParts().stream().filter(IFancyUIProvider.class::isInstance).map(IFancyUIProvider.class::cast).toList();
    }

    @Override
    public void attachTooltips(TooltipsPanel tooltipsPanel) {
        for (IMultiPart part : this.getParts()) {
            part.attachFancyTooltipsToController(this, tooltipsPanel);
        }
    }

    @Override
    public int getOverclockTier() {
        return this.getTier();
    }

    @Override
    public int getMaxOverclockTier() {
        return this.getTier();
    }

    @Override
    public int getMinOverclockTier() {
        return this.getTier();
    }

    @Override
    public void setOverclockTier(int tier) {
    }

    @Override
    public long getOverclockVoltage() {
        return this.getMaxVoltage();
    }

    @Override
    public int getTier() {
        return GTUtil.getFloorTierByVoltage(this.getMaxVoltage());
    }

    public long getMaxHatchVoltage() {
        block2: {
            List capabilities;
            block3: {
                if (this.maxHatchVoltage >= 0L) break block2;
                this.maxHatchVoltage = 0L;
                capabilities = (List)this.capabilitiesProxy.get((Object)IO.IN, (Object)EURecipeCapability.CAP);
                if (capabilities == null) break block3;
                for (IRecipeHandler handler : capabilities) {
                    if (!(handler instanceof IEnergyContainer)) continue;
                    IEnergyContainer container = (IEnergyContainer)((Object)handler);
                    this.maxHatchVoltage += container.getInputVoltage() * container.getInputAmperage();
                }
                break block2;
            }
            capabilities = (List)this.capabilitiesProxy.get((Object)IO.OUT, (Object)EURecipeCapability.CAP);
            if (capabilities == null) break block2;
            for (IRecipeHandler handler : capabilities) {
                if (!(handler instanceof IEnergyContainer)) continue;
                IEnergyContainer container = (IEnergyContainer)((Object)handler);
                this.maxHatchVoltage += container.getOutputVoltage() * container.getOutputAmperage();
            }
        }
        return this.maxHatchVoltage;
    }

    public long getMaxVoltage() {
        return GTValues.V[GTUtil.getFloorTierByVoltage(this.getMaxHatchVoltage())];
    }
}

