/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.fancyconfigurator;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;

public class MachineModeFancyConfigurator
implements IFancyConfigurator {
    protected IRecipeLogicMachine machine;

    public MachineModeFancyConfigurator(IRecipeLogicMachine machine) {
        this.machine = machine;
    }

    @Override
    public String getTitle() {
        return "gtceu.gui.machinemode.title";
    }

    @Override
    public IGuiTexture getIcon() {
        return new ResourceTexture("gtceu:textures/item/lv_robot_arm.png");
    }

    @Override
    public void writeInitialData(FriendlyByteBuf buffer) {
        buffer.m_130130_(this.machine.getActiveRecipeType());
    }

    @Override
    public void readInitialData(FriendlyByteBuf buffer) {
        this.machine.setActiveRecipeType(buffer.m_130242_());
    }

    @Override
    public void detectAndSendChange(BiConsumer<Integer, Consumer<FriendlyByteBuf>> sender) {
        sender.accept(0, buf -> buf.m_130130_(this.machine.getActiveRecipeType()));
    }

    @Override
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == 0) {
            this.machine.setActiveRecipeType(buffer.m_130242_());
        }
    }

    @Override
    public Widget createConfigurator() {
        WidgetGroup group = new WidgetGroup(0, 0, 140, 20 * this.machine.getRecipeTypes().length + 4);
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        for (int i = 0; i < this.machine.getRecipeTypes().length; ++i) {
            int finalI = i;
            group.addWidget((Widget)new ButtonWidget(2, 2 + i * 20, 136, 20, IGuiTexture.EMPTY, cd -> this.machine.setActiveRecipeType(finalI)));
            group.addWidget((Widget)new ImageWidget(2, 2 + i * 20, 136, 20, () -> new GuiTextureGroup(new IGuiTexture[]{ResourceBorderTexture.BUTTON_COMMON.copy().setColor(this.machine.getActiveRecipeType() == finalI ? ColorPattern.CYAN.color : -1), new TextTexture(this.machine.getRecipeTypes()[finalI].registryName.m_214298_()).setWidth(136).setType(TextTexture.TextType.ROLL)})));
        }
        return group;
    }

    @Override
    public List<Component> getTooltips() {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)Component.m_237113_((String)"Change active Machine Mode"));
        return tooltip;
    }
}

