/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.fancyconfigurator;

import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.lang.LangHandler;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import com.lowdragmc.lowdraglib.gui.widget.LabelWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class CircuitFancyConfigurator
implements IFancyConfigurator {
    final ItemStackTransfer circuitSlot;

    public CircuitFancyConfigurator(ItemStackTransfer circuitSlot) {
        this.circuitSlot = circuitSlot;
    }

    @Override
    public String getTitle() {
        return "gtceu.gui.circuit.title";
    }

    @Override
    public IGuiTexture getIcon() {
        if (IntCircuitBehaviour.isIntegratedCircuit(this.circuitSlot.getStackInSlot(0))) {
            return new ItemStackTexture(new ItemStack[]{this.circuitSlot.getStackInSlot(0)});
        }
        return new GuiTextureGroup(new IGuiTexture[]{new ItemStackTexture(new ItemStack[]{IntCircuitBehaviour.stack(0)}), new ItemStackTexture(new Item[]{Items.f_42127_})});
    }

    @Override
    public Widget createConfigurator() {
        int x;
        WidgetGroup group = new WidgetGroup(0, 0, 174, 132);
        group.setBackground(new IGuiTexture[]{GuiTextures.BACKGROUND_INVERSE});
        group.addWidget((Widget)new LabelWidget(9, 8, "Programmed Circuit Configuration"));
        group.addWidget(new SlotWidget((IItemTransfer)this.circuitSlot, 0, (group.getSize().width - 18) / 2, 20, !ConfigHolder.INSTANCE.machines.ghostCircuit, !ConfigHolder.INSTANCE.machines.ghostCircuit).setBackground(new IGuiTexture[]{new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.INT_CIRCUIT_OVERLAY})}));
        if (ConfigHolder.INSTANCE.machines.ghostCircuit) {
            group.addWidget((Widget)new ButtonWidget((group.getSize().width - 18) / 2, 20, 18, 18, IGuiTexture.EMPTY, clickData -> {
                if (!clickData.isRemote) {
                    this.circuitSlot.setStackInSlot(0, ItemStack.f_41583_);
                    this.circuitSlot.onContentsChanged(0);
                }
            }));
        }
        int idx = 0;
        for (x = 0; x <= 2; ++x) {
            for (int y = 0; y <= 8; ++y) {
                int finalIdx = idx++;
                group.addWidget((Widget)new ButtonWidget(5 + 18 * y, 48 + 18 * x, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, new ItemStackTexture(new ItemStack[]{IntCircuitBehaviour.stack(finalIdx)}).scale(0.8888889f)}), clickData -> {
                    if (!clickData.isRemote) {
                        ItemStack stack = this.circuitSlot.getStackInSlot(0).m_41777_();
                        if (IntCircuitBehaviour.isIntegratedCircuit(stack)) {
                            IntCircuitBehaviour.setCircuitConfiguration(stack, finalIdx);
                            this.circuitSlot.setStackInSlot(0, stack);
                        } else if (ConfigHolder.INSTANCE.machines.ghostCircuit) {
                            this.circuitSlot.setStackInSlot(0, IntCircuitBehaviour.stack(finalIdx));
                        }
                        this.circuitSlot.onContentsChanged(0);
                    }
                }));
            }
        }
        for (x = 0; x <= 5; ++x) {
            int finalIdx = x + 27;
            group.addWidget((Widget)new ButtonWidget(5 + 18 * x, 102, 18, 18, (IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{GuiTextures.SLOT, new ItemStackTexture(new ItemStack[]{IntCircuitBehaviour.stack(finalIdx)}).scale(0.8888889f)}), clickData -> {
                if (!clickData.isRemote) {
                    ItemStack stack = this.circuitSlot.getStackInSlot(0).m_41777_();
                    if (IntCircuitBehaviour.isIntegratedCircuit(stack)) {
                        IntCircuitBehaviour.setCircuitConfiguration(stack, finalIdx);
                        this.circuitSlot.setStackInSlot(0, stack);
                    } else if (ConfigHolder.INSTANCE.machines.ghostCircuit) {
                        this.circuitSlot.setStackInSlot(0, IntCircuitBehaviour.stack(finalIdx));
                    }
                    this.circuitSlot.onContentsChanged(0);
                }
            }));
        }
        return group;
    }

    @Override
    public List<Component> getTooltips() {
        ArrayList<Component> list = new ArrayList<Component>(IFancyConfigurator.super.getTooltips());
        list.addAll(Arrays.stream(LangHandler.getMultiLang("gtceu.gui.configurator_slot.tooltip").toArray(new MutableComponent[0])).toList());
        return list;
    }
}

