/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.editor.EditableUI;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.TickableSubscription;
import com.gregtechceu.gtceu.api.machine.TieredMachine;
import com.gregtechceu.gtceu.api.machine.feature.IExplosionMachine;
import com.gregtechceu.gtceu.api.machine.feature.ITieredMachine;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableEnergyContainer;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.util.Mth;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TieredEnergyMachine
extends TieredMachine
implements ITieredMachine,
IExplosionMachine {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(TieredEnergyMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    @Persisted
    @DescSynced
    public final NotifiableEnergyContainer energyContainer;
    protected TickableSubscription explosionSubs;
    protected ISubscription energyListener;

    public TieredEnergyMachine(IMachineBlockEntity holder, int tier, Object ... args) {
        super(holder, tier);
        this.energyContainer = this.createEnergyContainer(args);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    protected NotifiableEnergyContainer createEnergyContainer(Object ... args) {
        long tierVoltage = GTValues.V[this.tier];
        if (this.isEnergyEmitter()) {
            return NotifiableEnergyContainer.emitterContainer(this, tierVoltage * 64L, tierVoltage, this.getMaxInputOutputAmperage());
        }
        return NotifiableEnergyContainer.receiverContainer(this, tierVoltage * 64L, tierVoltage, this.getMaxInputOutputAmperage());
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.isRemote() && ConfigHolder.INSTANCE.machines.doTerrainExplosion && this.shouldWeatherOrTerrainExplosion()) {
            this.energyListener = this.energyContainer.addChangedListener(this::updateExplosionSubscription);
            this.updateExplosionSubscription();
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        if (this.energyListener != null) {
            this.energyListener.unsubscribe();
            this.energyListener = null;
        }
    }

    protected void updateExplosionSubscription() {
        if (ConfigHolder.INSTANCE.machines.doTerrainExplosion && this.shouldWeatherOrTerrainExplosion() && this.energyContainer.getEnergyStored() > 0L) {
            this.explosionSubs = this.subscribeServerTick(this.explosionSubs, this::checkExplosion);
        } else if (this.explosionSubs != null) {
            this.explosionSubs.unsubscribe();
            this.explosionSubs = null;
        }
    }

    protected void checkExplosion() {
        this.checkWeatherOrTerrainExplosion(this.tier, this.tier * 10);
        this.updateExplosionSubscription();
    }

    @Override
    public int getAnalogOutputSignal() {
        long energyStored = this.energyContainer.getEnergyStored();
        long energyCapacity = this.energyContainer.getEnergyCapacity();
        float f = energyCapacity == 0L ? 0.0f : (float)energyStored / ((float)energyCapacity * 1.0f);
        return Mth.m_14143_((float)(f * 14.0f)) + (energyStored > 0L ? 1 : 0);
    }

    protected long getMaxInputOutputAmperage() {
        return 1L;
    }

    protected boolean isEnergyEmitter() {
        return false;
    }

    protected static EditableUI<ProgressWidget, TieredEnergyMachine> createEnergyBar() {
        return new EditableUI<ProgressWidget, TieredEnergyMachine>("energy_container", ProgressWidget.class, () -> {
            ProgressWidget progressBar = new ProgressWidget(ProgressWidget.JEIProgress, 0, 0, 18, 60, new ProgressTexture(IGuiTexture.EMPTY, (IGuiTexture)GuiTextures.ENERGY_BAR_BASE));
            progressBar.setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP);
            progressBar.setBackground(new IGuiTexture[]{GuiTextures.ENERGY_BAR_BACKGROUND});
            return progressBar;
        }, (progressBar, machine) -> progressBar.setProgressSupplier(() -> (double)machine.energyContainer.getEnergyStored() * 1.0 / (double)machine.energyContainer.getEnergyCapacity()));
    }
}

