/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine;

import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.utils.ShapeUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MachineDefinition
implements Supplier<IMachineBlock> {
    private final ResourceLocation id;
    private Supplier<? extends Block> blockSupplier;
    private Supplier<? extends MetaMachineItem> itemSupplier;
    private Supplier<BlockEntityType<? extends BlockEntity>> blockEntityTypeSupplier;
    private Function<IMachineBlockEntity, MetaMachine> machineSupplier;
    @Nullable
    private GTRecipeType[] recipeTypes;
    private int tier;
    private int defaultPaintingColor;
    private BiFunction<MetaMachine, GTRecipe, GTRecipe> recipeModifier;
    private boolean alwaysTryModifyRecipe;
    private IRenderer renderer;
    private VoxelShape shape;
    private final Map<Direction, VoxelShape> cache = new EnumMap<Direction, VoxelShape>(Direction.class);
    private BiConsumer<ItemStack, List<Component>> tooltipBuilder;
    private Supplier<BlockState> appearance;
    @Nullable
    private EditableMachineUI editableUI;
    private Object2IntMap<RecipeCapability<?>> recipeOutputLimits = new Object2IntOpenHashMap();

    protected MachineDefinition(ResourceLocation id) {
        this.id = id;
    }

    public static MachineDefinition createDefinition(ResourceLocation id) {
        return new MachineDefinition(id);
    }

    public Block getBlock() {
        return this.blockSupplier.get();
    }

    public MetaMachineItem getItem() {
        return this.itemSupplier.get();
    }

    public BlockEntityType<? extends BlockEntity> getBlockEntityType() {
        return this.blockEntityTypeSupplier.get();
    }

    public MetaMachine createMetaMachine(IMachineBlockEntity blockEntity) {
        return this.machineSupplier.apply(blockEntity);
    }

    public ItemStack asStack() {
        return new ItemStack((ItemLike)this.getItem());
    }

    public ItemStack asStack(int count) {
        return new ItemStack((ItemLike)this.getItem(), count);
    }

    public VoxelShape getShape(Direction direction) {
        if (this.shape.m_83281_() || this.shape == Shapes.m_83144_() || direction == Direction.NORTH) {
            return this.shape;
        }
        return this.cache.computeIfAbsent(direction, dir -> ShapeUtils.rotate((VoxelShape)this.shape, (Direction)dir));
    }

    @Override
    public IMachineBlock get() {
        return (IMachineBlock)this.blockSupplier.get();
    }

    public String getName() {
        return this.id.m_135815_();
    }

    public String toString() {
        return "[Definition: %s]".formatted(this.id);
    }

    public String getDescriptionId() {
        return this.getBlock().m_7705_();
    }

    public BlockState defaultBlockState() {
        return this.getBlock().m_49966_();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachineDefinition that = (MachineDefinition)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void setBlockSupplier(Supplier<? extends Block> blockSupplier) {
        this.blockSupplier = blockSupplier;
    }

    public void setItemSupplier(Supplier<? extends MetaMachineItem> itemSupplier) {
        this.itemSupplier = itemSupplier;
    }

    public void setBlockEntityTypeSupplier(Supplier<BlockEntityType<? extends BlockEntity>> blockEntityTypeSupplier) {
        this.blockEntityTypeSupplier = blockEntityTypeSupplier;
    }

    public void setMachineSupplier(Function<IMachineBlockEntity, MetaMachine> machineSupplier) {
        this.machineSupplier = machineSupplier;
    }

    @Nullable
    public GTRecipeType[] getRecipeTypes() {
        return this.recipeTypes;
    }

    public void setRecipeTypes(@Nullable GTRecipeType[] recipeTypes) {
        this.recipeTypes = recipeTypes;
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public void setDefaultPaintingColor(int defaultPaintingColor) {
        this.defaultPaintingColor = defaultPaintingColor;
    }

    public int getDefaultPaintingColor() {
        return this.defaultPaintingColor;
    }

    public void setRecipeModifier(BiFunction<MetaMachine, GTRecipe, GTRecipe> recipeModifier) {
        this.recipeModifier = recipeModifier;
    }

    public BiFunction<MetaMachine, GTRecipe, GTRecipe> getRecipeModifier() {
        return this.recipeModifier;
    }

    public void setAlwaysTryModifyRecipe(boolean alwaysTryModifyRecipe) {
        this.alwaysTryModifyRecipe = alwaysTryModifyRecipe;
    }

    public boolean isAlwaysTryModifyRecipe() {
        return this.alwaysTryModifyRecipe;
    }

    public void setRenderer(IRenderer renderer) {
        this.renderer = renderer;
    }

    public IRenderer getRenderer() {
        return this.renderer;
    }

    public void setShape(VoxelShape shape) {
        this.shape = shape;
    }

    public BiConsumer<ItemStack, List<Component>> getTooltipBuilder() {
        return this.tooltipBuilder;
    }

    public void setTooltipBuilder(BiConsumer<ItemStack, List<Component>> tooltipBuilder) {
        this.tooltipBuilder = tooltipBuilder;
    }

    public Supplier<BlockState> getAppearance() {
        return this.appearance;
    }

    public void setAppearance(Supplier<BlockState> appearance) {
        this.appearance = appearance;
    }

    @Nullable
    public EditableMachineUI getEditableUI() {
        return this.editableUI;
    }

    public void setEditableUI(@Nullable EditableMachineUI editableUI) {
        this.editableUI = editableUI;
    }

    public Object2IntMap<RecipeCapability<?>> getRecipeOutputLimits() {
        return this.recipeOutputLimits;
    }

    public void setRecipeOutputLimits(Object2IntMap<RecipeCapability<?>> recipeOutputLimits) {
        this.recipeOutputLimits = recipeOutputLimits;
    }
}

