/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.gregtechceu.gtceu.utils.TaskHandler;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class TreeFellingHelper {
    public void fellTree(ItemStack stack, Level level, BlockState origin, BlockPos originPos, LivingEntity miner) {
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        ArrayDeque<BlockPos> checking = new ArrayDeque<BlockPos>();
        ObjectOpenHashSet visited = new ObjectOpenHashSet();
        checking.add(originPos);
        while (!checking.isEmpty()) {
            BlockPos check = (BlockPos)checking.remove();
            if (check != originPos) {
                visited.add(check);
            }
            for (int y = 0; y <= 1; ++y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        mutablePos.m_122178_(check.m_123341_() + x, check.m_123342_() + y, check.m_123343_() + z);
                        if (visited.contains(mutablePos) || origin.m_60734_() != level.m_8055_((BlockPos)mutablePos).m_60734_() || checking.contains(mutablePos)) continue;
                        BlockPos immutablePos = mutablePos.m_7949_();
                        checking.add(immutablePos);
                    }
                }
            }
        }
        if (!visited.isEmpty() && miner instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)miner;
            List orderedBlocks = visited.stream().sorted(Comparator.comparingInt(pos -> pos.m_123342_() - originPos.m_123342_())).collect(Collectors.toCollection(LinkedList::new));
            int durabilityLeft = stack.m_41776_() - stack.m_41773_();
            if (durabilityLeft < orderedBlocks.size()) {
                orderedBlocks.subList(durabilityLeft, orderedBlocks.size()).clear();
            }
            stack.m_41622_(orderedBlocks.size(), (LivingEntity)serverPlayer, p -> p.m_21166_(EquipmentSlot.MAINHAND));
            this.breakBlocksPerTick(serverPlayer, orderedBlocks, origin.m_60734_());
        }
    }

    public void breakBlocksPerTick(ServerPlayer player, List<BlockPos> posList, Block originBlock) {
        for (int i = 0; i < posList.size(); ++i) {
            int delayTick = i * 2;
            BlockPos pos = posList.get(i);
            TaskHandler.enqueueServerTask(player.m_284548_(), () -> {
                if (player.m_9236_().m_8055_(pos).m_60713_(originBlock)) {
                    player.m_9236_().m_46961_(pos, true);
                }
            }, delayTick);
        }
    }
}

