/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.forge;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.FluidProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import com.gregtechceu.gtceu.client.renderer.item.GTBucketItemRenderer;
import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;

public class GTBucketItem
extends BucketItem
implements IItemRendererProvider {
    IRenderer renderer;
    final Material material;
    final String langKey;

    public GTBucketItem(Supplier<? extends Fluid> fluid, Item.Properties properties, boolean isGas, Material material, String langKey) {
        super(fluid, properties);
        this.renderer = isGas ? GTBucketItemRenderer.INSTANCE_GAS : GTBucketItemRenderer.INSTANCE;
        this.material = material;
        this.langKey = langKey;
    }

    public IRenderer getRenderer(ItemStack stack) {
        return this.renderer;
    }

    public static int color(ItemStack itemStack, int index) {
        Item item = itemStack.m_41720_();
        if (item instanceof GTBucketItem) {
            GTBucketItem item2 = (GTBucketItem)item;
            if (index == 1) {
                return FluidHelper.getColor((FluidStack)FluidStack.create((Fluid)item2.getFluid(), (long)FluidHelper.getBucket()));
            }
        }
        return -1;
    }

    public ICapabilityProvider initCapabilities(@Nonnull ItemStack stack, @Nullable CompoundTag nbt) {
        return ((Object)((Object)this)).getClass() == GTBucketItem.class ? new FluidBucketWrapper(stack) : super.initCapabilities(stack, nbt);
    }

    public String m_5524_() {
        return "item.gtceu.bucket";
    }

    public Component m_41466_() {
        MutableComponent materialName = this.material.getLocalizedName();
        return Component.m_237110_((String)"item.gtceu.bucket", (Object[])new Object[]{Component.m_237110_((String)this.langKey, (Object[])new Object[]{materialName})});
    }

    public Component m_7626_(ItemStack stack) {
        return this.m_41466_();
    }

    public int getBurnTime(ItemStack itemStack, @Nullable RecipeType<?> recipeType) {
        Fluid fluid;
        FluidProperty property = this.material.getProperty(PropertyKey.FLUID);
        if (property != null && (fluid = this.material.getFluid()) instanceof GTFluid) {
            GTFluid gtFluid = (GTFluid)fluid;
            return gtFluid.getBurnTime();
        }
        return -1;
    }
}

