/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.DustProperty;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.forge.TagPrefixItemImpl;
import com.gregtechceu.gtceu.client.renderer.item.TagPrefixItemRenderer;
import com.gregtechceu.gtceu.common.data.GTDamageTypes;
import com.lowdragmc.lowdraglib.Platform;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class TagPrefixItem
extends Item {
    public final TagPrefix tagPrefix;
    public final Material material;

    protected TagPrefixItem(Item.Properties properties, TagPrefix tagPrefix, Material material) {
        super(properties);
        this.tagPrefix = tagPrefix;
        this.material = material;
        if (Platform.isClient()) {
            TagPrefixItemRenderer.create(this, tagPrefix.materialIconType(), material.getMaterialIconSet());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static TagPrefixItem create(Item.Properties properties, TagPrefix tagPrefix, Material material) {
        void var2_2;
        void var1_1;
        return TagPrefixItemImpl.create(properties, (TagPrefix)var1_1, (Material)var2_2);
    }

    public void onRegister() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ItemColor tintColor() {
        return (itemStack, index) -> {
            Item patt2194$temp = itemStack.m_41720_();
            if (patt2194$temp instanceof TagPrefixItem) {
                TagPrefixItem tagPrefixItem = (TagPrefixItem)patt2194$temp;
                return tagPrefixItem.material.getLayerARGB(index);
            }
            return -1;
        };
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        if (this.tagPrefix.tooltip() != null) {
            this.tagPrefix.tooltip().accept(this.material, tooltipComponents);
        }
    }

    public String m_5524_() {
        return this.tagPrefix.getUnlocalizedName(this.material);
    }

    public String m_5671_(ItemStack stack) {
        return this.tagPrefix.getUnlocalizedName(this.material);
    }

    public Component m_41466_() {
        return this.tagPrefix.getLocalizedName(this.material);
    }

    public Component m_7626_(ItemStack stack) {
        return this.m_41466_();
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.m_6883_(stack, level, entity, slotId, isSelected);
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.f_19797_ % 20 == 0) {
                if (this.tagPrefix != TagPrefix.ingotHot || !this.material.hasProperty(PropertyKey.BLAST)) {
                    return;
                }
                float heatDamage = (float)(this.material.getBlastTemperature() - 1750) / 1000.0f + 2.0f;
                ItemStack armor = livingEntity.m_6844_(EquipmentSlot.CHEST);
                if ((double)heatDamage > 0.0) {
                    livingEntity.m_6469_(GTDamageTypes.HEAT.source((LevelAccessor)level), heatDamage);
                } else if ((double)heatDamage < 0.0) {
                    livingEntity.m_6469_(GTDamageTypes.FROST.source((LevelAccessor)level), -heatDamage);
                }
            }
        }
    }

    public int getItemBurnTime() {
        DustProperty property;
        DustProperty dustProperty = property = this.material == null ? null : this.material.getProperty(PropertyKey.DUST);
        if (property != null) {
            return (int)((long)property.getBurnTime() * this.tagPrefix.getMaterialAmount(this.material) / 3628800L);
        }
        return -1;
    }
}

