/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.gui.widget;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.ClickData;
import com.lowdragmc.lowdraglib.gui.widget.ButtonWidget;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PredicatedButtonWidget
extends ButtonWidget {
    private BooleanSupplier predicate;

    public PredicatedButtonWidget(int xPosition, int yPosition, int width, int height, IGuiTexture buttonTexture, Consumer<ClickData> onPressed) {
        super(xPosition, yPosition, width, height, buttonTexture, onPressed);
    }

    public PredicatedButtonWidget(int xPosition, int yPosition, int width, int height, Consumer<ClickData> onPressed) {
        super(xPosition, yPosition, width, height, onPressed);
    }

    public void writeInitialData(FriendlyByteBuf buffer) {
        super.writeInitialData(buffer);
        boolean result = this.predicate == null || this.predicate.getAsBoolean();
        this.setVisible(result);
        buffer.writeBoolean(result);
    }

    public void readInitialData(FriendlyByteBuf buffer) {
        super.readInitialData(buffer);
        this.setVisible(buffer.readBoolean());
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.predicate != null && this.isVisible() != this.predicate.getAsBoolean()) {
            this.setVisible(!this.isVisible());
            this.writeUpdateInfo(1, buf -> buf.writeBoolean(this.isVisible()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == 1) {
            this.setVisible(buffer.readBoolean());
        } else {
            super.readUpdateInfo(id, buffer);
        }
    }

    public PredicatedButtonWidget setPredicate(BooleanSupplier predicate) {
        this.predicate = predicate;
        return this;
    }
}

